#! /bin/sh
WANT_AM_VERSION=1.7

echo "***"
echo "*** Now bootstrapping the package."
echo "*** This may take a while, please be patient ..."
echo "***"
ftest_msg()
{
echo "You do not have required GNU Autotools installed, please install"
echo "recent version of GNU autoconf, automake and libtool packages."
echo "(Could not find runnable $1)"
}

ftest_am_package()
{
if test -x `which "$1-$WANT_AM_VERSION"`; then
echo "* $1-$WANT_AM_VERSION $2"
eval `$1-$WANT_AM_VERSION $2`
else
if test -x `which $1`; then
echo "* Warning! Could not find $1-$WANT_AM_VERSION!"
echo "  Trying '$1', which may fail due to incompabilities."
echo "* $1 $2"
eval `$1 $2`
else
ftest_msg "'$1-$WANT_AM_VERSION' or '$1'"
exit 1
fi
fi
}

ftest_ac_package()
{
if test -x `which $1`; then
echo "* $1 $2"
eval `$1 $2`
else
ftest_msg "'$1'"
exit 1
fi
}

ftest_package()
{
if test -x `which $1`; then
echo "* $1 $2"
eval `$1 $2`
else
echo "Could not find runnable '$1', perhaps $3 package is not installed"
echo "or it is not in the PATH. Please install $4."
exit 1
fi
}

ftest_am_package "aclocal" "-I ."
ftest_ac_package "libtoolize" "--automake --force"
ftest_am_package "automake" "-a -c --foreign"
ftest_ac_package "autoconf" ""
ftest_package "glade" "-w xmms-sid.glade" "Glade" "Glade for Gtk+1 applications (Glade v0.6.4)"
