/* ,file-id archive://[lord]/384/vu/./dstr.c/1998-05-18
*/
/*	Copyright (C) 1997 Tom Lord
 * 
 * This program is provided to you under the terms of the Liberty Software
 * License.  You are NOT permitted to redistribute, modify, or use it
 * except in very specific ways described by that license.
 *
 * This software comes with NO WARRANTY.
 * 
 * You should have received a copy of the Liberty Software License
 * along with this software; see the file =LICENSE.  If not, write to
 * the Tom Lord, 1810 Francisco St. #2, Berkeley CA, 94703, USA.  
 */



#include "xmalloc.h"
#include "dstr.h"



void
init_dstr (struct dstring * str, char * chr, int len)
{
  str->len = len;
  str->chr = xmalloc (len);
  memcpy (str->chr, chr, len);
}

void
free_dstr (struct dstring * d)
{
  free_dstr_static (d);
  xfree (d);
}

void
free_dstr_static (struct dstring * d)
{
  xfree (d->chr);
}

void
dstr_set (struct dstring * d, char * chr, int len)
{
  free_dstr_static (d);
  init_dstr (d, chr, len);
}

void
dstr_append (struct dstring * d, char * chr, int len)
{
  int new_len;
  char * new_chr;

  new_len = d->len + len;
  new_chr = (char *)xmalloc (new_len);
  memcpy (new_chr, d->chr, d->len);
  memcpy (new_chr + d->len, chr, len);
  xfree (d->chr);
  d->len = new_len;
  d->chr = new_chr;
}

int
dstr_compare (struct dstring *d, char * chr, int len)
{
  if (d->len != len)
    return 0;
  return !memcmp (d->chr, chr, len);
}
