#ifndef INC_RUNTIME_H
#define INC_RUNTIME_H

#include <time.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "times.h"

gboolean runtime_init();
float get_kbaud(int bytes_per_sec);	// returns the nearest known kbaud rate
void runtime_save();
void runtime_clear_lines();
extern GSList * lines;

struct tautohup
{	// gets saved for each line
	gboolean activated;
	gboolean logic_or;
	gboolean activity_mode;
	gboolean btime;
	int time;
	gboolean bup;
	int up;
	gboolean bdown;
	int down;
	gboolean btotal_up;
	int total_up;
	gboolean btotal_down;
	int total_down;
	// not autohup features, but they have to get saved:
	int cap_up;		// baud, guessed or from server
	int cap_down;	// baud,  do.
	int max_up;		// bytes/sec effective
	int max_down;	// bytes/sec effective
};
void runtime_read_autohup(struct tautohup * ahup);

struct tautohup_tracker
{
	int intv_up_failed;
	int intv_down_failed;
	time_t activity_detected;
};

struct tline
{
	int num;
	char * name;
	struct tautohup * ahup;
	struct tautohup_tracker ahup_tracker;
	int status;	// LCP3: CST_
	time_t server_time;
	time_t client_time;
	int up_short;
	int up_long;
	int up_total;
	int down_short;
	int down_long;
	int down_total;
	int channels;
	char snum[4];
	char schan[3];
	char sstime[20];
	char sctime[20];
	char sups[10];
	char supl[10];
	char supt[20];
	char sdns[10];
	char sdnl[10];
	char sdnt[20];
	char scap_up[10];
	char scap_dn[10];
	char smax_up[10];
	char smax_dn[10];
};
struct tline* runtime_get_line(int num);
int runtime_get_clid_line(struct tline* line);
int runtime_get_clid_lineid(int id);
struct tline* runtime_get_line_clid(int num); // client id (row)
struct tline* runtime_get_line_by_name(const char * name);
void runtime_load_line_strings(struct tline* line);

struct truntime
{
	int sock;
	int client_status;
	struct tline * selected_line; // can only change while beeing offline
	FILE * autohup_file;
	gboolean terminate;
	time_t watchdog;
	gboolean watchdog_barked;
	int linecount;
};
extern struct truntime * runtime;

#endif
