/* ------------------------------------------------------------------------
   cd_control include file for XfreeCD

   Copyright 1998 by Brian C. Lane
   http://www.brianlane.com/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   ------------------------------------------------------------------------ */
#include <linux/cdrom.h>

#define CD_DIAG         0x00
#define CD_PLAY         0x01
#define CD_PAUSE        0x02
#define CD_STOP         0x03
#define CD_EJECT        0x04
#define CD_SEEK_FWD     0x05
#define CD_SEEK_REV     0x06
#define CD_RESUME       0x07
#define CD_VOLUME       0x08
#define CD_STATUS       0x09
#define CD_TOC          0x0A
#define CD_QUIT         0x0B
#define CD_SET_EJECT    0x0C
#define CD_SET_DEVICE   0x0D


int start_cd_control( int * );


struct song_info {
  struct cdrom_tocentry te;             /* TOC entry data               */
  int                   length;         /* Length of this track in sec  */
  long                  frame_offset;   /* Frame Offset in 1/75 frames  */
};

struct CDINFO {
  unsigned long discid;                 /* cddb disc ID                 */
  int		disc;			/* disc # being played, for
  					   future support for jukeboxes
  					 */
  int		track_length;		/* Length of current track	*/
  int		cd_length;		/* Length of the CD		*/
  int		cd_remaining;		/* Remaining # of seconds on CD	*/
  int           volume;                 /* Volume setting               */

  /* Info on the current cdrom in the drive */
  struct cdrom_tochdr tochdr;  		/* TOC Headers			*/
  struct cdrom_tocentry leadout;	/* Last track info		*/
  struct cdrom_ti ti;          		/* Track(s) to play 
					   Track indexing 
					 */
  struct cdrom_subchnl sc;     		/* Drive status 		*/
  struct song_info track[99];           /* Info on songs on this CD     */

  GString          *title;              /* Title of this CD             */
  GString          *category;           /* CDDBD category               */
  GString          *name[99];           /* Name of the track            */
  GString          *extd;               /* Extended data for the CD     */
  GString          *extt[99];           /* Extended Track info          */
  int              revision;            /* CDDB entry  revision #       */   


  /* Data used for talking to the other processes */
  int              cddbd_cmnd,          /* Command for cddbd            */
                   cddbd_stat;          /* Status of process            */
  char             server[80];          /* Server to connect to         */
  int              port;                /* Port on server               */
  char             line[255];           /* Text from MOTD or SITES      */
  char             local_cddb[1024];    /* Path to local CDDB database  */
  char             device[80];          /* CDROM device                 */
};
