/* Definitions for the Mac interface to Xconq.
   Copyright (C) 1992-2000 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

/* All Mac compilers are close enough to ANSI to include these,
   even though some don't define __STDC__. */

#include <stddef.h>
#include <stdarg.h>
#include <stdlib.h>

#ifdef THINK_C
#include <MacHeaders>
#include <Sound.h>
#endif /* THINK_C */

#if 1 /*def MPW*/
#ifndef __MWERKS__ /* actually, "old headers" */
#include <Values.h>
#endif
#ifdef NEW_HEADERS
#include <MacTypes.h>
#include <MacWindows.h>
#else
#include <Types.h>
#include <Windows.h>
#endif /* NEW_HEADERS */
#include <Resources.h>
#include <QuickDraw.h>
#include <Fonts.h>
#include <Events.h>
#include <Menus.h>
#include <TextEdit.h>
#include <Dialogs.h>
#ifndef NEW_HEADERS
#include <Desk.h>
#endif
#include <Scrap.h>
#include <ToolUtils.h>
#ifdef NEW_HEADERS
#include <MacMemory.h>
#else
#include <Memory.h>
#endif
#include <SegLoad.h>
#include <Files.h>
#include <Folders.h>
#include <OSUtils.h>
#ifndef __MWERKS__
#include <OSEvents.h>
#endif
#include <DiskInit.h>
#include <Packages.h>
#include <Traps.h>
#include <Lists.h>
#include <StandardFile.h>
#include <Sound.h>
#include <Devices.h>
#endif /* MPW */

#include <QDOffscreen.h>

#ifdef NEW_HEADERS
#include <Gestalt.h>
#else
#include <GestaltEqu.h>
#endif
#include <PPCToolbox.h>
#include <AppleEvents.h>

/* Bring in image- and interface-related definitions. */

#include "imf.h"
#include "macimf.h"
#include "ui.h"
#include "kpublic.h"

/* Bring in the definitions of resources. */

#include "macdefs.h"

/* Bring in floating window support. */

#include "Floating.h"

#ifdef MPW_C
#define QD(whatever) (qd.##whatever)
#define QDPat(whatever) (&(qd.##whatever))
#endif
#ifdef THINK_C
#define QD(whatever) (whatever)
#define QDPat(whatever) (whatever)
#endif
#ifdef __MWERKS__
#define QD(whatever) (qd.##whatever)
#define QDPat(whatever) (&(qd.##whatever))
#endif

#ifdef MPW_C
/* dangerous way */
#define SET_PAT_ELT(pattern,i,val) ((pattern)[(i)] = (val))
#define PAT_ELT(pattern,i) ((pattern)[(i)])
#endif

#ifdef THINK_C
/* dangerous way */
#define SET_PAT_ELT(pattern,i,val) ((pattern)[(i)] = (val))
#define PAT_ELT(pattern,i) ((pattern)[(i)])
#endif

#ifdef __MWERKS__
#define SET_PAT_ELT(pattern,i,val) ((pattern).pat[(i)] = (val))
#define PAT_ELT(pattern,i) ((pattern).pat[(i)])
#endif

#ifdef THINK_C
/* From MPW, to replace missing definitions in Think C includes. */
enum {

 kOnSystemDisk = /* 0x8000 */ -32768


#define kCreateFolder true
#define kDontCreateFolder false

#define kSystemFolderType				'macs'	/* the system folder */
#define kDesktopFolderType				'desk'		/* the desktop folder; objects in this folder show on the desk top. */
#define kTrashFolderType				'trsh'		/* the trash folder; objects in this folder show up in the trash */
#define kWhereToEmptyTrashFolderType	'empt'	/* the "empty trash" folder; Finder starts empty from here down */

#define kPrintMonitorDocsFolderType		'prnt'	/* Print Monitor documents */

#define kStartupFolderType				'strt'		/* Finder objects (applications, documents, DAs, aliases, to...) to open at startup go here */
#define kAppleMenuFolderType			'amnu'	/* Finder objects to put into the Apple menu go here */
#define kControlPanelFolderType 			'ctrl'		/* Control Panels go here (may contain INITs) */
#define kExtensionFolderType			'extn'		/* Finder extensions go here */
#define kFontsFolderType				'font'		/* Fonts go here */
#define kPreferencesFolderType			'pref'		/* preferences for applications go here */
#define kTemporaryFolderType			'temp'	/* temporary files go here (deleted periodically, but don't rely on it.) */
};

pascal OSErr FindFolder(short vRefNum,OSType folderType,Boolean createFolder,
 short *foundVRefNum,long *foundDirID)
 = {0x7000,0xA823}; 
#endif

/* This is a way - perhaps not the best way - to distinguish "old headers"
   from "universal headers". */

#ifndef __CONDITIONALMACROS__
#define SetMenuItemText SetItem
#define InsertMenuItem InsMenuItem
#define SndListHandle Handle
#define AEEventHandlerUPP EventHandlerProcPtr
#define ModalFilterUPP ModalFilterProcPtr
typedef pascal void (*UserItemProcPtr)(WindowPtr theWindow, short itemNo);
#define UserItemUPP UserItemProcPtr
#define ControlActionUPP ProcPtr
#endif

#ifndef NewAEEventHandlerProc
#define NewAEEventHandlerProc(fn) ((EventHandlerProcPtr) (fn))
#endif
#ifndef NewModalFilterProc
#define NewModalFilterProc(fn) ((ModalFilterProcPtr) (fn))
#endif
#ifndef NewUserItemProc
#define NewUserItemProc(fn) ((UserItemProcPtr) (fn))
#endif
#ifndef NewControlActionProc
#define NewControlActionProc(fn) ((ProcPtr) (fn))
#endif

/* GetKeys has different declarations for its argument type, depending
   on random header versions.  This allows local override of the
   default of long * (some headers have it as unsigned long * ). */

#ifndef GETKEYS_ARG_TYPE
#define GETKEYS_ARG_TYPE long *
#endif

enum grays {
	blackgray,
	darkgray,
	mediumgray,
	lightgray,
	whitegray,
	fullcolor
};

/* The types of available designer tools. */

enum tooltype {
	notool,
	terraintool,
	unittool,
	peopletool,
	featuretool,
	brushsizetool,

	materialtool,
	elevationtool,
	temperaturetool,
	cloudstool,
	windstool,
	viewtool
};

/* The user interface substructure.  This is only allocated for sides with
   attached displays. */

typedef struct a_ui {
	int active;
} UI;

/* Each side can open up any number and shape of maps. */

#define MAXSELECTIONS 500

typedef struct a_map {
	short id;				/* Identifying number for the map */
	VP *vp;                 		/* This map's generic view parameters */
	WindowPtr window;
	ControlHandle hscrollbar;
	ControlHandle vscrollbar;
	/* Offscreen graphics support. */
	CGrafPtr windowPortPtr;
	GDHandle deviceHdl;
	GWorldPtr gworldPortPtr;
	QDErr qdErr;
	short offsetx;			/* Displacement (right, down) in pixels of map window within its gworld */
	short offsety;			/* offsetx = offsety = 0 means the window is in the center of its gworld */
	short xwrap;			/* TRUE if the map itself is wrapped (wider than the world circumference). */
	short leaky_grid;		/* TRUE if the grid is leaky and therefore needs to be drawn explicitly. */

	/* How to draw the map. */
	short conw;
	short toplineh;
	short topunith;
	short toph;
	short sbarwid;
	short bufx;				/* Actual size of horizontal offscreen scrolling buffer */
	short bufy;				/* Actual size of vertical offscreen scrolling buffer */
	short max_bufx;			/* Max size of horizontal offscreen scrolling buffer as set in dialog */
	short max_bufy;			/* Max size of vertical offscreen scrolling buffer as set in dialog */
	short featureborders;	/* Draw feature/province borders */
	short featurenames;		/* Draw feature/province names */
	short simple_borders;	/* Do NOT draw borders to sea & empty land */
	short shorelines;		/* Draw 3D shorelines */
	short sidecolors;		/* Use side colors for icons */
	short iconmasks;		/* Use masks when drawing units */
	short boxmasks;			/* Use masks when drawing grouping boxes */
	short textmasks;		/* Use masks when drawing text */
	short optimize_fonts;	/* Use special font set for maps */
	short solid_color_terrain;	/* Draw terrain in solid colors */
	short draw_topline;		/* Draw top line */
	short draw_topunit;		/* Draw top unit info */	
	short erase_names;		/* Draw row in update_cell_display to erase name of moving unit */	
	short drawsizes;		/* Draw unit (city) size numbers */
	short draw_emblems;
	short draw_ai;
	short draw_transitions;
	short see_all;
	short autoselect;
	Unit *curunit;
	short blinking_curunit;
	short selectionmasks;
	short moveonclick;
	short scrolltocurunit;
	short follow_action;	/* Scroll to scene of actions? */
	int numselections;
	int maxselections;
	Unit **selections;
	Rect contentrect;
	RgnHandle cellrgn;
	int cellrgnx, cellrgny;
	int maxdepth;           /* Largest # of bits/pixel of screens this map uses */
	struct a_map *next;		/* Link to the next map. */
} Map;

/* Each side can open up any number of lists of units. */

#define MAXINLIST 500

typedef struct a_list {
	short id;
	short sidecolors;		/* Use side colors for units */
	short drawsizes;		/* Draw unit (city) size numbers */
	short draw_emblems;
	SideMask sides;			/* Sides to show the units of */
	short completed_units;
	short incomplete_units;
	int mainsortmi;
	enum sortkeys sortkeys[MAXSORTKEYS];  /* attributes to sort list elements on */
	UnitVector *contents;
	int numunits;
	int firstvisible;
	int lastvisible;
	int firstvisfield;
	int lastvisfield;
	short largeicons;
	short shouldreorg;
	short entryspacing;
	WindowPtr window;
	ControlHandle hscrollbar;
	ControlHandle vscrollbar;
	struct a_list *next;
} List;

/* A closer look at a unit. */

typedef struct a_unit_closeup {
	struct a_unit *unit;
	WindowPtr window;
	struct a_unit_closeup *next;
} UnitCloseup;

/* Iteration over all windows. */

#define for_all_windows(w)  \
  for ((w) = FrontWindow(); (w) != NULL; (w) = ((GrafPtr) ((WindowPeek)(w))->nextWindow))

/* Iteration over all of a side's maps. */

#define for_all_maps(m)  \
  for ((m) = maplist; (m) != NULL; (m) = (m)->next)

/* Iteration over all of a side's lists. */

#define for_all_lists(l)  \
  for ((l) = listlist; (l) != NULL; (l) = (l)->next)

/* Iteration over all of a side's unit closeups. */

#define for_all_unit_closeups(c)  \
  for ((c) = unitcloseuplist; (c) != NULL; (c) = (c)->next)

/* Other useful macros. */

#define window_width(w) ((w)->portRect.right - (w)->portRect.left)
#define window_height(w) ((w)->portRect.bottom - (w)->portRect.top)

#define clip_to_limits(lo,x,hi) (max((lo), min((x), (hi))))

#define bords_to_draw(m) (numbordtypes > 0 && bwid[(m)->vp->power] > 0)

#define conns_to_draw(m) (numconntypes > 0 && cwid[(m)->vp->power] > 0)

#define draw_any_materials(m) (0)

#define any_borders_at(x, y, b) (aux_terrain_at(x, y, b) != 0)

#define any_connections_at(x, y, c) (aux_terrain_at(x, y, c) != 0)

enum {
	dontdraw,
	useblocks,
	usepictures,
	usepolygons
};

enum {
	plain_emblem,
	shadow_emblem
};

enum {
	NO_MODAL,
	MOVE_TO_MODAL,
	ATTACK_MODAL,
	FIRE_MODAL,
	FIRE_INTO_MODAL,
	SET_FORMATION_MODAL,
	ADD_TERRAIN_MODAL,
	REMOVE_TERRAIN_MODAL,
	DISTANCE_MODAL,
	ZOOM_MODAL,
	GENERIC_MODAL
};

#ifndef c2p
#define c2p(STR,PBUF) \
  strcpy(((char *) PBUF) + 1, STR);  \
  PBUF[0] = strlen(STR);
#endif

#ifndef p2c
#define p2c(PSTR,BUF)  \
  strncpy(BUF, ((char *) (PSTR) + 1), PSTR[0]);  \
  BUF[PSTR[0]] = '\0';
#endif

#define top_left(rect) (*(Point *) &(rect.top))

#define bottom_right(rect) (*(Point *) &(rect.bottom))

/* The following macros require local vars named win, itemtype, itemhandle, itemrect. */

#define set_flag_from_ditem(di,place)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  (place) = GetCtlValue((ControlHandle) itemhandle); 

#define put_number_into_ditem(di,num)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  NumToString((num), tmpstr);  \
  SetIText(itemhandle, tmpstr);

#define get_number_from_ditem(di,place)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  GetIText(itemhandle, tmpstr);  \
  StringToNum(tmpstr, (long *) &(place));

/* (should understand nn:mm times) */

#define put_time_into_ditem(di,num)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  NumToString((num), tmpstr);  \
  SetIText(itemhandle, tmpstr);

#define get_time_from_ditem(di,place)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  GetIText(itemhandle, tmpstr);  \
  StringToNum(tmpstr, (long *) &(place));

#define get_string_from_ditem(di,buf)  \
  GetDItem(win, (di), &itemtype, &itemhandle, &itemrect);  \
  GetIText(itemhandle, tmpstr);  \
  p2c(tmpstr, (buf));

extern Side *dside;

extern int playsounds;

extern int nummaps;

extern ImageFamily **uimages;
extern ImageFamily **timages;
extern ImageFamily **eimages;
extern ImageFamily **mimages;
extern MacImage **tcolors;

extern ImageFamily *generic_transition;
extern ImageFamily *beach;

extern WindowPtr helpwin;
extern char *helpstring;
extern TEHandle helptext;

extern DialogPtr researchwin;
extern DialogPtr buildwin;

extern Unit *buildwin_unit;

extern WindowPtr commandwin;
extern WindowPtr instructionswin;
extern WindowPtr gamewin;
extern WindowPtr constructionwin;
extern WindowPtr designwin;

extern enum tooltype tooltype;
extern short curutype;
extern short curttype;
extern short cursidenumber;
extern short curfid;
extern Feature *curfeature;

extern WindowPtr historywin;
extern WindowPtr noticewin;
extern WindowPtr scoreswin;
extern MenuHandle sidemenu;
extern MenuHandle utypemenu;
extern MenuHandle mtypemenu;
extern MenuHandle ttypemenu;

extern int hasColorQD;
extern int minscreendepth;
extern int maxscreendepth;
extern int sbarwid;
extern int floatsbarwid;
extern WindowPtr worldmapwin;
extern Map *worldmap;
extern Map *frontmap;
extern int numwindows;
extern int mapnum;
extern WindowPtr *winmenuwins;

extern int default_draw_grid;
extern int default_draw_names;
extern int default_draw_meridians;

extern int map_modal;

extern int defaultmoveonclick;
extern int defaultautoselect;

extern PolyHandle *polygons;
extern int *lastpolyx, *lastpolyy;

extern RgnHandle *cellrgns;
extern int *lastcellrgnx, *lastcellrgny;
extern RgnHandle *gridcellrgns;
extern int *lastgridcellrgnx, *lastgridcellrgny;

extern RgnHandle *cellrgns30;
extern int *lastcellrgnx30, *lastcellrgny30;
extern RgnHandle *gridcellrgns30;
extern int *lastgridcellrgnx30, *lastgridcellrgny30;

extern RgnHandle *cellrgns15;
extern int *lastcellrgnx15, *lastcellrgny15;
extern RgnHandle *gridcellrgns15;
extern int *lastgridcellrgnx15, *lastgridcellrgny15;

extern struct a_map *maplist;	   /* chain of maps that we're using */
extern struct a_list *listlist;	 /* chain of lists */
extern struct a_unit_closeup *unitcloseuplist;	 /* chain of unit closeups */

struct cmdtab;	/* Shuldn't this be extern as well? */

extern CursHandle paintcursors[];
extern CursHandle bordpaintor;
extern CursHandle connpaintor;
extern CursHandle movecursors[];
extern CursHandle nomovecursor;
extern CursHandle allmovecursor;
extern CursHandle grayarrowcursor;
extern CursHandle opencrosscursor;
extern CursHandle watchcursor;
extern CursHandle firecursor;
extern CursHandle sendcursor;
extern CursHandle receivecursor;

/* Autoscroll cursors. */
extern CursHandle leftcursor;
extern CursHandle rightcursor;
extern CursHandle downcursor;
extern CursHandle upcursor;

extern enum grays gridgray;
extern enum grays unseengray;
extern enum grays bggray;

extern RGBColor blackcolor;
extern RGBColor dkgraycolor;
extern RGBColor graycolor;
extern RGBColor ltgraycolor;
extern RGBColor whitecolor;

extern int conwid;
extern int tophgt;

extern int first_windows;

extern int grid_matches_unseen;

extern BitMap *bordbitmaps;
extern BitMap *connbitmaps;

extern Pattern *animation_patterns;

extern int animation_pattern_state;

extern WindowPtr playersetupwin;

extern int connection_method;
extern Rect dragrect;
extern int foundimagesfile;

extern int Profile;

extern TEHandle command_text;

extern TEHandle run_length_text;

extern int position_set_modally;
extern Point modal_point;
extern Map *modal_map;

extern short pref_color_unit_images;
extern short pref_solid_color_terrain;

extern short small_font_id;
extern short small_font_size;
extern short small_line_spacing;
extern short large_font_id;
extern short large_font_size;
extern short large_line_spacing;
extern short title_font_id;
extern short title_font_size;
extern short title_line_spacing;

extern int gamewinw;
extern int topunithgt;

extern int default_meridian_interval;

extern int use_colornames;			/* Save and read colors and colorschemes by name */
extern int use_RGB_values;			/* Save and read RGB colors in XCol resource */
extern int show_instructions;		/* Show instructions window at start */
extern int fullsize_map;			/* Display the first map at full screen size */
extern int unified_cicns;			/* Use BitMap as mask for color PixMap */

extern int default_draw_topline;		/* Draw top line box (toggle function declared elsewhere) */
extern int default_draw_topunit;		/* Draw unit info box (toggle function declared elsewhere) */
extern int default_draw_scrollbars;	/* Draw scrollbars in maps. */
extern int default_draw_cpanel;		/* Draw control panel in maps. */
extern int default_drawothermaps;	/* Draw other-map boxes */
extern int default_sidecolors;		/* Use side colors for unit icons */					
extern int default_iconmasks;		/* Draw unit icon masks */
extern int default_boxmasks;		/* Draw masks for grouping boxes */
extern int default_textmasks;		/* Draw text masks */
extern int default_featureborders;	/* Draw feature borders */
extern int default_featurenames;		/* Draw feature names */		
extern int default_shorelines;		/* Draw 3D shorelines */
extern int default_draw_ai;			/* Draw AI regions (if present). */
extern int alert_256_colors;		/* Suggest switch to 256 colors at start. */
extern int default_draw_emblems;	/* Draw unit emblems in maps and lists. */
extern int default_simple_borders;	/* Do not draw borders to sea or empty land */
extern int default_optimize_fonts;	/* Use optimized set of font sizes */
extern int default_erase_names;		/* Erase names of moving units */
extern int default_power;			/* Default power of new map */
extern int default_max_bufx;		/* Default size of horizonal offscreen scrolling buffer */
extern int default_max_bufy;		/* Default size of vertical offscreen scrolling buffer */
extern int default_drawsizes;		/* Draw unit (city) sizes */
extern int default_blinking_curunit;	/* Draw blinking current unit instead of animated box */
extern int default_selectionmasks;	/* Draw selection masks instead of selection boxes */

#define BACKTTYPE -1					/* Differs from unseen terrain which is NONTTYPE. */

#define FEATURES 10						/* Should equal the number of feature colors below! */

#define backcolor 		featColor[0]		/* Window background color. */
#define forecolor 		featColor[1]		/* Note: differs from ForeColor !!! */
#define maskcolor 		featColor[2]		/* Default mask color for icons, text and boxes */
#define textcolor 		featColor[3]		/* Text color (except for feature names) */
#define gridcolor 		featColor[4]		/* Color of the grid */
#define unseencolor 		featColor[5]		/* Color of unseen land */
#define shorecolor 		featColor[6]		/* Shore line color */
#define featurecolor 		featColor[7]		/* Feature name and border color */
#define frontcolor 		featColor[8]		/* Front line color used by draw_country_borders */
#define meridiancolor 	featColor[9]		/* Color of meridians */
#define contourcolor 		featColor[10]		/* Color of contour lines */

#define gridcolor_name	featColorName[4]	/* Used to set grid_matches_unseen */
#define unseencolor_name	featColorName[5]	/* Used to set grid_matches_unseen */

extern RGBColor *featColor; /*[FEATURES+1];		/* This array is used to store the feature colors */
extern RGBColor *sideColor; /*[MAXSIDES+1][4];	/* This array is used to store the side colors */
									/* side 0 is the independents, hence MAXSIDES + 1 */
									/* sideColor[][0] is not currently used */

extern char **featColorItemName; /*[FEATURES+1][32];	/* Name of item for which featColor is set */
extern char **featColorName; /*[FEATURES+1][32];		/* Name of featColor value (red etc) */
extern char **sideColorName; /*[MAXSIDES+1][4][32];		/* Name of sideColor value (red etc)*/
extern char **default_featColorName; /*[FEATURES+1][32];	/* Default feature color values (by name) */
extern char **default_colorscheme; /*[MAXSIDES+1][96];	/* Default side colorscheme (red,pink,blue) */
extern char **current_colorscheme; /*[MAXSIDES+1][96];			/* Side colorscheme (red,pink,blue) */

#define get_sideColor(s,n) (sideColor[4 * (s) + (n)])

#define get_sideColorName(s,n) (sideColorName[4 * (s) + (n)])

#define set_sideColor(s,n,c) (sideColor[4 * (s) + (n)] = (c))

#define set_sideColorName(s,n,str) (sideColorName[4 * (s) + (n)] = (str))

/* These are the default numbers for color usage */ 

extern int default_main_icon_color;			/* Number (1-3) of main sideColor used for unit icons */ 
extern int default_half_icon_color;			/* Number (1-3) of sideColor used for right half of icons */
extern int default_icon_mask_color;			/* Number (1-3) of sideColor used to draw icon masks */
extern int default_split_icon;				/* Use two colors for left and right half if TRUE */				

/* These are customized numbers for each player */

extern int *main_icon_color; /*[MAXSIDES +1];		/* Number (1-3) of main sideColor used for unit icons */ 
extern int *half_icon_color; /*[MAXSIDES +1];		/* Number (1-3) of sideColor used for right half of icons */
extern int *icon_mask_color; /*[MAXSIDES +1];		/* Number (1-3) of sideColor used to draw icon masks */
extern int *split_icon; /*[MAXSIDES +1];			/* Use two colors for left and right half if TRUE */				

/* These shorts are defined in macconq.c and used in maccolors.c */

extern short images_refnum;	/* frefNum of lib-mac : Images file */ 
extern short prefs_refnum;		/* frefNum of Xconq Preferences file */

/* Function declarations. */

/* Note that although the Xconq kernel must conditionalize its prototypes,
   all Mac C compilers are sufficiently standard C to handle them. */

/* maccmd.c */

extern void do_keyboard_command(int key);

extern int do_one_give_unit(Unit *unit);
extern int do_move_to_command(void);

extern void show_command_window(void);
extern void draw_command(void);
extern void activate_command(int activate);
extern int do_key_down_command(int keyCode, int charCode);
extern void do_mouse_down_command(Point mouse, int mods);

extern void toggle_profiling(void);

/* maccolors.c */

extern void set_default_colors(void);			/* Set default colors */
extern void set_default_side_colors(int e);		/* Side colors Dialog called by Prefs popup */
extern void set_default_feature_color(int e);	/* Feature color Dialog called by Prefs popup */

extern void init_side_colors(void);			/* Grab memory, set colors to black, names to undefined */
extern void dissect_colorscheme(int e);	 	/* Dissect a colorscheme into sideColorNames */

extern void read_xcol(void);				/* Read RGB colors form XCol resource */
extern void write_xcol(void);				/* Write RGB colors to XCol resource */

extern void set_side_colors(int e);			/* Side colors Dialog called by Colors menu */
extern void set_feature_color(int e);			/* Feature color Dialog called by Colors menu */
extern void set_terrain_color(Str255 tname);	/* Feature color Dialog for terrain */

extern void build_colors_menu(void);			/* Build the Colors menu */
extern void build_sides_menu(void);			/* Build popup menu for prefs */
extern void build_features_menu(void);		/* Build popup menu for prefs */

/* macconq.c */

extern int main(void);
extern void recalc_spacing(void);
extern void get_global_mouse(Point *mouse);

extern void close_window(WindowPtr win);
extern void update_window(WindowPtr win);
extern void draw_growicon_nolines(WindowPtr win);

extern void connect_game_dialog(void);
extern void connection_method_dialog(void);

extern void stagger_window(WindowPtr win, int *lasthp, int *lastvp);
extern GDHandle best_zoom_screen(Rect *rectptr);
extern void set_standard_state(WindowPtr win, int fullw, int fullh);
extern void get_main_screen_size(int *widp, int *hgtp);
extern void draw_default_button(DialogPtr dialog, short ditem);
extern char *get_string_from_item(Handle itemhandle);
extern void force_update(WindowPtr win);
extern void force_overall_update(void);
extern void beep(void);
extern void set_game_file_type(char *name);
extern void exit_macconq(void);

/* macdesign.c */

#ifdef DESIGNERS

extern void enable_designing(int forsure);
extern void disable_designing(void);
extern CursHandle adjust_designer_cursor(Point mouse, RgnHandle region);
extern void show_design_window(void);
extern void draw_design_window(void);
extern void do_mouse_down_design(Point mouse, int mods);
extern void apply_designer_tool(Map *map, int h, int v, int mods);
extern void designer_save_dialog(void);

#endif /* DESIGNERS */

/* macdraw.c */

extern void draw_unit_image(WindowPtr win, int sx, int sy, int sw, int sh, int u, int s, int sidecolors, int selected, int mod, int emblem);
extern void draw_side_emblem(WindowPtr win, int ex, int ey, int ew, int eh, int e, int style);

extern void draw_cell_block(int sx, int sy, int n, int power, int t, int over, int angle, int dosolid);
extern void draw_hex_region(int sx, int sy, int power, int t, int over, int angle, int dogrid, int dosolid, int var);
extern void make_cell_clip(int power);

extern void draw_terrain_transitions(Map *map, int x0, int y0, int len);
extern void draw_shore_images(Map *map, int x, int y);
extern void draw_border_images(Map *map, int x, int y, int b);
extern void draw_border_line_multiple(WindowPtr win, int sx, int sy, int bitmask, int power, int t, int angle, int over, int dosolid);
extern void draw_connection_line_multiple(WindowPtr win, int sx, int sy, int bitmask, int power, int t, int angle, int over, int dosolid);
extern void draw_terrain_sample(WindowPtr win, Rect tmprect, int t, int power);
extern void draw_country_borders(WindowPtr win, int sx, int sy, int bitmask, int power, int shade, int angle);
extern void draw_feature_borders(WindowPtr win, int sx, int sy, int bitmask, int power);
extern void draw_ai_region_borders(WindowPtr win, int sx, int sy, int bitmask, int power);
#if 0
extern int draw_elevation_here(int x, int y);
extern void draw_elevation(int sx, int sy, int power, int elev);
#endif
extern void draw_temperature(int sx, int sy, int power, int temp);
extern int draw_clouds_here(int x, int y);
extern void draw_cloud_block(int sx, int sy, int i, int power, int cloudtype, int angle);
extern void draw_clouds(int sx, int sy, int power, int cloudtype);
extern void draw_winds(int sx, int sy, int power, int rawwind);
extern void draw_coverage(int sx, int sy, int power, int cov, int altcov);

extern void draw_unit_name(Unit *unit, int sx, int sy, int sw, int sh, int masks, int optimize);
extern void draw_legend_text(int sx, int sy, int sh, char *legend, int just, int masks, int optimize);
extern void draw_blast_image(WindowPtr win, int sx, int sy, int sw, int sh, int blasttype);
#if 0
extern void clear_blast_image(WindowPtr win, int sx, int sy, int sw, int sh, int blasttype);
#endif
extern int picture_width(PicHandle pichandle);
extern int picture_height(PicHandle pichandle);
extern void plot_sicn(WindowPtr win, int sx, int sy, Handle sicnhandle, int n, int erase, int mode);
extern void gray_out_rect(Rect *rectptr);

/* macgworld.c */

extern void check_screen_depths(void);				/* Check for more than 256 colors */

extern void scroll_map_window(Map *map, int dx, int dy);	/* Scroll map window within its gworld */
extern void copy_from_gworld(Map *map, Rect destRect);	/* Copy rect from gworld to screen */
extern void update_resized_map(Map *map);			/* Update map and then redraw its gworld */
extern void update_gworld(Map *map);					/* Update the gworld (and redraw the map)*/
extern int cell_is_in_gworld(Map *map, int x, int y);		/* Test if cell is within current gworld */

extern int handle_numeric_keypad(EventRecord *event);	/* Enables special use of numeric keypad */

extern void update_all_dialogs(void);
extern void update_all_windows(void);
extern void update_all_map_windows(void);
extern void update_all_visible_dialogs(void);
extern void update_all_visible_windows(void);
extern void update_all_visible_map_windows(void);

/* machelp.c */

extern void show_instructions_window(void);
extern void activate_instructions(int activate);
extern int do_key_down_instructions(char key);
extern void do_mouse_down_instructions(Point mouse, int mods);
extern void draw_instructions(void);

extern void show_help_window(HelpNode *helpnode);
extern void draw_help(void);
extern void activate_help(int activate);
extern int do_key_down_help(char key);
extern void do_mouse_down_help(Point mouse, int mods);
extern void grow_help(int h, int v);
extern void zoom_help(int part);

/* macinit.c */

extern void init_patterns(void);
extern void init_icons(void);
extern void init_cursors(void);
extern int do_splash_box(void);

extern void new_game_dialog(void);
extern void do_mouse_down_setup(Point mouse, int mods);
extern void do_key_down_setup(EventRecord *event);
extern void add_remote_player(char *name);
extern int open_game_dialog(void);
extern int open_game_from_fsspec(FSSpec *fsspec);

extern void init_unit_images(void);
extern void init_emblem_images(void);

/* maclist.c */

extern void create_list(void);
extern List *list_from_window(WindowPtr window);
extern void draw_list(List *list);
extern void grow_list(List *list, int w, int h);
extern void zoom_list(List *list, int part);
extern int do_key_down_list(List *list, char key);
extern void do_mouse_down_list(List *list, Point mouse, int mods);

extern void set_list_sorting(List *list, enum sortkeys newkey, int mi);
extern void toggle_list_completed(List *list);
extern void toggle_list_incomplete(List *list);
extern void toggle_list_large_icons(List *list);
extern void toggle_list_sidecolors(List *list);
extern void toggle_list_draw_emblems(List *list);

extern void update_unit_in_lists(Unit *unit);
extern void reorganize_list(List *list);
extern Unit *selected_unit_in_list(List *list);
extern void scroll_to_selected_unit_in_list(List *list);

extern void activate_list(List *list, int activate);
extern void print_list(List *list);
extern void destroy_list(List *list);

/* macmap.c */

extern void xform(Map *map, int x, int y, int *sxp, int *syp);
extern void m_xform_unit(Map *map, Unit *unit, int *sxp, int *syp, int *swp, int *shp);
extern void m_xform_unit_self(Map *map, Unit *unit, int *sxp, int *syp, int *swp, int *shp);
extern void m_xform_occupant(Map *map, Unit *transport, Unit *unit, int sx, int sy, int sw, int sh, int *sxp, int *syp, int *swp, int *shp);
extern int m_nearest_cell(Map *map, int sx, int sy, int *xp, int *yp);
extern int m_nearest_boundary(Map *map, int sx, int sy, int *xp, int *yp, int *dirp);
extern int m_nearest_unit(Map *map, int sx, int sy, Unit **unitp);
extern int in_middle(Map *map, int x, int y);
extern void m_center_on_focus(Map *map);

extern Map *create_map(int power, int id);
extern void set_content_rect(Map *map);
extern void set_map_scrollbars(Map *map);
extern void set_map_power(Map *map, int power);
extern void set_map_focus(Map *map, int x, int y);
extern void set_map_angle(Map *map, int angle);
extern void grow_map(Map *map, int w, int h);
extern void zoom_map(Map *map, int part);
extern void adjust_map_decor(Map *map);
extern void invert_map(Map *map, int x, int y, int r);
extern void activate_map(Map *map, int activate);
extern Map *map_from_window(WindowPtr window);
extern void force_map_update(Map *map);
extern void print_map(Map *map);
extern void destroy_map(Map *map);

extern void draw_map(Map *map);
extern void draw_control_panel(Map *map);
extern void draw_top_line(Map *map);
extern void draw_unit_info(Map *map);
extern void draw_related_maps(Map *map);

extern void draw_unit_blast(Map *map, Unit *unit, int blast);
extern void draw_selections(Map *map);
extern void draw_selections_at(Map *map, int x, int y);
extern void draw_selection_animation(Map *map, Unit *unit);

extern void update_cell(Map *map, int x, int y);

/* macmenus.c */

extern void query_position_modally(int mode);
extern void set_position_modally(void);

extern void init_menus(void);
extern void add_window_menu_item(char *name, WindowPtr win);
extern void remove_window_menu_item(WindowPtr win);

extern void build_side_menu(void);
extern void update_side_menu(Side *side2);
extern void build_unit_type_menu(void);
extern void build_material_type_menu(void);
extern void build_terrain_type_menu(void);
extern void build_feature_menu(void);
extern void build_optional_terrain_type_menu(void);
extern void sanitize_for_menu(char *str, Str255 outstr);

extern void do_menu_command(long which);
extern void do_about_box(void);

extern void save_the_game(int askname, int quitting);
extern void quit_the_game(void);

extern void apply_to_all_selected(int (*fn)(), int beepfailure);
extern void adjust_menus(void);

extern void toggle_map_grid(Map *map);
extern void toggle_map_control(Map *map);
extern void toggle_map_people(Map *map);
extern void toggle_map_plans(Map *map);
extern void toggle_map_ai(Map *map);
extern void toggle_map_sidecolors(Map *map);		

/* macmouse.c */

extern void do_mouse_down_map(Map *map, Point mouse, int mods);
extern void toggle_survey(Map *map);
extern void magnify_map(Map *map, int inout);
extern void set_map_mag(Map *map, int newpower);
extern void unselect_all(Map *map);
extern void select_unit_on_map(Map *map, Unit *unit);
extern int unit_is_selected(Map *map, Unit *unit);
extern void unselect_unit_on_map(Map *map, Unit *unit);
extern void select_exactly_one_unit(Map *map, Unit *unit);
extern void select_previous_unit(Map *map);
extern void select_next_mover(Map *map);
extern void scroll_best_map_to_unit(Unit *unit, int bringtofront);
extern void scroll_to_unit(Map *map, Unit *unit);

/* macprefs.c */

extern void get_preferences(void);
extern void save_preferences(void);
extern void interp_mac_ui_data(Obj *uispec);
extern void ui_update_state(void);
extern void set_preferences(void);

/* macrow.c */

extern void draw_row(Map *map, int x0, int y0, int len, int clearit);
extern void draw_gridlines(Map *map, int x, int y);
extern void draw_shores(Map *map, int x, int y);

/* macunit.c */

extern UnitCloseup *find_unit_closeup(Unit *unit);
extern UnitCloseup *unit_closeup_from_window(WindowPtr win);
extern void show_unit_closeup(Unit *unit);
extern void draw_unit_closeup(UnitCloseup *unitcloseup);
extern void draw_unit_size(Unit *unit, WindowPtr win, int sx, int sy, int sw, int sh);
extern int do_mouse_down_unit_closeup(UnitCloseup *unitcloseup, Point mouse, int mods);
extern int do_key_down_closeup(UnitCloseup *closeup, char key, char code, int mods);
extern void destroy_unit_closeup(UnitCloseup *unitcloseup);

extern void show_unit_build_dialog(Unit *unit);
extern void draw_unit_build_dialog(int force);
extern int do_key_down_build(char key, char code, int mods);
extern int do_mouse_down_build(Point mouse, int mods);

extern MenuHandle build_research_menu(Side *side);

/* macwins.c */

extern void show_game_window(void);
extern void draw_game(void);
extern void draw_game_date(void);
extern void draw_game_clocks(void);
extern void draw_game_progress(void);
extern void draw_side_status(Side *side2);
extern void do_mouse_down_game(Point mouse, int mods);

extern void show_construction_window(void);
extern void set_construction_run_length(int len);
extern void draw_construction(void);
extern void activate_construction(int activate);
extern void scroll_to_selected_construction_unit(void);
extern void do_mouse_down_construction(Point mouse, int mods);
extern int do_key_down_construction(int key);
extern void select_unit_in_construction_window(Unit *unit);
extern void select_type_in_construction_window(int u);
extern void update_construction_unit_list(Unit *unit);
extern void update_construction_type_list(void);
extern void grow_construction(int h, int v);
extern void zoom_construction(int part);

extern void show_research_dialog(void);
extern void draw_research_dialog(int force);
extern void do_mouse_down_research(Point mouse, int mods);
extern int do_key_down_research(char key);

extern void side_research_dialog(Side *side, Unit *unit, int advance);

extern void show_history_window(void);
extern void draw_history(void);
extern void update_history_window(HistEvent *hevt);
extern void do_mouse_down_history(Point mouse, int mods);
extern void grow_history(int h, int v);
extern void zoom_history(int part);

extern void show_notice_window(void);
extern void append_notice(char *str);
extern void draw_notice(void);
extern void activate_notice(int activate);
extern void do_mouse_down_notice(Point mouse, int mods);
extern void grow_notice(int h, int v);
extern void zoom_notice(int part);

extern void show_scores_window(void);
extern void draw_scores(void);
extern void activate_scores(int activate);
extern void do_mouse_down_scores(Point mouse, int mods);
extern void grow_scores(int h, int v);
extern void zoom_scores(int part);
