/*
 * Program XBLAST V2.5.6 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * April 13th, 1997
 * started August 1993
 *
 * File: player.h
 * header file for player.c
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will be entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: player.h,v 1.1 1998/01/03 14:08:56 xblast Exp $
 * $Log: player.h,v $
 * Revision 1.1  1998/01/03 14:08:56  xblast
 * Initial revision
 *
 */

#ifndef _PLAYER_H
#define _PLAYER_H

/*
 * global variables
 */
#ifndef _PLAYER_C
extern BMPlayer player_stat[2*MAX_PLAYER];
extern PlayerStrings p_string[2*MAX_PLAYER];
#endif
/*
 * prototypes
 */
#ifdef _PLAYER_C
#define _EXTERN 
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN void setup_players (unsigned long g_mode, BMPlayerData *data);
_EXTERN void init_shuffle_startpos (int npos);
_EXTERN void init_players (XBConfig *config, XBSettings *setup, int g_mode);
_EXTERN void delete_player_sprites (void);
_EXTERN void drop_bomb (BMPlayer *ps, int type);
_EXTERN void do_junkie (void);
_EXTERN void infect_other_players (void);
_EXTERN void kill_player_at (int x, int y);
_EXTERN int kill_other_players (int team);
_EXTERN int stun_other_players (int team, int time);
_EXTERN int check_b_near (int x, int y);
_EXTERN void do_all_players (int game_time, int *active_player);
_EXTERN void check_player_hit (void);
#else
_EXTERN void setup_players ();
_EXTERN void init_shuffle_startpos ();
_EXTERN void init_players ();
_EXTERN void delete_player_sprites ();
_EXTERN void drop_bomb ();
_EXTERN void do_junkie ();
_EXTERN void infect_other_players ();
_EXTERN void kill_player_at ();
_EXTERN int kill_other_players ();
_EXTERN int stun_other_players ();
_EXTERN int check_b_near ();
_EXTERN void do_all_players ();
_EXTERN void check_player_hit ();
#endif

#undef _EXTERN

#endif
/*
 * end of file player.h
 */
