/*
 * Program XBLAST V2.5.15 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * October 18, 1998
 * started August 1993
 *
 * File: event.h
 * header file for event.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: event.h,v 1.2 1998/10/18 12:30:04 xblast Exp $
 * $Log: event.h,v $
 * Revision 1.2  1998/10/18 12:30:04  xblast
 * Morphing Bomb extra
 *
 * Revision 1.1  1998/01/03 14:11:18  xblast
 * Initial revision
 *
 */

#ifndef _EVENT_H
#define _EVENT_H

/*
 * global varaiables
 */

/*
 * globals
 */
#ifndef _EVENT_C
#ifdef __STDC__
extern void (*quit_function)(void);
#else
extern void (*quit_function)();
#endif
#endif


/*
 * prototypes
 */

#ifdef _EVENT_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN void init_timer (void);
_EXTERN void set_game_keys (XBConfig *config);
_EXTERN void set_event_communication (int type, BMRecordMode record_mode, 
				      int p1, int p2);
_EXTERN void game_event (void);
_EXTERN void other_event (void);
_EXTERN void intro_event (void);
_EXTERN int game_eval_keys(int n_player, BMPlayer *player_stat, 
			   PlayerStrings *p_string, PFV key_func,
			   int* pause_mode);
_EXTERN int pause_eval_keys(int n_player, int* pause_mode);
_EXTERN int wait_eval_keys (int n_player);
_EXTERN void clear_keys(int n_player);
_EXTERN void fade_in (void);
_EXTERN void fade_out (void);
_EXTERN void white_out (void);
#else
_EXTERN void init_timer ();
_EXTERN void set_game_keys ();
_EXTERN void set_event_communication ();
_EXTERN void game_event ();
_EXTERN void other_event ();
_EXTERN void intro_event ();
_EXTERN int game_eval_keys();
_EXTERN int pause_eval_keys();
_EXTERN int wait_eval_keys ();
_EXTERN void clear_keys();
_EXTERN void fade_in ();
_EXTERN void fade_out ();
_EXTERN void white_out ();
#endif

#undef _EXTERN

#endif
/*
 * end of file event.h
 */
