.TH "XBL" 6 "26 November 2001"
.SH NAME
xbl \- X Window block dropping game in 3 Dimension
.SH SYNOPSIS
.B xbl
[\-display\ display:0.0]
[\-geometry\ geometrystring]
[\-scoregeometry\ geometrystring]
[\-zoogeometry\ geometrystring]
[\-menugeometry\ geometrystring]
[\-help]
[\-verbose]
[\-colormap]
[\-visual]
[\-bw]
[\-buffer\ 0...5]
[\-font\ font]
[\-bigfont\ font]
[\-buttonheight\ -1...16]
[\-color\ 0...6]
[\-speedtest]
[\-clearline\ 0...1]
[\-linewidth\ 0...16]
[\-time_to_demo\ 1...999]
[\-sync]
[\-stat]
[\-keytable\ String]
[\-keyboard\ 0...4]
[\-zoo]
[\-score]
[\-draw\ 0\ or\ 2]
[\-x\ 3...8]
[\-y\ 3...8]
[\-z\ 6...18]
[\-smooth]
[\-training]
[\-shownext]
[\-level\ 0...10]
[\-bloctype\ 0...2]
[\-land\ 0...2]
[\-volume\ 0...10]
[\-eyedistance\ -1...1]
.SH DESCRIPTION
.I Xbl
is a game involving dropping blocks like
.I Xtetris
but in 3 dimensions.
As they drop you can move them with numeric key pad (if you have), cursor key
or rotate other 3 axis in 2 directions (6 other keys).
Space key for dropping quickly and 'p' key for pause.
All the possible keys are displayed in menu window.
.PP
Points are scored for each block that comes to rest on the gradually
building up pile of blocks. 
When the pile reaches the top of the
screen and no further blocks can be dropped the game ends. When a
stage of blocks across the 3D matrix is completely filled, that
stage is removed and all the blocks above are dropped down.
As more stages are deleted the blocks fall faster.
.PP
There is one high score table by size of matrix and pieces types.

For your information, another 3D tetris exists, its name is
.B spatial.
A sphere packing game also exists; its name is
.B spheral.
For these two games, contact Andrew Plotkin (
.B ap1i@andrew.cmu.edu
)
or you can retrieve the file 
.B threedee.tar.Z
somewhere in the world...

An enhanced HTML version of this manual is in our computer
(in the same directory than scores).
If you can't find it, use the networked version:
.B http://www710.univ-lyon1.fr/ftp/xbl/xbl-man.html


.SH OPTIONS

The next options can only be set when the game starts.

.TP
.BI -display " hostname:0.0"
Gives the display name.
.TP
.BI -geometry " geometry_string"
.TP
.BI -scoregeometry " geometry_string"
.TP
.BI -zoogeometry " geometry_string"
.TP
.BI -menugeometry " geometry_string"
Gives the geometry of the play, score, zoo and menu window.
.TP
.B -help
Displays the options, possible values and current values.
.TP
.B -verbose
Displays various things for debugging.
.TP
.B -colormap
Creates its own colormap even if unnecessary.
.TP
.B -visual
On screen with multiple visual, it search the best one
to use. In this case it does not use the default visual.
.TP
.B -bw
Displays in black and white even on color display.
.TP
.BI -buffer " 0...5"
Chooses the buffering method for animation.
Each method uses resources.
Speed of buffering method is hardware dependent.
Perfect methods are 2,1 and 3, choose the fast one.

.TP
.BI -font " font_name"
Chooses font for menus, score window...

.TP
.BI -bigfont " font_name"
Chooses a big font for menu (the score and high score)

.TP
.BI -buttonheight " -1...16"
The height of 3D buttons.
If your display is slow use small button.
The -1 choice is half the height of the font.

.TP
.BI -color " 0...6"
Background color for menu window.
.br
0:Black
.br
1:Red
.br
2:Green
.br
3:Yellow
.br
4:Blue
.br
5:Magenta
.br
6:Cyan

.TP
.B -sync
Uses X Synchronise. Only for debugging.

.TP
.BI -clearline " 0...1"
If 0, clears line with rectangle filling; otherwise with a black line.
It's useful with some X servers that don't draw the same segment with
the same pixels. Another method to avoid this problem is to
use a 
.I linewidth
equal to 1, though in this case drawing is slower.

.TP
.BI -linewidth " 0...16"
Thickness of the moving block lines.

.TP
.BI -fps " 1...100"
Number of frames by second.
If it is set too high, the display might be jumpy.
If set to 0, the game runs at maximum speed.

.TP
.BI -time_to_demo " 1...999"
Number of seconds before the automatic demonstration.

.TP
.B -speedtest
This option helps you to find the fastest buffering mode.

.TP
.B -stat
Statistics on launched blocks, they are displayed at the end of the game.

.TP
.BI -keytable " keys_list"
A 19 characters list in the order (D=Down L=Left R=Right U=Up) :
.br
Translations:DL,L,UL,U,UR,R,DR,D
.br
Rotations:   RX+,RX-,RY+,RY-,RZ+,RZ-
.br
Others:      LaunchBloc CancelGame SuspendGame QuitGame Drop1Level
.br
Don't forgot ' if there are special characters.

.TP
.I Next options can be changed while game is running.

.TP
.BI -keyboard " 0...5"
This switch chooses keyboard type :
.br
0:Use key table, given by
.I -keytable
.br
1:AZERTY|
.br
2:QWERTY|
.br
3:AZERTY-
.br
4:QWERTY-
.br
5:SPATIAL
.br
SPATIAL is the set of keys of the other 3D tetris : 
.B spatial

.TP
.B -zoo
Displays the zoo (all possible pieces)
when game starts.

.TP
.B -score
Displays the score table when game starts.

.TP
.BI -draw " 0 or 2"
Draw mode. 0 for wire frame piece
and 2 for transparent pieces.
On slow host, 0 is necessary.

.TP
.B -x \fI 3...8 \fB -y \fI 3...8 \fB -z \fI 6...18"
World size : width, height, depth.

.TP
.B -smooth
Starts game with smooth drawing.

.TP
.B -training
In this mode, pieces don't fall.
By the way scores are not saved.

.TP
.B -shownext
Next piece is shown.
By the way score are multiplied by 0.7

.TP
.BI -level " 0...10"
Level 0 is slow, 10 is unplayable.
This option chooses the starting game level.
Level game increases during game.

.TP
.BI -bloctype " 0...2"
0 : Only flat pieces.
.br
1 : Some 3D pieces.
.br
2 : All possible pieces with less or equal than 5 cubes.

.TP
.BI -land " 0...2"
0 : Small land (3x3x15)
.br
1 : Big land (5x5x10)
.br
2 : User land (as defined by options)

.TP
.BI -eyedistance " -1...1"
If not 0 the game is with real 3D. But you need to cross-eye
(or the opposite). The value is positive if your right eye look
the left image et the left eye look the right one.
Indicate a negative value to swap the two images.

.SH FILES
.IP /usr/local/lib/xbl
Directory which contains the score tables and
COPYING file (FSF GPL)
.IP /usr/lib/X11/app-defaults/Xbl
Defaults for Xbl, this file only contains a data:
the option line for Xbl.
.br
.B "xbl*args: -x 5 -y 5 -z 10 -level 0 \\\\ "
.br
.B "          -bloctype 2 -land 0 \\\\ "
.br
.B "          -draw 2 -smooth -buffer -1 \\\\ "
.br
.B "          -keyboard 4 \\\\ "
.br
.B "          -keytable '14789632azqswx ^[p^C0' "
.br


.SH "ENVIRONMENT VARIABLES"
.IP XBLOPTIONS
.I Xbl
will search his options in this variable, you can put :
.br
.B "XBLOPTIONS='-smooth -draw 0' export XBLOPTIONS"
.br
in your
.I .profile
or
.I .login
file.

.SH "BUGS"
If sometime a block fall multiple level at once it indicates that
your
.B fps
is set too high.

SOUND isn't correct on some X server, no possible correction.

FLICKING DISPLAY on some X server that doesn't handle
.I XSync
correctly.
You can turn around using : 
.I -buffer 2

DIRTY POINT on screen because some X servers don't draw the same pixels
for the same segment. You can turn around using : 
.I -clearline 0
or
.I -linewidth 1

FOCUS WINDOW doesn't work with OpenWin, so put the cursor in the game window.

DEMO mode seems to cheat (blocs going through other blocs) but
it is because the visualization show a direct way (it sums
all the transformations up).
In fact, the real way could use very complex and tortuous indirect path.

.SH "SEE ALSO"
.BI X (1)
.BI xrdb (1)
.SH AUTHORS
.B Thierry.EXCOFFIER@liris.univ-lyon1.fr
and
I thank all the people who gave me ideas, help, bugs :
.br
tchaboud@lip.ens-lyon.fr   (Thomas Chaboud)
.br
jwz@lucid.com              (Jamie Zawinski)
.br
mqh@mqh.cit.cornell.edu    (Mike Hojnowski)
.br
g1berand@cdf.toronto.edu   (Leung Chung Shing Anderson)
.br
lemke@lupine.uucp          (Dave Lemke)
.br
And many others.

Blockout is a registered trademark of Kadon Enterprises, Inc., used by permission. http://www.gamepuzzles.com

