/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441FileReceive.h"
#include "FSK441Defs.h"
#include "FSK441App.h"

#include "common/SoundFile.h"

#include <wx/debug.h>
#include <wx/log.h>
#include <wx/filename.h>

CFSK441FileReceive::CFSK441FileReceive(const wxString& name, EWho who) :
CFSK441Receive(name, who),
m_fileName(wxEmptyString),
m_soundDev(NULL)
{
}

CFSK441FileReceive::~CFSK441FileReceive()
{
}

bool CFSK441FileReceive::getEndTime()
{
	return false;
}

void CFSK441FileReceive::setFileName(const wxString& fileName)
{
	wxASSERT(m_soundDev == NULL);

	m_fileName = fileName;

	m_soundDev = new CSoundFile(fileName, FSK441_SAMPLE_RATE);
	m_soundDev->openRead();
}

void CFSK441FileReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);
}

void CFSK441FileReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
	delete m_soundDev;

	m_soundDev = NULL;
}

void CFSK441FileReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);
}

wxString CFSK441FileReceive::createId()
{
	wxFileName fileName(m_fileName);

	return fileName.GetName();
}

void CFSK441FileReceive::error(const wxString& text)
{
	::wxLogError(wxT("%s: %s"), getName().c_str(), text.c_str());

	::wxGetApp().error(text);
}
