/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "Hann.h"

#include <wx/log.h>
#include <wx/debug.h>

#include <cmath>
using namespace std;

CHann::CHann(int length) :
CWindow(length)
{
	for (int i = 0; i < m_length; i++) {
		double frac = double(i) / double(m_length);

		m_window[i] = 0.5 - 0.5 * ::cos(2.0 * M_PI * frac);
	}
}

CHann::~CHann()
{
}
