// $Id: CallbacksEditOperations.cpp,v 1.7 2001/10/30 15:33:00 nekeme Exp $
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "support.h"
#include "interface.h"

#include "../Main.h"
#include "../Application.h"
#include "../TerrainView.h"
#include "CallbacksEdit.h"
#include "CallbacksBrowse.h"
#include "CallbacksGround.h"
#include "CallbacksHeight.h"

#include "UIGtk.h"


// Helper function for undo/redo stuff
static void SetSensitiveAndText(int s, const char* bname, const char* iname, const char* text)
{
    if (!g_MainWindow) return;

    GtkWidget* Button = lookup_widget(g_MainWindow, bname);
    GtkWidget* MenuItem = lookup_widget(g_MainWindow, iname);

    gtk_widget_set_sensitive(Button, s);
    gtk_widget_set_sensitive(MenuItem, s);

#if 0
    GtkWidget* child = GTK_BIN( MenuItem )->child;

    /* do stuff with child */
    if ( GTK_IS_LABEL( child ) )
    {
	gtk_label_set_text(GTK_LABEL(child), text);
    }
#endif
}

// Enable undo commands
void EnableUndoCommands(int s, const char* text)
{
    SetSensitiveAndText(s, "UndoButton", "UndoMenuItem", text);
}

// Enable redo commands
void EnableRedoCommands(int s, const char* text)
{
    SetSensitiveAndText(s, "RedoButton", "RedoMenuItem", text);
}


// Internal function to toggle active and set page number
static void ChangeModeEnabled(int origin,
    const char* ButtonName,
    int page)
{
  // We did not click on button, update it
  GtkToggleButton* button = GTK_TOGGLE_BUTTON( lookup_widget(g_MainWindow, ButtonName) );

  if (gtk_toggle_button_get_active(button) == FALSE)
    gtk_toggle_button_set_active( button, TRUE );


  // Change notebook pagei
  GtkNotebook* notebook =
     GTK_NOTEBOOK( lookup_widget(g_MainWindow, "ToolsNotebook") );

  // FIXME: this hardcoded parameter for origin is an UGLY HACK.
  if (origin != 2 && gtk_notebook_get_current_page(notebook) != page)
    gtk_notebook_set_page(notebook, page);
}

// Go in Browse mode
void BrowseEnabled(int origin)
{
  if (!Application::GetApplication())  return;

  ChangeModeEnabled(origin, "BrowseRadioButton", 0);
  UpdateBrowse();
}

// Go in Groung mode
void GroundEnabled(int origin)
{
  if (!Application::GetApplication())  return;

  ChangeModeEnabled(origin, "GroundRadioButton", 1);
  UpdateGround();
}

// Go in Height mode
void HeightEnabled(int origin)
{
  if (!Application::GetApplication())  return;

  ChangeModeEnabled(origin, "HeightRadioButton", 2);
  UpdateHeight();
}


