/*
 * $Id: ui_goodies.c,v 1.3.4.1 1999/01/15 08:47:35 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk F"orsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ui_goodies.c - handle the user interface elements in the Goodies popup.
 */
static char ui_goodies_id[] = "$Id: ui_goodies.c,v 1.3.4.1 1999/01/15 08:47:35 dirk Exp $";

#include <stdio.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include "config.h"
#include "struct.h"
#include "proto.h"

extern goodies_objects *Workman_goodies;
extern window1_objects *Workman_window1;
extern struct wm_drive drive;

/*
 * Expand the window to show the CDDA functions.
 */
void
expand_goodies( Panel_item item, Event *event )
{
	static int	expanded = 0;

	if (! expanded)
	{
		xv_set(Workman_goodies->goodies,
			XV_WIDTH, Workman_goodies->bigwidth,
			NULL);
		xv_set(Workman_goodies->cdda,
			XV_SHOW, TRUE,
			NULL);
		xv_set(item,
			PANEL_LABEL_STRING, "-",
			NULL);
		expanded = 1;
	}
	else
	{
		xv_set(Workman_goodies->goodies,
			XV_WIDTH, Workman_goodies->smallwidth,
			NULL);
		xv_set(item,
			PANEL_LABEL_STRING, "+",
			NULL);
		expanded = 0;
	}
}

/*
 * Change the play speed.
 */
void
change_speed(Panel_item item, int value, Event *event )
{
#ifdef BUILD_CDDA
	static int	oldval = 128;

	if (value == oldval)
		return;

	oldval = value;

	if (value > 108 && value < 148)
		value = 128;

	pause_cd();
	gen_set_speed(value);
	pause_cd();
#endif
}

/*
 * Start saving to a file, if one has been specified.  Or stop saving, if
 * we were before.
 */
void
change_save(Panel_item item, int value, Event event)
{
#ifdef BUILD_CDDA
	/*
	 * Stop saving?
	 */
	if (value == 0)
	{
		xv_set(Workman_goodies->filename, PANEL_READ_ONLY, FALSE, NULL);
		gen_save(NULL);
	}
	else
	{
		xv_set(Workman_goodies->filename, PANEL_READ_ONLY, TRUE, NULL);
		gen_save(xv_get(Workman_goodies->filename, PANEL_VALUE));
	}
#endif
}

/*
 * Change the play style (actually the play direction.)
 */
void
change_style(Panel_item item, int value, Event *event)
{
#ifdef BUILD_CDDA
	static int	oldval = 2;

	if (value == oldval)
		return;

	oldval = value;

	switch (value) {
	case 0:		/* reverse */
		pause_cd();
		gen_set_direction(1);
		pause_cd();
		break;
	
	case 1:		/* forward */
		pause_cd();
		gen_set_direction(0);
		pause_cd();
		break;
	}
#endif
}

/*
 * Change the loudness level.
 */
void
change_range(Panel_item item, int value, Event *event)
{
#ifdef BUILD_CDDA
	pause_cd();
	gen_set_loudness((value * 255) / 100);
	pause_cd();
#endif
}

/*
 * Enable or disable the save button depending on whether there's text
 * in the filename field.
 */
Panel_setting
change_filename( Panel_item item, Event *event )
{
#ifdef BUILD_CDDA
	char		*value;

	value = (char *)xv_get(item, PANEL_VALUE);
	if (value != NULL && value[0])
	{
		if (xv_get(Workman_goodies->save, PANEL_INACTIVE))
			xv_set(Workman_goodies->save, PANEL_INACTIVE, FALSE,
				NULL);
	}
	else
		xv_set(Workman_goodies->save, PANEL_INACTIVE, TRUE, NULL);

#endif
	return (PANEL_INSERT);
}

/*
 * Toggle digital audio.
 */
void
change_cdda(Panel_item item, int value, Event *event)
{
#ifdef BUILD_CDDA
	goodies_objects *ip = Workman_goodies;

	pause_cd();

	if (value)
	{
		if (cdda_init(&drive) == 0)
		{
			/*
			 * Can't do CDDA.  Disable the button.
			 */
			fprintf(stderr, "can't do CDDA\n");

			xv_set(item,
				PANEL_VALUE, 0,
				PANEL_INACTIVE, TRUE,
				NULL);
		}
		else
		{
			xv_set(ip->playspeed, PANEL_INACTIVE, FALSE, NULL);
			xv_set(ip->playstyle, PANEL_INACTIVE, FALSE, NULL);
			xv_set(ip->range, PANEL_INACTIVE, FALSE, NULL);
			xv_set(ip->filename, PANEL_INACTIVE, FALSE, NULL);
			change_filename(ip->filename, event);
		}
	}
	else
	{
		cdda_kill(&drive);
		xv_set(ip->playspeed, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->playstyle, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->range, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->filename, PANEL_INACTIVE, TRUE, NULL);
		xv_set(ip->save, PANEL_INACTIVE, TRUE, NULL);
	}

	pause_cd();

	if (drive.set_volume)
		set_volume(Workman_window1->volume,
			xv_get(Workman_window1->volume, PANEL_VALUE), NULL);
#endif
}

/*
 * Let the user pop up the CDDA panel.
 */
void
enable_cdda_controls(int cdda_on)
{
#ifdef BUILD_CDDA
	xv_set(Workman_goodies->expand, XV_SHOW, TRUE, NULL);
	xv_set(Workman_goodies->title, PANEL_VALUE, cdda_on, NULL);
	change_cdda(Workman_goodies->title, cdda_on, NULL);
	expand_goodies(Workman_goodies->expand, NULL);
#endif
}
