/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#ifndef KEYSYM_H
#define KEYSYM_H

#include <SDL/SDL_keysym.h>

namespace wftk {

enum {
 	KEY_UNKNOWN		= 0, ///< \hideinitializer .
	KEY_FIRST		= 0,
	KEY_BACKSPACE		= 8, ///< \hideinitializer .
	KEY_TAB			= 9, ///< \hideinitializer .
	KEY_CLEAR		= 12, ///< \hideinitializer .
	KEY_RETURN		= 13, ///< \hideinitializer .
	KEY_PAUSE		= 19, ///< \hideinitializer .
	KEY_ESCAPE		= 27, ///< \hideinitializer .
	KEY_SPACE		= 32, ///< \hideinitializer .
	KEY_EXCLAIM		= 33, ///< \hideinitializer .
	KEY_QUOTEDBL		= 34, ///< \hideinitializer .
	KEY_HASH		= 35, ///< \hideinitializer .
	KEY_DOLLAR		= 36, ///< \hideinitializer .
	KEY_AMPERSAND		= 38, ///< \hideinitializer .
	KEY_QUOTE		= 39, ///< \hideinitializer .
	KEY_LEFTPAREN		= 40, ///< \hideinitializer .
	KEY_RIGHTPAREN		= 41, ///< \hideinitializer .
	KEY_ASTERISK		= 42, ///< \hideinitializer .
	KEY_PLUS		= 43, ///< \hideinitializer .
	KEY_COMMA		= 44, ///< \hideinitializer .
	KEY_MINUS		= 45, ///< \hideinitializer .
	KEY_PERIOD		= 46, ///< \hideinitializer .
	KEY_SLASH		= 47, ///< \hideinitializer .
	KEY_0			= 48, ///< \hideinitializer .
	KEY_1			= 49, ///< \hideinitializer .
	KEY_2			= 50, ///< \hideinitializer .
	KEY_3			= 51, ///< \hideinitializer .
	KEY_4			= 52, ///< \hideinitializer .
	KEY_5			= 53, ///< \hideinitializer .
	KEY_6			= 54, ///< \hideinitializer .
	KEY_7			= 55, ///< \hideinitializer .
	KEY_8			= 56, ///< \hideinitializer .
	KEY_9			= 57, ///< \hideinitializer .
	KEY_COLON		= 58, ///< \hideinitializer .
	KEY_SEMICOLON		= 59, ///< \hideinitializer .
	KEY_LESS		= 60, ///< \hideinitializer .
	KEY_EQUALS		= 61, ///< \hideinitializer .
	KEY_GREATER		= 62, ///< \hideinitializer .
	KEY_QUESTION		= 63, ///< \hideinitializer .
	KEY_AT			= 64, ///< \hideinitializer .
	/*
	   Skip uppercase letters
	 */
	KEY_LEFTBRACKET		= 91, ///< \hideinitializer .
	KEY_BACKSLASH		= 92, ///< \hideinitializer .
	KEY_RIGHTBRACKET	= 93, ///< \hideinitializer .
	KEY_CARET		= 94, ///< \hideinitializer .
	KEY_UNDERSCORE		= 95, ///< \hideinitializer .
	KEY_BACKQUOTE		= 96, ///< \hideinitializer .
	KEY_a			= 97, ///< \hideinitializer .
	KEY_b			= 98, ///< \hideinitializer .
	KEY_c			= 99, ///< \hideinitializer .
	KEY_d			= 100, ///< \hideinitializer .
	KEY_e			= 101, ///< \hideinitializer .
	KEY_f			= 102, ///< \hideinitializer .
	KEY_g			= 103, ///< \hideinitializer .
	KEY_h			= 104, ///< \hideinitializer .
	KEY_i			= 105, ///< \hideinitializer .
	KEY_j			= 106, ///< \hideinitializer .
	KEY_k			= 107, ///< \hideinitializer .
	KEY_l			= 108, ///< \hideinitializer .
	KEY_m			= 109, ///< \hideinitializer .
	KEY_n			= 110, ///< \hideinitializer .
	KEY_o			= 111, ///< \hideinitializer .
	KEY_p			= 112, ///< \hideinitializer .
	KEY_q			= 113, ///< \hideinitializer .
	KEY_r			= 114, ///< \hideinitializer .
	KEY_s			= 115, ///< \hideinitializer .
	KEY_t			= 116, ///< \hideinitializer .
	KEY_u			= 117, ///< \hideinitializer .
	KEY_v			= 118, ///< \hideinitializer .
	KEY_w			= 119, ///< \hideinitializer .
	KEY_x			= 120, ///< \hideinitializer .
	KEY_y			= 121, ///< \hideinitializer .
	KEY_z			= 122, ///< \hideinitializer .
	KEY_DELETE		= 127, ///< \hideinitializer .
	/* End of ASCII mapped keysyms */

	/* International keyboard syms */
	KEY_WORLD_0		= 160, ///< 0xA0
	KEY_WORLD_1		= 161, ///< \hideinitializer .
	KEY_WORLD_2		= 162, ///< \hideinitializer .
	KEY_WORLD_3		= 163, ///< \hideinitializer .
	KEY_WORLD_4		= 164, ///< \hideinitializer .
	KEY_WORLD_5		= 165, ///< \hideinitializer .
	KEY_WORLD_6		= 166, ///< \hideinitializer .
	KEY_WORLD_7		= 167, ///< \hideinitializer .
	KEY_WORLD_8		= 168, ///< \hideinitializer .
	KEY_WORLD_9		= 169, ///< \hideinitializer .
	KEY_WORLD_10		= 170, ///< \hideinitializer .
	KEY_WORLD_11		= 171, ///< \hideinitializer .
	KEY_WORLD_12		= 172, ///< \hideinitializer .
	KEY_WORLD_13		= 173, ///< \hideinitializer .
	KEY_WORLD_14		= 174, ///< \hideinitializer .
	KEY_WORLD_15		= 175, ///< \hideinitializer .
	KEY_WORLD_16		= 176, ///< \hideinitializer .
	KEY_WORLD_17		= 177, ///< \hideinitializer .
	KEY_WORLD_18		= 178, ///< \hideinitializer .
	KEY_WORLD_19		= 179, ///< \hideinitializer .
	KEY_WORLD_20		= 180, ///< \hideinitializer .
	KEY_WORLD_21		= 181, ///< \hideinitializer .
	KEY_WORLD_22		= 182, ///< \hideinitializer .
	KEY_WORLD_23		= 183, ///< \hideinitializer .
	KEY_WORLD_24		= 184, ///< \hideinitializer .
	KEY_WORLD_25		= 185, ///< \hideinitializer .
	KEY_WORLD_26		= 186, ///< \hideinitializer .
	KEY_WORLD_27		= 187, ///< \hideinitializer .
	KEY_WORLD_28		= 188, ///< \hideinitializer .
	KEY_WORLD_29		= 189, ///< \hideinitializer .
	KEY_WORLD_30		= 190, ///< \hideinitializer .
	KEY_WORLD_31		= 191, ///< \hideinitializer .
	KEY_WORLD_32		= 192, ///< \hideinitializer .
	KEY_WORLD_33		= 193, ///< \hideinitializer .
	KEY_WORLD_34		= 194, ///< \hideinitializer .
	KEY_WORLD_35		= 195, ///< \hideinitializer .
	KEY_WORLD_36		= 196, ///< \hideinitializer .
	KEY_WORLD_37		= 197, ///< \hideinitializer .
	KEY_WORLD_38		= 198, ///< \hideinitializer .
	KEY_WORLD_39		= 199, ///< \hideinitializer .
	KEY_WORLD_40		= 200, ///< \hideinitializer .
	KEY_WORLD_41		= 201, ///< \hideinitializer .
	KEY_WORLD_42		= 202, ///< \hideinitializer .
	KEY_WORLD_43		= 203, ///< \hideinitializer .
	KEY_WORLD_44		= 204, ///< \hideinitializer .
	KEY_WORLD_45		= 205, ///< \hideinitializer .
	KEY_WORLD_46		= 206, ///< \hideinitializer .
	KEY_WORLD_47		= 207, ///< \hideinitializer .
	KEY_WORLD_48		= 208, ///< \hideinitializer .
	KEY_WORLD_49		= 209, ///< \hideinitializer .
	KEY_WORLD_50		= 210, ///< \hideinitializer .
	KEY_WORLD_51		= 211, ///< \hideinitializer .
	KEY_WORLD_52		= 212, ///< \hideinitializer .
	KEY_WORLD_53		= 213, ///< \hideinitializer .
	KEY_WORLD_54		= 214, ///< \hideinitializer .
	KEY_WORLD_55		= 215, ///< \hideinitializer .
	KEY_WORLD_56		= 216, ///< \hideinitializer .
	KEY_WORLD_57		= 217, ///< \hideinitializer .
	KEY_WORLD_58		= 218, ///< \hideinitializer .
	KEY_WORLD_59		= 219, ///< \hideinitializer .
	KEY_WORLD_60		= 220, ///< \hideinitializer .
	KEY_WORLD_61		= 221, ///< \hideinitializer .
	KEY_WORLD_62		= 222, ///< \hideinitializer .
	KEY_WORLD_63		= 223, ///< \hideinitializer .
	KEY_WORLD_64		= 224, ///< \hideinitializer .
	KEY_WORLD_65		= 225, ///< \hideinitializer .
	KEY_WORLD_66		= 226, ///< \hideinitializer .
	KEY_WORLD_67		= 227, ///< \hideinitializer .
	KEY_WORLD_68		= 228, ///< \hideinitializer .
	KEY_WORLD_69		= 229, ///< \hideinitializer .
	KEY_WORLD_70		= 230, ///< \hideinitializer .
	KEY_WORLD_71		= 231, ///< \hideinitializer .
	KEY_WORLD_72		= 232, ///< \hideinitializer .
	KEY_WORLD_73		= 233, ///< \hideinitializer .
	KEY_WORLD_74		= 234, ///< \hideinitializer .
	KEY_WORLD_75		= 235, ///< \hideinitializer .
	KEY_WORLD_76		= 236, ///< \hideinitializer .
	KEY_WORLD_77		= 237, ///< \hideinitializer .
	KEY_WORLD_78		= 238, ///< \hideinitializer .
	KEY_WORLD_79		= 239, ///< \hideinitializer .
	KEY_WORLD_80		= 240, ///< \hideinitializer .
	KEY_WORLD_81		= 241, ///< \hideinitializer .
	KEY_WORLD_82		= 242, ///< \hideinitializer .
	KEY_WORLD_83		= 243, ///< \hideinitializer .
	KEY_WORLD_84		= 244, ///< \hideinitializer .
	KEY_WORLD_85		= 245, ///< \hideinitializer .
	KEY_WORLD_86		= 246, ///< \hideinitializer .
	KEY_WORLD_87		= 247, ///< \hideinitializer .
	KEY_WORLD_88		= 248, ///< \hideinitializer .
	KEY_WORLD_89		= 249, ///< \hideinitializer .
	KEY_WORLD_90		= 250, ///< \hideinitializer .
	KEY_WORLD_91		= 251, ///< \hideinitializer .
	KEY_WORLD_92		= 252, ///< \hideinitializer .
	KEY_WORLD_93		= 253, ///< \hideinitializer .
	KEY_WORLD_94		= 254, ///< \hideinitializer .
	KEY_WORLD_95		= 255, ///< 0xFF

	/* Numeric keypad */
	KEY_KP0			= 256, ///< \hideinitializer .
	KEY_KP1			= 257, ///< \hideinitializer .
	KEY_KP2			= 258, ///< \hideinitializer .
	KEY_KP3			= 259, ///< \hideinitializer .
	KEY_KP4			= 260, ///< \hideinitializer .
	KEY_KP5			= 261, ///< \hideinitializer .
	KEY_KP6			= 262, ///< \hideinitializer .
	KEY_KP7			= 263, ///< \hideinitializer .
	KEY_KP8			= 264, ///< \hideinitializer .
	KEY_KP9			= 265, ///< \hideinitializer .
	KEY_KP_PERIOD		= 266, ///< \hideinitializer .
	KEY_KP_DIVIDE		= 267, ///< \hideinitializer .
	KEY_KP_MULTIPLY		= 268, ///< \hideinitializer .
	KEY_KP_MINUS		= 269, ///< \hideinitializer .
	KEY_KP_PLUS		= 270, ///< \hideinitializer .
	KEY_KP_ENTER		= 271, ///< \hideinitializer .
	KEY_KP_EQUALS		= 272, ///< \hideinitializer .

	/* Arrows + Home/End pad */
	KEY_UP			= 273, ///< \hideinitializer .
	KEY_DOWN		= 274, ///< \hideinitializer .
	KEY_RIGHT		= 275, ///< \hideinitializer .
	KEY_LEFT		= 276, ///< \hideinitializer .
	KEY_INSERT		= 277, ///< \hideinitializer .
	KEY_HOME		= 278, ///< \hideinitializer .
	KEY_END			= 279, ///< \hideinitializer .
	KEY_PAGEUP		= 280, ///< \hideinitializer .
	KEY_PAGEDOWN		= 281, ///< \hideinitializer .

	/* Function keys */
	KEY_F1			= 282, ///< \hideinitializer .
	KEY_F2			= 283, ///< \hideinitializer .
	KEY_F3			= 284, ///< \hideinitializer .
	KEY_F4			= 285, ///< \hideinitializer .
	KEY_F5			= 286, ///< \hideinitializer .
	KEY_F6			= 287, ///< \hideinitializer .
	KEY_F7			= 288, ///< \hideinitializer .
	KEY_F8			= 289, ///< \hideinitializer .
	KEY_F9			= 290, ///< \hideinitializer .
	KEY_F10			= 291, ///< \hideinitializer .
	KEY_F11			= 292, ///< \hideinitializer .
	KEY_F12			= 293, ///< \hideinitializer .
	KEY_F13			= 294, ///< \hideinitializer .
	KEY_F14			= 295, ///< \hideinitializer .
	KEY_F15			= 296, ///< \hideinitializer .

	/* Key state modifier keys */
	KEY_NUMLOCK		= 300, ///< \hideinitializer .
	KEY_CAPSLOCK		= 301, ///< \hideinitializer .
	KEY_SCROLLOCK		= 302, ///< \hideinitializer .
	KEY_RSHIFT		= 303, ///< \hideinitializer .
	KEY_LSHIFT		= 304, ///< \hideinitializer .
	KEY_RCTRL		= 305, ///< \hideinitializer .
	KEY_LCTRL		= 306, ///< \hideinitializer .
	KEY_RALT		= 307, ///< \hideinitializer .
	KEY_LALT		= 308, ///< \hideinitializer .
	KEY_RMETA		= 309, ///< \hideinitializer .
	KEY_LMETA		= 310, ///< \hideinitializer .
	KEY_LSUPER		= 311, ///< \hideinitializer Left "Windows" key
	KEY_RSUPER		= 312, ///< \hideinitializer Right "Windows" key
	KEY_MODE		= 313, ///< \hideinitializer "Alt Gr" key

	/* Miscellaneous function keys */
	KEY_HELP		= 315, ///< \hideinitializer .
	KEY_PRINT		= 316, ///< \hideinitializer .
	KEY_SYSREQ		= 317, ///< \hideinitializer .
	KEY_BREAK		= 318, ///< \hideinitializer .
	KEY_MENU		= 319, ///< \hideinitializer .
	KEY_POWER		= 320, ///< \hideinitializer Power Macintosh power key
	KEY_EURO		= 321, ///< \hideinitializer Some european keyboards

	/* Add any other keys here */

	KEY_LAST
};

enum {
  KEY_MOD_NONE  = KMOD_NONE,   ///< \hideinitializer .
  KEY_MOD_NUM   = KMOD_NUM,    ///< \hideinitializer .
  KEY_MOD_LCTRL = KMOD_LCTRL,  ///< \hideinitializer .
  KEY_MOD_RCTRL = KMOD_RCTRL,  ///< \hideinitializer .
  KEY_MOD_CAPS  = KMOD_CAPS,   ///< \hideinitializer .
  KEY_MOD_RSHIFT= KMOD_RSHIFT, ///< \hideinitializer .
  KEY_MOD_LSHIFT= KMOD_LSHIFT, ///< \hideinitializer .
  KEY_MOD_LALT  = KMOD_LALT,   ///< \hideinitializer .
  KEY_MOD_RALT  = KMOD_RALT,   ///< \hideinitializer .
  KEY_MOD_LMETA = KMOD_LMETA,  ///< \hideinitializer .
  KEY_MOD_RMETA = KMOD_RMETA   ///< \hideinitializer .
};

#define KEY_MOD_CTRL	(KEY_MOD_LCTRL|KEY_MOD_RCTRL)   ///< .
#define KEY_MOD_SHIFT	(KEY_MOD_LSHIFT|KEY_MOD_RSHIFT) ///< .
#define KEY_MOD_ALT	(KEY_MOD_LALT|KEY_MOD_RALT)     ///< .

}

#endif
