/*
  libu - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "multilineedit.h"
#include "pushbutton.h"
#include "sample.h"
#include "mixer.h"
#include "videowidget.h"
#include "rootwindow.h"
#include "debug.h"
#include "box.h"
#include "filler.h"

#include "quitcheck.h"

#include <iostream>

using namespace wftk;

/* MediaPlayer.
   currently it works only under linux, since it uses the MPEGfile class
   which uses memory mapped files.
   
   if anyone has got a good idea how to do something comparable 
   under Windows feel free to hack it in and send a patch

*/

class MpegPlay : public QuitCheckApp
{
 public:

  MpegPlay(int argc, char** argv) : QuitCheckApp(argc, argv) 
    {
      std::cout << "starting up ..." << std::endl;
      //do you init here

      int movienum = (argc > 1 && strcmp(argv[1],"--") == 0) ? 2 : 1;
      std::string moviename;

      if(movienum >= argc)
        {
          std::cout << "filename :";
          std::cin >> moviename;
        }
      else
        moviename = argv[movienum];

      RootWindow* back = new RootWindow(1, 1);

      back->setTitle("MediaPlayer");

      //eg fontloading ....
      // These fonts are used by several gui elements,
      // so you should slways load text_font and button_font when
      // using widgets from libwftk.
      Font::registry.load("text_font","wf_opal.ttf, 18, 0xF0F0F0, 0x101010");
      Font::registry.load("button_font","wf_opal.ttf, 18, 0xF0F0F0, 0x101010");

      if(Mixer::instance()->audioAvailable()) {
        //register this wav file as resources "press"
        //which is played whenever an button gets pressed
        Sample::registry.load("press","press.wav");
        //same but for "release"
        Sample::registry.load("release","release.wav");
      }

      Box *main_box = new Box(Box::LEFT_TO_RIGHT);
      back->pack(main_box);

      Box *left_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(left_box);

      VideoWidget* video = new VideoWidget();
      left_box->packBack(video);

      //create your gui here
      left_box->packFront(new MultiLineEdit("MediaPlay - a simple mpeg player\n\n"
					    "written by Karsten Laux using the LibUta Toolkit"));

      Box *right_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(right_box);

      right_box->packBack(new Filler(Filler::VERTICAL));

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      quit_button->setColor(Color(32,32,128));
      right_box->packBack(quit_button);

      //connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());

      video->load(moviename);
      video->play();

      back->resize();
    }
};

int main (int argc, char **argv)
{
  return MpegPlay(argc, argv).exec();
}

