/*
 * WallFire -- a comprehensive firewall administration tool.
 * 
 * Copyright (C) 2001-2002 Herv Eychenne <rv@wallfire.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

using namespace std;

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#include "wftcpflags.h"
#include "defs.h"


struct wf_tcpflag wf_tcpflag_list[] = {
  { TCP_SYN, "SYN", 's' },
  { TCP_ACK, "ACK", 'a' },
  { TCP_FIN, "FIN", 'f' },
  { TCP_RST, "RST", 'r' },
  { TCP_PSH, "PSH", 'p' },
  { TCP_URG, "URG", 'u' },
  { TCP_ECE, "ECE", 'e' },
  { TCP_CWR, "CWR", 'c' },
  { 0, "", '\0' }
};

wf_tcpflags::wf_tcpflags() :
  flags(0)
{}

wf_tcpflags::wf_tcpflags(const string& str) {
  set(str);
}


bool
wf_tcpflags::set(const string& str) {
  uint8_t tcpf = 0;

  string::const_iterator first = str.begin(), last = str.end();
  for ( ; first != last; ++first) {
    unsigned int i;
    for (i = 0; wf_tcpflag_list[i].flag; i++) {
      if (tolower(*first) == wf_tcpflag_list[i].letter) {
	tcpf |= wf_tcpflag_list[i].flag;
	break;
      }
    }
    if (wf_tcpflag_list[i].flag == 0) {
      fprintf(stderr, _("Error: wrong TCP flag `%c'.\n"), *first);
      return false;
    }
  }
  flags = tcpf;
  return true;
}

void
wf_tcpflags::setall() {
  flags = TCP_MAX;
}

string
wf_tcpflags::tostr() const {
  string str;
  unsigned int i;
  for (i = 0; wf_tcpflag_list[i].flag; i++) {
    if (flags & wf_tcpflag_list[i].flag)
      str += ' ' + wf_tcpflag_list[i].str;
  }
  return str;
}

string
wf_tcpflags::tostr_mini() const {
  if (!flags)
    return "-";

  if (flags == TCP_SYN)
    return "SYN";

  string str;
  unsigned int i;
  for (i = 0; wf_tcpflag_list[i].flag; i++) {
    if (flags & wf_tcpflag_list[i].flag)
      str += wf_tcpflag_list[i].letter;
    else
      str += '-';
  }
  return str;
}
