#!/usr/bin/perl
#
# save_output.cgi
#
# This script takes in the new output settings
# and saves them in the configuration file

# Do common initialization and get common routines
require 'snort-lib.pl';
ReadParse();

# Check if user can switch rule status
$whatfailed = "Unable to save changes";
$access{'out'} || &snort_error($text{'output_ecannot'});

# Lets lock the file here to be sure we get the right line numbers
lock_file($config{'snort_config'});

# Read in rule config data
$conf = &get_config("out");

# Lets find any changes and replace the lines
$data = &read_file_lines($config{'snort_config'});

foreach $key (keys %$conf) {
   $stat_key = join("", $key, "_stat");
   # Check for option changes or a change in status
   if (($$conf{$key}->{'value'} ne $in{$key}) || ($$conf{$key}->{'disabled'} ==  $in{$stat_key})) {
      # The data has changed, lets
      $data_idx = $$conf{$key}->{'line'};
      ($outkey) = split('__', $key);  # Make sure we strip the index for saving in the conf file
      $new_tuple= "output " . $outkey;
      $new_tuple .= ": " . $in{$key} if $in{$key};
      $new_tuple = "#" . $new_tuple if (!$in{$stat_key});  
      $$data[$data_idx] = $new_tuple;
   }
}

&flush_file_lines();  # Store the new data
unlock_file($config{'snort_config'});

# Log the change
&webmin_log("output", undef, $config{'snort_config'},
	    { 'file' => $config{'snort_config'} });

# Redirect user back to main page
&redirect("index.cgi");
