#!/usr/bin/perl
# conf_output.cgi
# Display a form for updating the Snort alert/output settings

require './snort-lib.pl';
&ReadParse();

$access{'out'} || &snort_error($text{'output_ecannot'});

# Get all output variables
$conf = &get_config("out");

&header($text{'output_title'}, "");

print "<hr>\n";
print "<form method=\"post\" action=\"save_output.cgi\">\n";

print "<table border=0 cellspacing=0 width=100%>\n";
print "<tr $tb><td colspan=3><b>$text{'output_header'}</b></td></tr>\n";
print "<tr $cb><th>$text{'output_col1'}</th><th>$text{'output_col2'}</th><th>$text{'output_col3'}</th></tr>\n";

foreach $opt (sort {$$conf{$a}->{'index'} <=> $$conf{$b}->{'index'}} (keys %$conf)) {
   &std_setting($opt, $$conf{$opt}->{'value'}, 1, !$$conf{$opt}->{'disabled'});
}

print "</table>\n<p>\n";
print "<input type=submit value=\"$text{'save'}\"> ",
      "<input type=reset value=\"$text{'undo'}\">\n";
print "</form>\n";

print "<hr>\n";
&footer("index.cgi", $text{'back_link'});

