#!/usr/local/bin/perl
# list_tprivs.cgi
# Display a list of table priviliges

require './mysql-lib.pl';
$access{'perms'} || &error($text{'perms_ecannot'});
&ui_print_header(undef, $text{'tprivs_title'}, "", "tprivs");

$d = &execute_sql($master_db, "select * from tables_priv order by table_name");
if (@{$d->{'data'}}) {
	&show_button();
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'tprivs_table'}</b></td>\n",
	      "<td><b>$text{'tprivs_db'}</b></td>\n",
	      "<td><b>$text{'tprivs_host'}</b></td>\n",
	      "<td><b>$text{'tprivs_user'}</b></td>\n",
	      "<td><b>$text{'tprivs_privs1'}</b></td>\n",
	      "<td><b>$text{'tprivs_privs2'}</b></td> </tr>\n";
	$i = -1;
	foreach $u (@{$d->{'data'}}) {
		$i++;
		next if ($access{'perms'} == 2 && !&can_edit_db($u->[1]));
		print "<tr $cb>\n";
		print "<td><a href='edit_tpriv.cgi?idx=$i'>",
			&html_escape($u->[3]),"</a></td>\n";
		print "<td>",&html_escape($u->[1]),"</td>\n";
		print "<td>", $u->[0] eq '' || $u->[0] eq '%' ?
		      $text{'tprivs_all'} : &html_escape($u->[0]),"</td>\n";
		print "<td>",$u->[2] ? &html_escape($u->[2])
				     : $text{'tprivs_anon'},"</td>\n";
		print "<td>",!$u->[6] ? $text{'tprivs_none'} :
		     join("&nbsp;| ",split(/[, ]+/, $u->[6])),"</td>\n";
		print "<td>",!$u->[7] ? $text{'tprivs_none'} :
		     join("&nbsp;| ",split(/[, ]+/, $u->[7])),"</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<p><b>$text{'tprivs_norows'}</b><p>\n";
	}
&show_button();

&ui_print_footer("", $text{'index_return'});

sub show_button
{
print "<form action=edit_tpriv.cgi>\n";
print "<input type=submit value='$text{'tprivs_add'}'>\n";
print "<select name=db>\n";
foreach $t (&list_databases()) {
	print "<option>$t\n" if ($access{'perms'} == 1 ||
				 &can_edit_db($t));
	}
print "</select></form>\n";
}

