#!/usr/local/bin/perl
# Parse the firewall log and rotate it

$no_acl_check++;
require './bandwidth-lib.pl';
use Time::Local;

$time_now = time();
@time_now = localtime($time_now);
%mmap = ( 'jan' => 0, 'feb' => 1, 'mar' => 2, 'apr' => 3,
	  'may' => 4, 'jun' => 5, 'jul' => 6, 'aug' => 7,
	  'sep' => 8, 'oct' => 9, 'nov' =>10, 'dec' =>11 );

# Scan the entries in the log file
open(LOG, $bandwidth_log);
while(<LOG>) {
	if (/^(\S+)\s+(\d+)\s+(\d+):(\d+):(\d+).*BANDWIDTH_(IN|OUT):(IN=.*)/) {
		# Found a valid line
		$lastline = $_;
		&process_line($_);
		}
	elsif (/last\s+message\s+repeated\s+(\d+)/) {
		# re-process the last line N-1 times
		for($i=0; $i<$1-1; $i++) {
			&process_line($lastline);
			}
		}
	else {
		#print "skipping $_";
		}
	}
close(LOG);

# Save all hours
foreach $hour (@hours) {
	&save_hour($hour);
	}

# Truncate the file and notify syslog
open(LOG, ">$bandwidth_log");
close(LOG);
&syslog::signal_syslog();

sub process_line
{
if ($_[0] =~ /^(\S+)\s+(\d+)\s+(\d+):(\d+):(\d+).*BANDWIDTH_(IN|OUT):(IN=.*)/) {
	# Found a valid line
	local ($mon, $day, $hr, $min, $sec) = ($1, $2, $3, $4, $5);
	local $dir = lc($6);
	local %line;
	foreach $w (split(/\s+/, $7)) {
		($n, $v) = split(/=/, $w);
		if ($n) {
			$line{lc($n)} = $v;
			}
		}

	# Work out the real time
	local $tm = timelocal($sec, $min, $hr, $day,
			      $mmap{lc($mon)}, $time_now[5]);
	if ($tm > $time_now + 24*60*60) {
		# Was really last year
		$tm = timelocal($sec, $min, $hr, $day,
				$mmap{lc($mon)}, $time_now[5]-1);
		}
	$htm = int($tm/(60*60));

	# Update the appropriate counters
	if (!$hour || $htm != $hour->{'hour'}) {
		$hour = &get_hour($htm);
		$hour->{'hour'} ||= $htm;
		push(@hours, $hour);
		}
	local $port;
	if ($line{'proto'} eq 'TCP' || $line{'proto'} eq 'UDP') {
		if ($dir eq "in") {
			$port = '_'.$line{'dpt'}.'_'.$line{'spt'};
			}
		else {
			$port = '_'.$line{'spt'}.'_'.$line{'dpt'};
			}
		}
	$host = $dir eq "in" ? $line{'dst'} : $line{'src'};
	$key = $host.'_'.$line{'proto'}.$port;
	($in, $out) = split(/ /, $hour->{$key});
	if ($dir eq "in") {
		$in += $line{'len'};
		}
	else {
		$out += $line{'len'};
		}
	$hour->{$key} = int($in)." ".int($out);
	}
}


