#!/usr/local/bin/perl
# index.cgi
# Show all cron jobs that run on multiple servers

require './cluster-cron-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "intro", 0, 1);

@jobs = &list_cluster_jobs();
if (@jobs) {
	print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$cron::text{'index_user'}</b></td> ",
	      "<td><b>$cron::text{'index_active'}</b></td> ",
	      "<td><b>$text{'index_servers'}</b></td> ",
	      "<td colspan=2><b>$cron::text{'index_command'}</b></td> </tr>\n";
	foreach $j (@jobs) {
		print "<tr $cb>\n";
		print "<td><tt>",$j->{'cluster_user'},"</tt></td>\n";
		printf "<td valign=top>%s</td>\n",
			$j->{'active'} ? $text{'yes'}
				: "<font color=#ff0000>$text{'no'}</font>";
		local @servers = map {
			$_ eq "*" ? $text{'edit_this'} :
			$_ =~ /^group_(.*)$/ ? &text('edit_group', "$1") : $_
				} split(/\s+/, $j->{'cluster_server'});
		if (@servers > 3) {
			print "<td>",join(", ", @servers[0 .. 1]),", ",
			      &text('index_more', @servers-2),"</td>\n";
			}
		else {
			print "<td>",join(", ", @servers),"</td>\n";
			}
		local $max = $cron::config{'max_len'} || 10000;
		local $cmd = $j->{'cluster_command'};
		printf "<td><a href=\"edit.cgi?id=$j->{'cluster_id'}\">".
		       "%s</a>%s</td>\n",
			length($cmd) > $max ?
				&html_escape(substr($cmd, 0, $max)) :
			$cmd !~ /\S/ ? "BLANK" : &html_escape($cmd),
			length($cmd) > $max ? " ..." : "";
		print "<td width=10><a href='exec.cgi?id=$j->{'cluster_id'}'>",
		      "$text{'index_run'}</a></td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><p>\n";

&ui_print_footer("/", $text{'index'});

