// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: DefaultPhysicalCommunicationLayer.cpp
// 
//---------------------------------------------------------------------------
#include "DefaultPhysicalCommunicationLayer.h"
using std::cerr;
using std::endl;

DefaultPhysicalCommunicationLayer::DefaultPhysicalCommunicationLayer(){};

DefaultPhysicalCommunicationLayer::~DefaultPhysicalCommunicationLayer(){};

void
DefaultPhysicalCommunicationLayer::physicalInit( SimulationConfiguration &configuration ){
   // there is nothing to be done for a
   // DefaultPhysicalCommunicationLayer since all objects are on one
   // simulation manager and so no network communication will take
   // place.
}

int
DefaultPhysicalCommunicationLayer::physicalGetId() const {
   // for a DefaultPhysicalCommunicationLayer, the id is always zero
   // since we are running a uniprocessor simulation.
   return 0;
}

void
DefaultPhysicalCommunicationLayer::physicalSend( const SerializedInstance *toSend,
						 unsigned int dest){
   cerr << "DefaultPhysicalCommunicationLayer::physicalSend "
        << "should not be called at all" << endl;
   cerr << "Exiting simulation ..." << endl;
   std::abort();
}

SerializedInstance *
DefaultPhysicalCommunicationLayer::physicalProbeRecv(){
   cerr << "DefaultPhysicalCommunicationLayer::physicalProbeRecv "
        << "should not be called at all" << endl;
   cerr << "Exiting simulation ..." << endl;
   std::abort();
   return NULL;
}

// bool
// DefaultPhysicalCommunicationLayer::physicalProbeRecvBuffer(char *buffer,
//                                                            int size,
//                                                            bool& sizeStatus){
//    cerr << "DefaultPhysicalCommunicationLayer::physicalProbeRecvBuffer "
//         << "should not be called at all" << endl;
//    cerr << "Exiting simulation ..." << endl;
//    std::abort();
//    return false;
// }

void
DefaultPhysicalCommunicationLayer::physicalFinalize(){
   // for DefaultPhysicalCommunicationLayer, we didn't initialize MPI
   // or any other communication library; so there is nothing to be
   // done for finalize.
}

