#include <ubit/ubit.hpp>
#include <ubit/ugraph.hpp>    // inclure ce header pour le graphique !
#include <vector>
using namespace std;

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 

class Drawing: public UVbox {
  struct Point {
    int x, y;
  };
  vector<Point> points;
  Point last_point;

  UColor fg;
  UBackground bg;

  UBox canvas;
  int view_count;
  UView** view_list;
  
  void mousePressed(UEvent&);
  void mouseReleased(UEvent&);
  void mouseDragged(UEvent&);
  void repaintGraphics(UEvent&);

public:
  Drawing();
};

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

int main(int argc, char *argv[]) {
  UConf conf(argc, argv);
  //conf.double_buffering = true;     // double buffering mode
  //conf.transp_scrollbars = false;
  
  UAppli appli(conf);
  appli.setImaPath("../images");     // where images should be located

  Drawing drawing;

  // creates the main frame window, adds it to the appli then shows it
  UFrame mainframe(drawing);
  appli.add(mainframe);
  mainframe.show();

  // opens clones on alternate display
  for (int k = 1; k < argc; k++) {
    UDisp* disp = appli.openDisp(argv[k]);

    if (disp) {
      UStr t = ustr("Drawing on ") & argv[k];
      UFrame& frame2 = uframe( utitle(t) + drawing );
      disp->add(frame2);
      frame2.show();
    }
  }

  return appli.mainLoop();    // starts the event loop
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

Drawing::Drawing() {

  view_count = 0;
  view_list = null;
  bg.set(UColor::white);
  fg.set(UColor::black);

  canvas.addlist            // drawing area
    (
     // NB: fg and bg will auto udpate the canvas when changed
     bg	+ fg
     + uwidth(600) + uheight(600) 
     + UOn::mpress / ucall(this, &Drawing::mousePressed)
     + UOn::mdrag  / ucall(this, &Drawing::mouseDragged)
     + UOn::mrelease  / ucall(this, &Drawing::mouseReleased)
     // repaint events
     + UOn::viewPaint / ucall(this, &Drawing::repaintGraphics)
     );

  UListbox& wallpapers = ulistbox
    (
     ulabel("Wallpaper")
     + uitem( "Ray" + usetref(&bg, UPix::ray))
     + uitem( "Bomb" + usetref(&bg, UPix::bomb))
     + uitem( "Frisco" + usetref(&bg, uima("frisco.gif")))
     + uitem( "Eiffel" + usetref(&bg, uima("tour-eiffel.gif")))
     + uitem( "printemps" + usetref(&bg, uima("printemps.gif")))
     + uitem( "Metal" + usetref(&bg, uima("metal.gif")))
     );  
  
  UBox& bg_panel = ubar
    (
     uhcenter() + uvmargin(5)
     + ulabel(UFont::bold + "Background: ")
     + ubutton( UBgcolor::black + "Black" + uset(&bg, UColor::black))
     + ubutton( UBgcolor::white + "White" + uset(&bg, UColor::white))
     + ubutton( UBgcolor::yellow+ "Yellow"+ uset(&bg, UColor::yellow))
     + ubutton( UBgcolor::red   + " Red " + uset(&bg, UColor::red))
     + ubutton( UBgcolor::green + "Green" + uset(&bg, UColor::green))
     + ucombobox(wallpapers)
     );

  UBox& fg_panel = ubar
    (
     uhcenter() + uvmargin(5)
     + ulabel(UFont::bold + "Foreround: ")
     + ubutton( UBgcolor::black + "Black" + uset(&fg, UColor::black))
     + ubutton( UBgcolor::white + "White" + uset(&fg, UColor::white))
     + ubutton( UBgcolor::yellow+ "Yellow"+ uset(&fg, UColor::yellow))
     + ubutton( UBgcolor::red   + " Red " + uset(&fg, UColor::red))
     + ubutton( UBgcolor::green + "Green" + uset(&fg, UColor::green))
     );

  addlist
    (
     uwidth(400) + uheight(300)
     + utop()    + fg_panel
     // canvas is shown twice
     + uvflex()  + uscrollpane(canvas) + uscrollpane(canvas)
     + ubottom() + bg_panel
     );
  }

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void Drawing::repaintGraphics(UEvent& e) {
  UGraph g(e);
  g.setColor(fg);

  for (unsigned int k = 1; k < points.size(); k++)
    g.drawLine(points[k-1].x, points[k-1].y, points[k].x, points[k].y);
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//this version should be used if there are several canvas views

void Drawing::mousePressed(UEvent& e) {

  // resets the vector of points. should be done before update()
  // as this fct fires the repaintGraphics() callback
  points.clear();

  // repaints all canvas views (and erase graphics as points has been reset)
  canvas.update(UUpdate::paint);

  // retreives the views of the canvas (will be deleted by mouseReleased)
  view_list = canvas.getViews(view_count);

  last_point.x = e.getX();
  last_point.y = e.getY();
  points.push_back(last_point);  
}

void Drawing::mouseReleased(UEvent& e) {
  delete view_list;   // delete the view vector created by mousePressed
  view_list = null;
  view_count = 0;
}

void Drawing::mouseDragged(UEvent& e) {
  int x = e.getX();
  int y = e.getY();

  // draws graphics on all canvas views
  for (unsigned int k = 0; k < view_count; k++) {
    UGraph g(view_list[k]);
    g.setColor(fg);
    g.drawLine(last_point.x, last_point.y, x, y);
  }

  last_point.x = x;
  last_point.y = y;
  points.push_back(last_point);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
/*
//this version should be used if there is only one canvas view

void Drawing::mousePressed(UEvent& e) {
  UGraph g(e);

  // resets the vector of points. should be done before clearView()
  // as this fct will fire the repaintGraphics() callback
  points.clear();

  // efface tout (puis reaffiche le fond si l'argument est true)
  g.clearView(true);

  last_point.x = e.getX();
  last_point.y = e.getY();
  points.push_back(last_point);
}

void Drawing::mouseDragged(UEvent& e) {
  UGraph g(e);
  g.setColor(fg);
  int x = e.getX();
  int y = e.getY();

  g.drawLine(last_point.x, last_point.y, x, y);
  last_point.x = x;
  last_point.y = y;
  points.push_back(last_point);
}

void Drawing::mouseReleased(UEvent& e) {
  //cerr << "mouseReleased "<< e.getState() << endl;
}

*/
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

