/* ==================================================== ======== ======= *
 *
 *  dlayout.cc  [demo]
 *  Ubit Project [Elc::2000]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2000 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:00] ======= *
 * ==================================================== ======== ======= */


#include <ubit/ubit.hpp>
#include "dmisc.hh"
#include "dlayout.hh"


void MyLayoutDialog::ShowInfo(UEvent&, const char *s) {
  mess.set(s);
}

UCall& MyLayoutDialog::info(char *s) {
  return ucall(this, (const char*)s, &MyLayoutDialog::ShowInfo); 
}

UCall& MyLayoutDialog::info(const char *s) {
  return ucall(this, s, &MyLayoutDialog::ShowInfo); 
}


MyLayoutDialog::MyLayoutDialog() {

  //UCall *clear = &ucall(this, &MyLayoutDialog::ShowInfo, 
  //			(const char*)"", UOn::leave);
  UStr *clear = &ustr("");

  UVbox &center_zone =
    uvbox( uhflex()
	   + UFont::large + UFont::bold
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   + ubutton("Center Zone - Center Zone - Center Zone")
	   );


  //adds children to "this" object
  addlist
    ( 
     utitle("Panes")
     + uwidth(200)

     + uhbox(uhflex() + "aaaaaaaaaaaa" + "bbbb" + "cccc" + "dd")
     + uhbox(uhflex() + ubutton("aaaaaaaaaa") + ubutton("bbbb") + ubutton("cccc") + ubutton("dd"))
     
     + uvflex()	// the Pane will be V-Justified
     
     + upane(uheight(100) + // donner la taille du Pane
	     UBorder::etchedOut

	     // -- Middle Area ---------------------------------------------
	     + uvcenter() + UHalign::center + center_zone
	     
	     + uleft() + ubutton("M+L" + info("middle + left") + clear)
	     
	     + uright() + ubutton("M+R" + info("middle + right") + clear)
	     
	     // -- Top Area ------------------------------------------------
	     + utop()
	     
	     + uhcenter()
	       + ubutton("top + center" + info("top + center") + clear)
	     
	     + uleft() + ubutton("T+L" + info("top + left") + clear)
	     
	     + uright() + ubutton("T+R" + info("top + right") + clear)
	     
	       // -- Bottom Area ---------------------------------------------
	     + ubottom ()
	     
	     + uhcenter() 
	     + ubutton("bottom + center" + info("bottom + center") + clear)
	     
	     + uleft() + ubutton("B+L" + info("bottom + left") + clear)
	     
	     + uright() + ubutton("B+R" + info("bottom + right") + clear)
	     )

     + uscrollpane(uheight(100) + // donner la taille du Pane
		   UBorder::etchedOut
		   + center_zone
		   )
     
     + UValign::top
     + uhbox(UBorder::etchedOut + uhflex()
	     // closes the dialog box when the Close button is pressed
	     + ubutton(UFont::bold + "Close" + ucloseWin()))
     );
}
