#ifndef VHDL_CC
#define VHDL_CC

//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------


#include "vhdl.hh"
#include "VHDLProcess.hh"

#include "_savant_file_open_kind.hh"
#include "_savant_file_open_status.hh"
#include "_savant_severity_level.hh"
#include "ArrayInfo.hh"
#include "SharedFileEvent.hh"
#include "SigEvent.hh"
#include "UniversalBoolean.hh"
#include "UniversalCharacter.hh"
#include "UniversalInteger.hh"
#include "UniversalLongLongInteger.hh"
#include "UniversalReal.hh"
#include "VHDLVTime.hh"
#include "WaitEvent.hh"

void registerTyvisDeserializers(){
  _savant_file_open_kind::registerDeserializer();
  _savant_file_open_status::registerDeserializer();
  _savant_severity_level::registerDeserializer();
  ArrayInfo::registerDeserializer();
  SharedFileEvent::registerDeserializer();
  SigEvent::registerDeserializer();
  UniversalBoolean::registerDeserializer();
  UniversalCharacter::registerDeserializer();
  UniversalInteger::registerDeserializer();
  UniversalLongLongInteger::registerDeserializer();
  UniversalReal::registerDeserializer();
  VHDLVTime::registerDeserializer();
  WaitEvent::registerDeserializer();
}


#endif
