#ifndef UNIVERSAL_BOOLEAN_HH
#define UNIVERSAL_BOOLEAN_HH

#include <iostream>
#include "tyvis/VHDLData.hh"
#include <warped/SerializedInstance.h>
#include <warped/DeserializerManager.h>
using std::cout;
using std::cerr;
using std::endl;

class AccessVariable;

class UniversalBoolean : public VHDLData {
  friend inline ostream& operator<<(ostream&, const UniversalBoolean&);
public:
  bool val;

  int getIntValue() const { return val; }
  LONG getInt64Value() const { return (LONG)val; }
  double getDoubleValue() const { return (double)val; }

  virtual ~UniversalBoolean() {};

  virtual VHDLData::UniversalType getUniversalKind() const{
    return UNIVERSAL_BOOLEAN;
  }

  UniversalBoolean() { 
    val = false; 
  }

  UniversalBoolean(bool b) { 
    val = b;
  }

  UniversalBoolean(int value) {
    if(value == 0) {
      val = false;
    }
    else {
      val = true;
    }
  }

  UniversalBoolean(char c) {
    switch(c) {
    case '0':
      val = false;
      break;
    case '1':
      val = true;
      break;
    default:
      cerr << "Wrong value passed" << endl;
      abort();
      break;
    }
  }

  UniversalBoolean(double value) {
    val = false;
    value = value;
    cerr << "Wrong type passed" << endl;
    abort();
   }

  UniversalBoolean(const UniversalBoolean& b) : VHDLData() { 
    val = b.val;
  }
  
  UniversalBoolean(const VHDLData& v);

  UniversalBoolean &operator=( bool b ){
    val = b;
    return *this;
  }

  bool operator==( const RValue &compareTo ) const {
    return val == dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }

  bool operator!=( const RValue &compareTo ) const {
    return val != dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }

  bool operator > ( const RValue &compareTo ) const{
    return val > dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }

  bool operator >= ( const RValue &compareTo ) const {
    return val >= dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }

  bool operator < ( const RValue &compareTo ) const {
    return val < dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }

  bool operator <= ( const RValue &compareTo ) const {
    return val <= dynamic_cast<const UniversalBoolean &>( compareTo.readVal() ).val;
  }


  VHDLData &operator=( const VHDLData &d ) {
    val = dynamic_cast<const UniversalBoolean &>(d).val;
    return *this;
  }

  UniversalBoolean& operator=(const UniversalBoolean& d) {
    val = d.val;
    return *this;
  }

  operator bool() { return val; }

  UniversalBoolean assign(char ch) { 
    val = UniversalBoolean(ch);
    return val;
  }

  int savantwrite(AccessVariable &) const;
  int savantwrite(AccessType &) const;
  int savantread(AccessVariable &);
  int savantread(AccessType &);
  int savantread(char *) {
    return NORMAL_RETURN;
  }
  
  int savantwrite( ostringstream &os ) const {
    os << val;
    return NORMAL_RETURN;
  }
  VHDLData *clone() const {
    return new UniversalBoolean(*this);
  }
  
  void print(ostream& os = cout) const { os << *this; os.flush();}

  static const string &getUniversalBooleanType(){
    static const string universalBooleanType = "UniversalBoolean";
    return universalBooleanType;
  }

  const string &getDataType() const {
    return getUniversalBooleanType();
  }

  void serialize( SerializedInstance *addTo ) const {
    addTo->addInt( int(val) );
  }

  static Serializable *deserialize( SerializedInstance *si ){
    return new UniversalBoolean( bool(si->getInt()) );
  }

  static void registerDeserializer(){
    DeserializerManager::instance()->registerDeserializer( getUniversalBooleanType(),
							   &UniversalBoolean::deserialize );
  }

  UniversalBoolean vhdlAnd( const UniversalBoolean & ) const;
  UniversalBoolean vhdlOr( const UniversalBoolean & ) const;
  UniversalBoolean vhdlNand( const UniversalBoolean & ) const;
  UniversalBoolean vhdlNor( const UniversalBoolean & ) const;
  UniversalBoolean vhdlXor( const UniversalBoolean & ) const;
  UniversalBoolean vhdlXnor( const UniversalBoolean & ) const;
  UniversalBoolean vhdlNot() const;
};


inline 
ostream &
operator<<( ostream &os, const UniversalBoolean& b) {
  switch (b.val) {
  case false:
    os << "FALSE";
    break;
  case true:
    os << "TRUE";
    break;
  default:
    os << "(invalid UniversalBoolean type)";
    break;
  }
  return os;
}

#endif
