<?php
/**
 * Copyright 2000 - 2004 by Gero Kohnert and ecosoft
 *
 * @modulegroup rate
 * @module rate_new
 * @package rate
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("rate","new");
 loadmodule("rate");
 loadlayout();

 /**
  * change/modify a rate
  */
 class rate_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"ratenew\" action=\"rate_ins.php\" method=\"POST\">\n";
     echo $this->DataTableStart();
     echo "<tr><th colspan=\"6\">";
     if ( isset ($this->obj->id) && ( $this->obj->id != -1 ) ) {
       echo $lang['RateMod'];
       echo " </th></tr>\n";
       echo "<tr>\n";
       $this->addhidden("id",$this->obj->id);
       echo " <td colspan=\"5\">". sprintf ($lang['ProdCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td align=\"right\">". acl_link($this->obj) ."</td>";
       echo "</tr>\n";
     } else {
       echo $lang['RateCreation'];
       echo " </th></tr>\n";
     }
     echo "<tr>\n";
     echo $this->showfieldc($lang['RateName'],1,"name");
     echo " <td colspan=\"5\"><input id=\"name\" size=\"". min($table['rate']['name'][size],40) ."\" maxlength=\"". $table['rate']['name'][size] ."\" name=\"name\" value=\"". myentities($this->obj->name) ."\"></td>\n";
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfieldc($lang['RateReference'],1);
     echo " <td colspan=\"5\">\n";
     if ($this->obj->id == -1) {
       echo $lang[$this->obj->ref->getType()] ." ". $this->obj->getRefLink() ."\n";
       $this->addhidden("link_id",$this->obj->link_id);
     } else {
       echo "  <select name=\"link_id\">\n";
       foreach ($this->obj->plist as $i => $f) {
         echo "   <option value=\"". $i ."\"". ($i == $this->obj->link_id ? " selected>* ":">") . $lang[$f->getType()] .": ". $f->getFullName() ."</option>\n";
       }
       echo "  </select>\n";
     }
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['RateWorkerReference'],"worker");
     echo " <td valign=\"top\">\n";
     echo "". $this->user->askPeople("worker",$this->obj->worker->id,0) ."\n";
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['RateRole'],1,"role_id");
     echo " <td><select name=\"role_id\">\n";
     @reset($lang['ProdRole']);
     while ( list ($s,$x) = @each ($lang['ProdRole']) ) {
       echo "   <option value=\"". $s ."\"". ($this->obj->role_id == $s ? " selected" : "") .">". $lang['ProdRole'][$s] ."</option>\n";
     }
     echo "</select></td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['Rate'],1,"cph");
     echo " <td colspan=\"1\"><input size=\"10\" maxlength=\"10\" name=\"cph\" value=\"". number_format($this->obj->cph,2,$lang['DecPoint'],$lang['ThousandPoint'])  ."\">\n";
     Currency_Select("currency",$this->obj->currency);
     echo $this->showfieldc($lang['TTState'],1,"state");
     echo " <td><select name=\"state\">\n";
     @reset($lang['TTStates']);
     while ( list ($s,$x) = @each ($lang['TTStates']) ) {
       echo "   <option value=\"". $s ."\"". ($this->obj->state == $s ? " selected" : "") .">". $lang['TTStates'][$s] ."</option>\n";
     }
     echo "</select></td>\n";
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfield($lang['RateVat']);
     echo "<td>\n";
     TAX_select("vat",$this->obj->vat);
     echo "</td>\n";
     echo "</tr>\n";
     
     echo "<tr>\n";
     echo $this->showfieldc($lang['RatePriority']);
     echo " <td colspan=\"1\"><input size=\"10\" maxlength=\"10\" name=\"priority\" value=\"". $this->obj->priority  ."\">\n";
     echo "</tr>\n";
     
     # References to modules
     module_addforms($this->user,$this->obj,6);

     echo "<tr>\n";
     if ( isset($this->obj->id) && ($this->obj->id != -1) ) {
       submit_reset(0,1,2,1,2,0);
     } else {
       submit_reset(0,-1,2,1,2,0);
     }
     echo "</tr>\n";

     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $this->setfocus("ratenew.name");
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang;

     $this->obj = new rate($this->dbconn);
     if ( isset($_GET['id']) ){
       $this->obj->read($_GET['id']);
       $this->name = $lang['RateMod'];
       if ( $this->obj->id < 0 ) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
         $this->stop = true ;
       }
     } else {
       $this->name = $lang['RateCreation'];
     }
     if ( isset($_GET['link_id']) ){
       $this->obj->link_id = $_GET['link_id'];
     }
     if ( isset($_GET['rate']) ){
       $this->obj->rate = StripSlashes($_GET['rate']);
     }
     if ( isset($_GET['name']) ){
       $this->obj->name = StripSlashes($_GET['name']);
     }
     if ( isset($_GET['vat']) ) {
       $this->obj->vat = $_GET['vat'];
     }
     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['worker']) ) {
       $this->obj->worker = $_GET['worker'];
     }
     if ( isset($_GET['role_id']) ) {
       $this->obj->role_id = $_GET['role_id'];
     }
     if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }
     
     $this->obj->read_reference();
     $this->obj->read_relations();

     # menu
     $x = rate::getSelectLink($this->user,$lang['Search']);
     $x[category][] = "obj";
     $this->addmenu($x);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => $this->obj->getDelURL(),
                   text => $lang['Delete'],
                   info => $lang['RateDelete'],
                   confirm => true,
                   category => array("rate","del","obj")
                 );
       $this->addMenu($x);
     }

     add_module_newlinks($this,$this->obj);
   }
 }

 $l = new rate_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info: $Id: rate_new.php,v 1.2.2.1 2004/04/14 17:39:22 tapoueh Exp $
    $Author: tapoueh $
-->