<?php
/* This file allows us at my company to import our LDAP data in the Tutos base.
 * Inspired from scheme.php !
 *
 * $Id: ldap_getdata.php,v 1.1.2.4 2005/03/02 10:29:44 tapoueh Exp $
 * $Author: tapoueh $
 *
 * Attention: this code is dedicated to my compay LDAP organisation
 * I'm not sure this will fit your LDAP structure, but you can use
 * that as an example.
 *
 * Doing this in a generic way is possible, but as i have just one example
 * of LDAP structure and no clue of general LDAP organisation, I just made
 * it work fine here.
 * Feel free to generalize this code if you know how to !
 *
 * !! Remove/Disable this script after running !!
 *
 * @modulegroup ADMIN
 * @module ldap_getdata
 * @package BASE
 */

$tutos['base'] = "../..";
$tutos['base'] = "../..";
ini_set("include_path","..");
include_once 'acl.pinc';
include_once 'webelements.p3';
include_once 'permission.p3';

include_once 'layout/layout.pinc';

check_user();


class ldap_show extends layout {

  function ldap_import($dbconn, $action) {
    global $tutos, $lang, $current_user;

    /* Here we do the job
     * That means we connect to the LDAP server and fetch the data
     */

    $ds = ldap_connect($tutos[ldapauthserver]["host"],
		       $tutos[ldapauthserver]["port"]);

    if( $tutos[ldapauth_anonymous] ) {
      // this is an "anonymous" bind
      $r = ldap_bind($ds);
    } else {
      $r = ldap_bind($ds,
		     $tutos[ldapauthserver]["binddn"],
		     $tutos[ldapauthserver]["passwd"]);
    }

    /* We first fetch the locations of the differents company locations */

    // We do not want the top level node
    $loc_filter = "(!(ou=site))";
    $locdn  = "ou=administratif,ou=site,o=cvf";
    $fields = array("l", "ou", "description", "facsimiletelephonenumber",
		    "postaladdress", "postalcode");

    $sr   = ldap_search($ds, $locdn, $loc_filter, $fields);
    $info = ldap_get_entries($ds, $sr);

    #$this->my_ldap_walk_result($ds, $sr);

    for ($i=0; $i<$info["count"]; $i++) {
      $curloc = $info[$i]["ou"][0];

      // Dealing with our street format
      $street  = utf8_decode($info[$i]["postaladdress"][0]);
      $tmp     = explode("-", $street);
      $street1 = $tmp[0];
      $street2 = $tmp[1];

      $locs[$curloc] =
	 array("lname"  => utf8_decode($info[$i]["description"][0]),
	       "city"   => utf8_decode($info[$i]["l"][0]),
	       "street1"=> $street1,
	       "street2"=> $street2,
	       "fax_1"  => utf8_decode($info[$i]["facsimiletelephonenumber"][0]),
	       "zip"    => utf8_decode($info[$i]["postalcode"][0]),
	       "country"=> "FR"
	       );
    } 

    /* We now fetch the list of dn to consider, $user_filter
     *
     * In our LDAP, we have some elements containing DN list, in order to
     * group LDAP entries in a high-level way.
     * So we are going to establish a list of user DN to consider when
     * importing data, based upon the grouping done in the LDAP.
     */
    $user_filter = "(|";

    // Where we find our groups
    $dn = "ou=administratif,ou=group,o=cvf";
    $fields = array("member");

    // The groups we consider
    $group_filter =
       "(|(cn=direction)".
       "(cn=devprs)(cn=devbdx)(cn=devlil)(cn=devtrs)".
       "(cn=exploitation paris)".
       "(cn=exploitation bordeaux)".
       "(cn=exploitation tours))";

    $sr   = ldap_search($ds, $dn, $group_filter, $fields);
    $info = ldap_get_entries($ds, $sr);

    // $this->my_ldap_walk_result($ds, $sr);

    $nbu = 0;
    for ($i=0; $i<$info["count"]; $i++) {
      for ($j=0; $j<$info[$i]["member"]["count"]; $j++) {
	$nbu++;
	$dn = $info[$i]["member"][$j]; 

	/* In order to use this DN as a LDAP search filter, we have
	 * to transform it. The point is that we already know the basedn
	 * from where we are gonna launch the search.
	 */
	$tmp = explode(",", $dn);
	$user_filter .= "(&(".$tmp[0].")(".$tmp[1]."))";
      }
    }
    $user_filter .= ")";

    // echo "Found ".$nbu." users : <br>\n";
    // $this->debug($user_filter);

    if( $action == "insert" ) {
      // Preparing the insert/update: Company data
      // echo "Cration de la structure";

      // No mails here !!
      $tutos[demo] = 0;

      $cvf = new company($dbconn);
      $cvf->name = "CVF";
      $msg .= $cvf->save();
      // echo $lang[$cvf->getType()].":". $cvf->getFullName() ."<BR>\n";
   
      $dir = new department($dbconn);
      $dir->name = "Direction";
      $dir->company = &$cvf;
      $msg .= $dir->save();
      // echo $lang[$dir->getType()].":". $dir->getFullName() ."<BR>\n";

      $dev = new department($dbconn);
      $dev->name = "Dveloppement";
      $dev->company = &$cvf;
      $msg .= $dev->save();
      // echo $lang[$dev->getType()].":". $dev->getFullName() ."<BR>\n";

      $exp = new department($dbconn);
      $exp->name = "Exploitation";
      $exp->company = &$cvf;
      $msg .= $exp->save();
      // echo $lang[$exp->getType()].":". $exp->getFullName() ."<BR>\n";
    }

    /* Now we create our location objets. */
    $t = array("prs", "bdx", "lil", "trs");

    for($i=0; $i < count($t); $i++) {
      $l = new location($dbconn);

      $l->comapny = &$cvf;
      $l->lname   = $locs[$t[$i]]["lname"];
      $l->desc1   = $locs[$t[$i]]["lname"];
      $l->fax_1   = $locs[$t[$i]]["fax_1"];
      $l->street1 = $locs[$t[$i]]["street1"];
      $l->street2 = $locs[$t[$i]]["street2"];
      $l->city    = $locs[$t[$i]]["city"];
      $l->zip     = $locs[$t[$i]]["zip"];
      $l->country = $locs[$t[$i]]["country"];

      $t_locs[$t[$i]] = $l;
    }

    /* Now we fetch personnal informations */
    $userdn = "ou=administratif,ou=user,o=cvf";
    $fields = array("ou", "uid", "mail", "telephonenumber",
		    "homephone", "sn", "givenname");

    $sr = ldap_search($ds, $userdn, $user_filter, $fields);
    $info = ldap_get_entries($ds, $sr);
    // $this->debug($info);

    /* Now we show/insert/update the LDAP users */

    $users = array();

    for ($i=0; $i<$info["count"]; $i++) {
      $name  = utf8_decode($info[$i]["sn"][0])." ";
      $name .= utf8_decode($info[$i]["givenname"][0]);

      switch( $action ) {
      case "show":
	$users[] = array('uid'   => $info[$i]["uid"][0],
			 'name'  => $name,
			 'lname' => $locs[$info[$i]["ou"][0]]["lname"],
			 'email' => $info[$i]["mail"][0],
			 'phone' => $info[$i]["telephonenumber"][0]);

	break;

      case "insert":
      case "update": {
	/* This time we create tutos objects, then insert/update them
	 * in the tutos data base.
	 *
	 * Note we have to explicilty look for the users in the tutos
	 * database, cause the save choose to update only when it knows
	 * the user id.
	 */
	$user = array();

	$f_name = utf8_decode($info[$i]["givenname"][0]);
	$l_name = utf8_decode($info[$i]["sn"][0]);
	$login  = $info[$i]["uid"][0];

	/* Get the passwd
	 * In my company the passwd&account infos are separated from
	 * the administrative ones, so i need to do one more LDAP request.
	 */
	$pass_sr = ldap_search($ds, "ou=mail,ou=user,o=cvf",
			       "(uid=".$login.")", array("userPassword"));
	$pass_infos = ldap_get_entries($ds, $pass_sr);
	$passwd = $pass_infos[0]["userpassword"][0];

	$a = new tutos_address($dbconn);
	$u = new tutos_user($dbconn);

	// First we create the address
	$qp =
	   "SELECT * FROM  people ".
	   "WHERE ".$dbconn->Like("login", $login);
	$rp = $dbconn->Exec($qp);

	if ( $rp->numrows() == 1 ) {
	  // The user/address exists in the tutos data base
	  $a->read($rp->get(0, "adr_id"));
	  $user['name'] = $a->getFullName();

	  $u->read($a->id, 0);
	  $u->pw = $passwd;

	  $user['login'] = $u->login;
	}
	else {
	  $a->f_name  = $f_name;
	  $a->l_name  = $l_name;
	  $a->creator = &$current_user;
	  $msg .= $a->save();

	  $user['name'] = $a->getFullName();

	  $u->updatepw = 1;
	  $u->login    = $login;
	  $u->pw       = $passwd;
	  $u->id       = $a->id;
	  $msg .= $u->save();

	  $user['login'] = $u->login;
	}

	/* And now, the location stuff */
	$l = $t_locs[$info[$i]["ou"][0]];
	$mail = $info[$i]["mail"][0];

	$ql = "SELECT * FROM ". $l->tablename .
	   " WHERE ".$dbconn->Like("email_1", $mail);
	$rl = $dbconn->Exec($ql);

	if ( $rl->numrows() == 1 ) {
	  $l->read($rl->get(0, "id"));
	}

	// Update the location
	$l->email_1 = $mail;
	$l->phone_1 = $info[$i]["telephonenumber"][0];
	$l->phone_2 = $info[$i]["homephone"][0];
	$l->adr_id  = $a->id;

	$msg .= $l->save();
	$user['lname'] = $l->lname;

	/**
	 * In the case of an LDAP import, the user should not be
	 * allowed to modify its location entry, but should be able to
	 * edit its profile
	 */
	acl_set($a, $u->id, $tutos[useok]);
	acl_set($l, $u->id, $tutos[useok]);
	acl_set($u, $u->id, $tutos[modok]);

	/**
	 * EVERYBODY has to be able to USE those newly created
	 * elements.
	 */
	acl_set($a, EVERYBODY, $tutos[useok]);
	acl_set($u, EVERYBODY, $tutos[useok]);

	// Then save it all
	acl_save($a);	acl_save($l);	acl_save($u);

	$this->debug($user);
	// $users[] =$user;
      }
	break;

      default:
	break;
      }
    }
    $this->assign('users', $users);

    ldap_close($ds);
  }

  function my_ldap_walk_result($ds, $sr) {
    $info = ldap_get_entries($ds, $sr);
    echo $info["count"]." results"."<br>";

    for ($i=0; $i<$info["count"]; $i++) {
      echo "dn: " . $info[$i]["dn"] . "<br>";
    
      for ($ii=0; $ii<$info[$i]["count"]; $ii++) {
	$attrib = $info[$i][$ii];
	echo "&nbsp;&nbsp;" . $attrib . ":";
	echo $info[$i][$attrib][0];
	echo "<br>";
      }
    }
  }

  function navigate() {
    global $tutos, $lang, $current_user;

    $x = array('url'   => "admin/ldap_getdata.php?action=show",
	       'text'  => "View data",
	       'image' => 'search',
	       'category' => array("ldap")
	       );
    $this->addMenu($x);

    $x = array('url'   => "admin/ldap_getdata.php?action=insert",
	       'text'  => "Insert data",
	       'image' => 'new',
	       'category' => array("ldap")
	       );
    $this->addMenu($x);

    $x = array('url'   => "admin/ldap_getdata.php?action=update",
	       'text'  => "Update data",
	       'image' => 'modify',
	       'category' => array("ldap")
	       );
    $this->addMenu($x);

    $this->menuprint('ldap');
  }

  function info() {
    global $dbconn, $step, $action;
    global $tutos, $lang, $current_user;

    $this->assign('title', $lang['AdminDBInfo']);

    $this->assign('dbtype',
		  array('label' => $lang['AdminDBInfo'],
			'value' => $dbconn->GetType() ." ". $dbconn->openfunc)
		  );

    $this->assign('dbname',
		  array('label' => $lang['AdminDBName'],
			'value' => $dbconn->db->name));

    $this->assign('dbuser',
		  array('label' => $lang['AdminDBUser'],
			'value' => $dbconn->db->user));

    $this->assign('dbhost',
		  array('label' => $lang['AdminDBHost'],
			'value' => $dbconn->db->host));

    $this->assign('dbport',
		  array('label' => $lang['AdminDBPort'],
			'value' => $dbconn->db->port));

    $use   = ( $tutos[ldapauth] ? "in use" : "not in use" );
    $crypt = ( $tutos[ldapauth_pw_enc] ? "in use" : "not in use" );
    $anon  = ( $tutos[ldapauth_anonymous] ? "anonymous" : "binddn" );

    $this->assign('ldapInfos', 'LDAP Infos');

    $this->assign('ldapconf',
		  array('label'  => 'LDAP Config',
			'use'    => $use,
			'crypt'  => $crypt,
			'anon'   => $anon,
			'basedn' => $tutos[ldapauthserver]['basedn']));

    $this->assign('basedn',
		  array('label' => "Base DN",
			'value' => $tutos[ldapauthserver]['basedn']));

    if( $tutos[ldapauth_anonymous] )
      $binddn = 'Anonymous';
    else
      $binddn = $tutos[ldapauthserver]['binddn'];

    $this->assign('binddn',
		  array('label' => "Bind DN",
			'value' => $binddn));

    $this->assign('ldap_host',
		  array('label' => $lang['AdminDBHost'],
			'value' => $tutos[ldapauthserver]['host']));

    $this->assign('ldap_port',
		  array('label' => $lang['AdminDBPort'],
			'value' => $tutos[ldapauthserver]['port']));

    $this->ldap_import($dbconn, $action);
    $this->template('admin/ldap_getdata');
  }

  function prepare() {
    global $tutos, $lang, $action;

    $action = 'show';
    if( isset($_GET['action']) && $_GET['action'] != "")
      $action = $_GET['action'];

    $this->assign('action', $action);
  }
}

if ( ! isset($step) ) {
  $step = 0;
}

$l = new ldap_show($current_user);
$l->display();
$dbconn->Close();

?>
