<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup task
 * @module task_del
 * @package task
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'task.pinc';
 include_once 'bug.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("task","del");

 $gotourl="task_overview.php";
 $msg = "";

 $t = new task($dbconn);

 if ( !isset($_GET['id']) ) {
   $msg .= sprintf($lang['Err0040'],$lang[$t->getType()]);
 } else {
   $t->read($_GET['id']);
   $gotourl = $t->getUrl();
 }
 if ( ! $t->del_ok() ) {
   $msg .= sprintf($lang['Err0023'],$lang[$t->getType()]);
 }
 if ($msg == "") {
   $gotourl = $t->parent->getUrl();

   $dbconn->Begin("WORK");
   $msg .= $t->delete();
   $dbconn->Commit("WORK");
 }
 $_SESSION['MSGID'.$t->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $t->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: task_del.php,v 1.17.2.1 2003/07/24 09:05:08 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
