<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup location
 * @module location_ins
 * @package address
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("address","ins");

 $msg = "";

 $l = new location($dbconn);
 # READ the data
 if ( isset($_POST['loc_id']) && ($_POST['loc_id']) != -1 ) {
   $l->read($_POST['loc_id']);
   if ( $l->id == -1 ) {
     $msg .= "Unknown ID";
   }
 }
 # Parent Object
 $p = getObject($dbconn,$_POST['id']);
 if ( $p == -1 ) {
   $msg .= "Missing Parent ID";
   $gotourl = $_SERVER['HTTP_REFERR'];
 } else if ( $p->getType() == "address" ) {
   $gotourl = "address_new.php";
 } else if ( $p->getType() == "company" ) {
   $gotourl = "company_new.php";
 } else if ( $p->getType() == "department" ) {
   $gotourl = "department_new.php";
 }
 $l->adr_id = $p->id;


 if ( !isset($_POST['category']) || empty($_POST['category']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['AdrCategory']) ."<br>";
 } else {
   $category = $_POST['category'];
   $gotourl= addUrlParameter($gotourl,"category=". $category);
   $l->setCategory($category);
 }

 if ( !isset($_POST['lname']) ||  empty($_POST['lname']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['AdrDescription']) ."<br>";
 } else {
   $lname = StripSlashes($_POST['lname']);
   $gotourl= addUrlParameter($gotourl,"lname=". UrlEncode(StripSlashes($lname)));
   $l->setLname($lname);
 }

 # Check Company
 if ( !isset($_POST['c_id']) ) {
   $l->company = check_field(StripSlashes($_POST['company']),"company","cl","c");
 } else {
   if ( $_POST['c_id'] != -1 ) {
     $l->company->read($_POST['c_id']);
   }
 }
 # Check Department
 if ( !isset($_POST['d_id']) ) {
   $l->department = check_field(StripSlashes($_POST['department']),"department","dl","d");
 } else {
   if ( $_POST['d_id'] != -1 ) {
     $l->department->read($_POST['d_id']);
   }
 }
 if ( is_object($l->department) ) {
   $l->company = &$l->department->company;
 }

 foreach($l->larray as $i => $f) {
   if ( isset($_POST[$f]) ) {
     $l->setField($f,StripSlashes($_POST[$f]));
     $gotourl= addUrlParameter($gotourl,$f ."=". UrlEncode($l->$f));
   }
   $i++;
 }
 #
 # Email Verification was fetched from http://www.phpbuilder.com/snippet/detail.php?type=snippet&id=107
 #
 $regex = '^([._a-z0-9-]+[._a-z0-9-]*)@(([a-z0-9-]+\.)*([a-z0-9-]+)(\.[a-z]{2,4}))$';
 if ( isset($_POST['email_1']) ) {
   $email_1 = trim(StripSlashes($_POST['email_1']));
   if ( ($email_1 != "") && !eregi($regex,$email_1)) {
     $msg .= sprintf($lang['Err0043'],$email_1);
   }
 }
 if ( isset($_POST['email_2']) ) {
   $email_2 = trim(StripSlashes($_POST['email_2']));
   if ( ($email_2 != "") && ! eregi($regex,$email_2)) {
     $msg .= sprintf($lang['Err0043'],$email_2);
   }
 }
 if ( isset($_POST['cploc']) && ($_POST['cploc'] == 1) ) {
   # Copy the location data from the companies location if possible
   $gotourl= addUrlParameter($gotourl,"cploc=1");
   if ( isset ($l->company->id) ) {
     $l->company->read_locs_data();
     if ( count($l->company->location) > 0 ) {
       reset ($l->company->location);
       $x = current($l->company->location);
       $l->city = $x->city;
       $l->state = $x->state;
       $l->country = $x->country;
       $l->zip = $x->zip;
       $l->street1 = $x->street1;
       $l->street2 = $x->street2;
     }
   }
 }
 if ( $msg == "" ) {
   $l->read_ref();
   $dbconn->Begin("WORK");
   $l->save();
   $dbconn->Commit("WORK");
   if ( $p->getType() == "address" ) {
     $gotourl = "address_new.php";
   } else if ( $p->getType() == "company" ) {
     $gotourl = "company_new.php";
   } else if ( $p->getType() == "department" ) {
     $gotourl = "department_new.php";
   }
 }
 # The reference
 $gotourl= addUrlParameter($gotourl,"id=". $l->adr_id);
 $gotourl= addUrlParameter($gotourl,"loc_id=". $l->id);

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: location_ins.php,v 1.31.2.3 2003/08/13 04:28:20 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
