<?php
/**
 * Copyright 2001 - 2002 by Gero Kohnert
 *
 * @modulegroup ADMIN
 * @module admin_show
 * @package BASE
 */
 include 'webelements.p3';
 include 'permission.p3';
 require_once 'db/table.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("admin","show");
 loadlayout();

 /* ---------------------------------------------------------------------------
  *
  */
 Function getTableCount($tbl,&$dbconn) {
   $q = "SELECT count(*) as c from ". $dbconn->prefix . $tbl;
   $r = $dbconn->exec($q);
   if ( 1 != $r->numrows()) {
     return -1;
   }
   $cnt = $r->get(0, "c");
   $r->free();
   return $cnt;
 }
 /* ---------------------------------------------------------------------------
  *
  */
 Function getinfo() {
   global $table, $dbconn;

   ksort($table);
   @reset($table);
   while ( list ($i,$f) = @each ($table) ) {
     $table[$i]['count'] = 0;
     $table[$i]['count'] = getTableCount($f[name],$dbconn);
   }
 }


 /**
  * display a admin page
  */
 class admin_show extends layout {
   /**
    *
    */
   Function info() {
     global $lang,$tutos,$table;

     $table = array();
     @require("db/table.pinc");

     $link2 = "admin_show.php";
     if ( ! $this->user->isAdmin() ) {
       echo $this->error("Only admins are allowed to see this");
       if ( $tutos[demo] == 1 ) {
         echo $this->error("exceptionally enabled for this demo");
       } else {
         return;
       }
     }

     $url['acl'] = "acl_overview.php";
     $url['teams'] = "team_overview.php";
     $url['bugs'] = "bug_overview.php";
     $url['addresses'] = "address_overview.php";
     $url['products'] = "product_overview.php";
     $url['timetrack'] = "timetrack_select.php";
     $url['calendar'] = "app_select.php";
     $url['companies'] = "company_overview.php";
     $url['tutos_dbs'] = "database_overview.php";
     $url['history'] = "history_show.php";
     $url['messages'] = "message_overview.php";
     $url['people'] = "user_overview.php";

     getinfo();
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"6\">". $lang['AdminDBInfo'] ." : ". $this->dbconn->db->alias ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBName']);
     echo $this->showdata($this->dbconn->db->getLink($this->dbconn->db->name),2);
     echo $this->showfield($lang['AdminDBUser']);
     echo $this->showdata($this->dbconn->db->user,2);
     echo "</tr>\n";

     echo "<tr>\n";
     if ( $this->dbconn->gettype() == "Oracle" ) {
       echo $this->showfield($lang['AdminDBHome']);
       echo $this->showdata($this->dbconn->db->home,5);
     } else {
       echo $this->showfield($lang['AdminDBHost']);
       echo $this->showdata($this->dbconn->db->host,2);
       if ( $this->dbconn->gettype() == "Postgres" ) {
         echo $this->showfield($lang['AdminDBPort']);
         echo $this->showdata($this->dbconn->db->port,2);
       } else {
         echo " <td colspan=\"3\">&nbsp;</td>\n";
	   }
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['AdminDBInfo']);
     echo $this->showdata($this->dbconn->moreinfo(),6);
     echo "</tr>\n";

     echo "<tr>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>". $lang['AdminDBCount'] ."</th>\n";
     echo "</tr>\n";
     @ksort($table);
     $c = 0;
     foreach ($table as $i => $f) {
       if ( $c == 0 ) {
         echo "<tr>\n";
       }
       if ( isset($url[$f[name]]) ) {
         echo " <td align=\"right\">". $this->dbconn->prefix . makelink($url[$f[name]],$f[name],$f[Desc]) ."</td>";
       } else {
         echo " <td align=\"right\">". $this->dbconn->prefix . $f[name] ."</td>";
       }
       echo " <td align=\"right\">". $f['count'] ."</td>";
       if ( $c == 2 ) {
         echo "</tr>\n";
         $c = 0;
       } else {
         $c++;
       }
     }
     if ($c != 0) {
       echo " <td colspan=\"". (3 - $c) * 2 ."\">&nbsp;</td></tr>\n";
     }

     echo "<tr>\n";
     echo " <th colspan=\"4\">Known Modules</th>\n";
     echo " <th>". $lang['AdminDBTable'] ."</th>\n";
     echo " <th>" .$lang['AdminDBCount'] ."</th>\n";
     echo "</tr>\n";
     $line = 0;
     foreach ($tutos[modules] as $i => $f) {
       echo $this->OverviewRowStart($line);
       $table = array();
       include("../".dirname($tutos[modules][$i][file]) ."/mtable.pinc");
       echo " <td valign=\"top\" align=\"left\">";
       if ($tutos[$f['perm']] == 0) {
         echo "<strike>\n";
       }
       if ( isset ($f['overview']) ) {
         echo makelink($f['overview'],$f[name]) ."</td>\n";
       } else {
         echo $f[name];
       }
       if ($tutos[$f['perm']] == 0) {
         echo "</strike>\n";
       }
       echo "</td>\n";
       echo " <td valign=\"top\" colspan=\"2\" align=\"left\">". $f[Desc] ."</td>\n";
       echo " <td valign=\"top\" align=\"left\">". $f[file] ."</td>\n";
       echo " <td align=\"right\">&nbsp;";
       @reset($table);
       $pre = "";
       while ( list ($i2,$f2) = @each ($table) ) {
         echo $pre. $this->dbconn->prefix . $f2[name];
         $pre = "<br>\n";
       }
       echo "</td>\n";
       echo " <td align=\"right\">&nbsp;";
       @reset($table);
       $pre = "";
       while ( list ($i2,$f2) = @each ($table) ) {
         echo $pre . getTableCount($f2[name],$this->dbconn);
         $pre = "<br>\n";
       }
       echo "</td>\n";
       echo $this->OverviewRowEnd($line++);
     }

     echo "<tr>\n";
     echo " <th colspan=\"6\">". menulink("user_overview.php",$lang['AdminLoginInfo'],$lang['AdminLoginInfo']) ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo $this->orderHeader("", $lang['AdrName'],$link2,1);
     echo $this->orderHeader("login", $lang['User'],$link2);
     echo $this->orderHeader("last_seen", $lang['UserLastSeen'],$link2,2);
     echo $this->orderHeader("last_host", $lang['UserLastHost'],$link2);
     echo $this->orderHeader("disabled", $lang['UserDisabled'],$link2);
     echo "</tr>\n";

     $result = $this->dbconn->Exec($this->q);
     $n = $result->numrows();
     $a = 0;
     $line = 1;
     while ( ($a < $n) && ( $a < $tutos[maxshow])) {
       echo $this->OverviewRowStart($line);
       $adr = new tutos_user($this->dbconn);
       $uid = $result->get($a, "id");
       $adr->read($uid,1);
       echo " <td colspan=\"1\">". $adr->getLink() ."</td>";
       echo " <td align=\"right\">". makelink("user_new.php?uid=".$uid ,$result->get($a, "login")) ."</td>";
       $ls = $result->getDateTime($a, "last_seen");
       echo " <td colspan=\"2\">". $ls->getLinkDateTime() ."</td>";
       echo " <td>&nbsp;". $result->get($a, "last_host") ."</td>";
       echo " <td align=\"center\">". ($adr->disabled == 0 ? $lang['no']:$lang['yes']) ."</td>";
       echo $this->OverviewRowEnd($line++);
       unset($adr);
       $a++;
     }
     $result->free();
     echo $this->DataTableEnd();
   }
   /**
    * navigation
    */
   Function navigate() {
     global $lang,$tutos;

     echo "<tr><td>\n";
     echo menulink("acl_overview.php",$lang['ACLOverview'],$lang['ACLOverviewI']) ."<br>\n";
	 if ($tutos[usesync] == 1) {
       echo menulink("admin_sync.php",$lang['AdminDBSync'],$lang['AdminDBSync']) ."<br>\n";
	 }
     echo "</td></tr>\n";
   }
   /**
    * preparation
    */
   Function prepare() {
     global $lang;
     $this->name = $lang['AdminShow'];
     $this->q = "SELECT * from ". $this->dbconn->prefix ."people WHERE last_seen is not null";
     # sorting
     $xxx = "";
     order_parse($this->q,$xxx,$xxx,$xxx,"last_seen DESC");
   }
 }

 $l = new admin_show($current_user);
 $l->display();
 $dbconn->close();
?>
<!--
    CVS Info:  $Id: admin_show.php,v 1.52.2.1 2003/06/27 14:02:48 gokohnert Exp $
    $Author: gokohnert $
-->
