# $Id: jidlink.tcl,v 1.2 2004/07/10 20:05:03 aleksey Exp $

###############################################################################
# File transfer via Jidlink

namespace eval ftjl {
    set winid 0
    set id 0
    set chunk_size 4096
    
    variable options

    custom::defgroup Jidlink \
	[::msgcat::mc "Jidlink options."] \
	-group FileTransfer

    custom::defvar options(enable) 0 \
	[::msgcat::mc "Enable Jidlink transport for outgoing file transfers (it is obsolete)."] \
	-group Jidlink -type boolean
}

hook::add create_filetransfer_menu_hook \
    [namespace current]::ftjl::add_menu_item 30

proc ftjl::add_menu_item {m cascad jid args} {
    variable options

    if {!$options(enable)} return

    if {$cascad} {
	set label [::msgcat::mc "via Jidlink..."]
    } else {
	set label [::msgcat::mc "Send file via Jidlink..."] \
    }
    $m add command -label $label \
        -command [list eval [list [namespace current]::send_file_dialog $jid] $args]

    hook::unset_flag create_filetransfer_menu_hook transport
}

proc ftjl::send_file_dialog {user args} {
    variable winid

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }

    while {[winfo exists .sfd$winid]} {
	incr winid
    }
    set w .sfd$winid

    variable filename$winid

    Dialog $w -title [format [::msgcat::mc "Send file to %s"] $user] \
	-separator 1 -anchor e -modal none \
	-default 0 -cancel 1

    set f [$w getframe]

    label $f.lfile -text [::msgcat::mc "File to send:"]
    entry $f.file -textvariable [list [namespace current]::filename$winid]
    button $f.browsefile -text [::msgcat::mc "Browse..."] \
	-command [list [namespace current]::set_send_file_name $winid]

    label $f.ldesc -text [::msgcat::mc "Description:"]
    text $f.desc -width 50 -height 5

    ProgressBar $f.pb -variable [namespace current]::progress$f.pb
    variable progress$f.pb 0

    grid $f.lfile      -row 0 -column 0 -sticky e
    grid $f.file       -row 0 -column 1 -sticky ew
    grid $f.browsefile -row 0 -column 2 -sticky ew
    
    grid $f.ldesc -row 1 -column 0 -sticky en
    grid $f.desc  -row 1 -column 1 -sticky ewns -columnspan 2 -pady 1m

    grid $f.pb -row 2 -column 0 -sticky ew -columnspan 3 -pady 2m

    grid columnconfigure $f 1 -weight 1
    grid rowconfigure $f 1 -weight 1

    $w add -text [::msgcat::mc "Send"] \
	-command [list [namespace current]::send_file_start $winid $f \
		       $user -connection $connid]
    $w add -text [::msgcat::mc "Cancel"] -command [list destroy $w]

    incr winid
    $w draw $f.file
}

proc ftjl::set_send_file_name {winid} {
    variable filename$winid

    set file [tk_getOpenFile]
    if {$file != ""} {
	set filename$winid $file
    }
}

proc ftjl::send_file_start {winid f user args} {

    .sfd$winid itemconfigure 0 -state disabled

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }

    set filename [$f.file get]
    set desc [$f.desc get 0.0 "end -1c"]

    if {![file isfile $filename]} {
	MessageDlg .filenofound$winid -aspect 50000 -icon error \
	    -message [format [::msgcat::mc \
				  "File not found or not regular file: %s"] \
			  $filename] \
	    -type user \
	    -buttons ok -default 0 -cancel 0
	.sfd$winid itemconfigure 0 -state normal
	return
    }

    set fsize [file size $filename]
    $f.pb configure -maximum $fsize

    debugmsg filetransfer "SENDFILE: $filename; $desc"

    send_file_offer $winid $user $filename $desc -connection $connid
    #bind .sfd$winid <Destroy> [list [namespace current]::send_file_cancel $winid $servsock]
}

proc ftjl::send_file_offer {winid user filename desc args} {
    variable id
    variable files

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route $user]
    }

    incr id
    set name [file tail $filename]
    set size [file size $filename]

    set files(filename,$id) $filename
    set files(w,$id) .sfd$winid

    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars {xmlns jabber:iq:filexfer} \
	     -subtags [list [jlib::wrapper:createtag file \
				 -vars [list id $id \
					    name $name \
					    size $size] \
				 -chdata $desc]]] \
	-to $user \
	-command [list [namespace current]::send_file_offer_reply $winid] \
	-connection $connid
}

proc ftjl::send_file_offer_reply {winid res child} {

    if {[cequal $res OK]} return
    if {![winfo exists .sfd$winid]} return

    bind .sfd$winid <Destroy> {}
    destroy .sfd$winid
    after idle \
	[list MessageDlg .auth_err -aspect 50000 -icon error \
	      -message [format [::msgcat::mc "Send file request failed: %s"] \
			    [error_to_string $child]] -type user \
	      -buttons ok -default 0 -cancel 0]
}

proc ftjl::send_file_request {connid from id offset} {
    variable files

    if {[info exists files(filename,$id)]} {
	set key [random 1000000000]
	set res \
	    [jlib::wrapper:createtag query \
		 -vars {xmlns jabber:iq:filexfer} \
		 -subtags [list \
			       [jlib::wrapper:createtag file \
				    -vars [list id $id] \
				    -subtags [list [jlib::wrapper:createtag \
							key \
							-chdata $key]]]]]
	after idle [list [namespace current]::send_file_setup_connection \
			$connid $from $id $offset $key]
	return [list result $res]
    } else {
	return [list error cancel not-allowed -text "Invalid file id"]
    }
}

proc ftjl::send_file_setup_connection {connid user id offset key} {
    variable files
    variable chunk_size

    set res [jidlink::connect $connid $user $key]

    set w $files(w,$id)

    if {$res == 0} {
	catch {
	    bind $w <Destroy> {}
	    destroy $w
	}
	# TODO: error message
	return
    }

    if {![winfo exists $w]} {
	jidlink::close $key
	return
    }

    bind $w <Destroy> [list [namespace current]::send_file_close $key]

    set filename $files(filename,$id)
    set fd [open $filename]
    fconfigure $fd -translation binary

    set files(rfd,$key) $fd

    set pb [$files(w,$id) getframe].pb
    variable progress$pb
    $pb configure -maximum [file size $filename]

    #set chunk [read $fd]
    set_status [::msgcat::mc "Transferring..."]

    set chunk [read $fd $chunk_size]
    catch {
	while {$chunk != "" && [winfo exists $w]} {
	    jidlink::send_data $key $chunk
	    update idletasks
	    set progress$pb [tell $fd]
	    debugmsg filetransfer [set progress$pb]
	    after 1000
	    set chunk [read $fd $chunk_size]
	}
    }

    catch { close $fd }
    catch { destroy $w }

    jidlink::close $key
}

proc ftjl::send_file_close {key} {
    variable files

    catch { close $files(rfd,$key) }
    #set w $files(w,$id)
    #jidlink::close $key
    #destroy $w
}

###############################################################################

proc ftjl::recv_file_dialog {connid from id name size date hash desc} {
    variable winid
    variable files
    variable result

    set w .rfd$winid

    while {[winfo exists $w]} {
	incr winid
	set w .rfd$winid
    }

    Dialog $w -title [format [::msgcat::mc "Receive file from %s"] $from] \
	-separator 1 -anchor e \
	-modal none -default 0 -cancel 1


    set f [$w getframe]

    label $f.lname -text [::msgcat::mc "Name:"]
    label $f.name -text $name

    label $f.lsize -text [::msgcat::mc "Size:"]
    label $f.size -text $size

    label $f.ldesc -text [::msgcat::mc "Description:"]
    message $f.desc -width 10c -text $desc

    set dir $ft::options(download_dir)
    label $f.lsaveas -text [::msgcat::mc "Save as:"]
    entry $f.saveas -textvariable [namespace current]::saveas$winid
    variable saveas$winid [file join $dir $name]
    button $f.browsefile -text [::msgcat::mc "Browse..."] \
	-command [list [namespace current]::set_receive_file_name $winid $dir $name]

    set pbvar [namespace current]::progress$f.pb
    ProgressBar $f.pb -variable $pbvar
    $f.pb configure -maximum $size
    set $pbvar 0

    grid $f.lname   -row 0 -column 0 -sticky e
    grid $f.name    -row 0 -column 1 -sticky w
    
    grid $f.lsize   -row 1 -column 0 -sticky e
    grid $f.size    -row 1 -column 1 -sticky w
    
    grid $f.ldesc   -row 2 -column 0 -sticky en
    grid $f.desc    -row 2 -column 1 -sticky ewns -columnspan 2 -pady 1m

    grid $f.lsaveas -row 3 -column 0 -sticky e
    grid $f.saveas  -row 3 -column 1 -sticky ew
    grid $f.browsefile  -row 3 -column 2 -sticky ew

    grid $f.pb      -row 4 -column 0 -sticky ew -columnspan 3 -pady 2m

    grid columnconfigure $f 1 -weight 1 -minsize 8c
    grid rowconfigure $f 2 -weight 1
    
    $w add -text [::msgcat::mc "Receive"] -command \
	[list [namespace current]::recv_file_start $winid $size $pbvar $connid $from $id]
    $w add -text [::msgcat::mc "Cancel"] -command \
	[list [namespace current]::recv_file_cancel $winid]
    bind .rfd$winid <Destroy> \
            [list [namespace current]::recv_file_failed $winid]

    $w draw
    vwait [namespace current]::result($winid)
    set res $result($winid)
    unset result($winid)
    incr winid
    return $res
}

proc ftjl::set_receive_file_name {winid dir fname} {
    variable saveas$winid

    set file [tk_getSaveFile -initialdir $dir -initialfile $fname]
    if {$file != ""} {
	set saveas$winid $file
    }
}

proc ftjl::recv_file_start {winid size pbvar connid user id} {
    variable saveas$winid
    variable files

    set filename [set saveas$winid]

    .rfd$winid itemconfigure 0 -state disabled
    set $pbvar 0

    #set files(filename,$key) $filename

    jlib::send_iq set \
	[jlib::wrapper:createtag query \
	     -vars {xmlns jabber:iq:filexfer} \
	     -subtags [list [jlib::wrapper:createtag file \
				 -vars [list id $id]]]] \
	-to $user \
	-command [list [namespace current]::recv_file_reply \
		       $winid $size $pbvar $user $id $filename] \
	-connection $connid
}

proc ftjl::recv_file_reply {winid size pbvar user id filename res child} {
    variable files

    if {$res != "OK"} {
	recv_file_failed $winid
	after idle \
	    [list MessageDlg .auth_err -aspect 50000 -icon error \
		  -message [format [::msgcat::mc "Receiving file failed: %s"] \
			        [error_to_string $child]] -type user \
		  -buttons ok -default 0 -cancel 0]
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {$tag == "query"} {
	foreach item $children {
	    jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	    if {$tag1 == "file"} {
		foreach item1 $children1 {
		    jlib::wrapper:splitxml $item1 tag2 vars2 isempty2 \
			chdata2 children2
		    if {$tag2 == "key"} {
			set key $chdata2
			set files(filename,$key) $filename
			debugmsg filetransfer "RECV KEY: $key"

			set fd [open $filename w]
			fconfigure $fd -translation binary

			set files(fd,$key) $fd

			jidlink::set_readable_handler \
			    $key [list [namespace current]::recv_file_chunk $pbvar]
			jidlink::set_closed_handler \
			    $key [list [namespace current]::recv_file_finish $winid $size]
		    }
		}
	    }
	}
    }
}

proc ftjl::recv_file_chunk {pbvar key} {
    variable files

    if {[info exists files(filename,$key)]} {
	set data [jidlink::read_data $key]

	debugmsg filetransfer \
	    "RECV into $files(filename,$key) data length [string length $data]"

	puts -nonewline $files(fd,$key) $data

	incr $pbvar [string length $data]
	debugmsg filetransfer [set $pbvar]
    }

}

proc ftjl::recv_file_failed {winid} {
    variable result

    bind .rfd$winid <Destroy> {}
    set result($winid) \
	{error modify undefined-condition -text "File Transfer Failed"}
}

proc ftjl::recv_file_finish {winid size key} {
    variable files
    variable result

    if {[info exists files(filename,$key)]} {
	debugmsg filetransfer CLOSE
	catch { close $files(fd,$key) }
	set fsize [file size $files(filename,$key)]
	unset files(filename,$key)
	set_status [::msgcat::mc "Connection closed"]
    }
    if {[winfo exists .rfd$winid]} {
	bind .rfd$winid <Destroy> {}
	destroy .rfd$winid
	
	if {$fsize != $size} {
	    if {$fsize < $size} {
		set msg "Transfer interrupted (File size is too small)"
	    } else {
		set msg "File size is too large"
	    }
	    after idle \
		[list MessageDlg .auth_err -aspect 50000 -icon error \
		      -message [format [::msgcat::mc "Receiving file failed: %s"] \
				    $msg] \
		      -type user \
		      -buttons ok -default 0 -cancel 0]
	}
    }
    set result($winid) {result {}}
}

proc ftjl::recv_file_cancel {winid} {
    variable result

    catch {
	bind .rfd$winid <Destroy> {}
	destroy .rfd$winid
    }
    set result($winid) \
	{error cancel not-allowed -text "File Transfer Refused"}
}

proc ftjl::iq_set_handler {connid from child} {
    debugmsg filetransfer "FTJL set: [list $from $child]"

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {$tag == "query"} {
	foreach item $children {
	    jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	    if {$tag1 == "file"} {
		if {[jlib::wrapper:getattr $vars1 name] != ""} {
		    return [recv_file_dialog $connid $from \
			[jlib::wrapper:getattr $vars1 id] \
			[jlib::wrapper:getattr $vars1 name] \
			[jlib::wrapper:getattr $vars1 size] \
			[jlib::wrapper:getattr $vars1 date] \
			[jlib::wrapper:getattr $vars1 hash] \
			$chdata1]
		} else {
		    return [send_file_request $connid $from \
				[jlib::wrapper:getattr $vars1 id] \
				[jlib::wrapper:getattr $vars1 offset]]
		}
	    }
	}
    } else {
	return {error modify bad-request}
    }
}

iq::register_handler set query jabber:iq:filexfer \
    [namespace current]::ftjl::iq_set_handler

