# $Id: me_command.tcl,v 1.5 2004/04/07 20:13:50 aleksey Exp $

proc handle_me {chatid from type body x} {
    if {[cequal [crange $body 0 3] "/me "]} {
	if {[chat::is_our_jid $chatid $from]} {
	    set tag me
	} else {
	    set tag they
	}

	set chatw [chat::chat_win $chatid]
	set nick [chat::get_nick $from $type]
	set cw [chat::winid $chatid]

	$chatw mark set MSGLEFT "end - 1 char"
	$chatw mark gravity MSGLEFT left

	$chatw insert end "* $nick " $tag

	chat::add_emoteiconed_text $chatw [crange $body 4 end] $tag
	if {$type == "chat"} {
	    tab_set_updated $cw 1 mesg_to_user
	} else {
	    tab_set_updated $cw 1 message
	}

        $chatw tag add NICK-$nick MSGLEFT "end - 1 char"

	return stop
    }
}
hook::add draw_message_hook [namespace current]::handle_me 50

proc me_command_comp {chatid compsvar wordstart line} {
    upvar 0 $compsvar comps

    if {!$wordstart} {
	lappend comps {/me }
    }
}

hook::add generate_completions_hook [namespace current]::me_command_comp

