# $Id: info_commands.tcl,v 1.9 2004/06/14 21:11:20 aleksey Exp $

namespace eval chatinfo {

    set vcard_defs [list fn \
			 family \
			 name \
			 middle \
			 prefix \
			 suffix \
			 nickname \
			 email \
			 url \
			 jabberid \
			 uid \
			 address \
			 city \
			 state \
			 country]

    set vcard_names [list [::msgcat::mc "Full Name"] \
			  [::msgcat::mc "Family Name"] \
			  [::msgcat::mc "Name"] \
			  [::msgcat::mc "Middle Name"] \
			  [::msgcat::mc "Prefix"] \
			  [::msgcat::mc "Suffix"] \
			  [::msgcat::mc "Nickname"] \
			  [::msgcat::mc "E-mail"] \
			  [::msgcat::mc "Web Site"] \
			  [::msgcat::mc "JID"] \
			  [::msgcat::mc "UID"] \
			  [::msgcat::mc "Address"] \
			  [::msgcat::mc "City"] \
			  [string trim [::msgcat::mc "State "]] \
			  [::msgcat::mc "Country"]]

    custom::defvar options(vcard_items) {0 6 7 8 9 12} \
                [::msgcat::mc "vCard items to display in chat windows when using /vcard command."] \
		        -type list -group Chat \
			-values  $vcard_names
}


proc chatinfo::handle_info_commands {chatid user body type} {

    if {[string equal -length 6 $body "/time "] || [cequal $body "/time"]} {
	set name [crange $body 6 end]
	set command time
    } elseif {[string equal -length 6 $body "/last "] || [cequal $body "/last"]} {
	set name [crange $body 6 end]
	set command last
    } elseif {[string equal -length 7 $body "/vcard "] || [cequal $body "/vcard"]} {
	set name [crange $body 7 end]
	set command vcard
    } elseif {[string equal -length 9 $body "/version "] || [cequal $body "/version"]} {
	set name [crange $body 9 end]
	set command version
    } else {
	return
    }

    set connid [chat::get_connid $chatid]
    set jids {}
    set vcard_jids {}
    if {[cequal $name ""]} {
	set jids [list [chat::get_jid $chatid]]
    } elseif {[cequal $type groupchat]} {
	set jids [list "[chat::get_jid $chatid]/$name"]
    }
    if {[cequal $jids {}]} {
	lassign [roster_lookup $connid $name] jids vcard_jids
	if {[cequal $jids {}]} {
	    set jids [list $name]
	}
    }
    if {[cequal $vcard_jids {}]} {
	set vcard_jids $jids
    }

    if {[cequal $command vcard]} {
	foreach jid $vcard_jids {
	    request_vcard $connid $chatid $jid
	}
    } else {
	foreach jid $jids {
	    request_iq $command $connid $chatid $jid
	}
    }
    return stop
}

hook::add chat_send_message_hook \
    [namespace current]::chatinfo::handle_info_commands 15


proc chatinfo::roster_lookup {connid name} {
    set ret {}
    set ret1 {}
    foreach i [array names ::roster::roster name,$connid,*] {
	if {[cequal $::roster::roster($i) $name]} {
	    set bare_jid [join [lrange [split $i ","] 2 end] ","]
	    set full_jids [::get_jids_of_user $connid $bare_jid]
	    if {![cequal $full_jids {}]} {
		set ret [concat $ret $full_jids]
	    } else {
		lappend ret $bare_jid
	    }
	    lappend ret1 $bare_jid
	}
    }
    return [list $ret $ret1]
}


proc chatinfo::info_commands_comps {chatid compsvar wordstart line} {
    upvar 0 $compsvar comps
    
    if {!$wordstart} {
	lappend comps {/time } {/last } {/vcard } {/version }
    }
}

hook::add generate_completions_hook \
    [namespace current]::chatinfo::info_commands_comps


proc chatinfo::request_iq {type connid chatid jid} {
    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	    -vars [list xmlns jabber:iq:$type]] \
	-to [get_jid_of_user $connid $jid] \
	-connection $connid \
	-command [list [namespace current]::parse_info_iq$type $chatid $jid]
}


proc chatinfo::request_vcard {connid chatid jid} {
    jlib::send_iq get \
	[jlib::wrapper:createtag vCard \
	    -vars [list xmlns vcard-temp]] \
	-to [get_jid_of_user $connid $jid] \
	-connection $connid \
	-command [list [namespace current]::parse_info_vcard $chatid $jid]
}


proc chatinfo::whois {chatid jid} {
    set connid [chat::get_connid $chatid]
    set real_jid [muc::get_real_jid $connid $jid]
    if {$real_jid != ""} {
	return " ($real_jid)"
    } else {
	return ""
    }
}


proc chatinfo::parse_info_iqtime {chatid jid res child} {

    if {![winfo exists [chat::chat_win $chatid]]} {
	return
    }

    set rjid [whois $chatid $jid]
    if {![cequal $res OK]} {
	chat::add_message $chatid $jid error \
	    [format [::msgcat::mc "time %s%s: %s"] $jid $rjid [error_to_string $child]] {}
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:iq:time]} {
	userinfo::parse_iqtime_item $jid $children
    }
    set message [format [::msgcat::mc "time %s%s:"] $jid $rjid]
    foreach {i j} [list time [::msgcat::mc "Time:"] \
		    tz   [::msgcat::mc "Time Zone:"] \
		    utc  [::msgcat::mc "UTC:"]] {
	if {[info exists userinfo::userinfo($i,$jid)] && \
		 ![cequal $userinfo::userinfo($i,$jid) ""] } {
	    append message "\n     $j $userinfo::userinfo($i,$jid)"
	}
    }
    chat::add_message $chatid $jid info $message {}
}


proc chatinfo::parse_info_iqlast {chatid jid res child} {

    if {![winfo exists [chat::chat_win $chatid]]} {
	return
    }

    set rjid [whois $chatid $jid]
    if {![cequal $res OK]} {
	chat::add_message $chatid $jid error \
	    [format [::msgcat::mc "last %s%s: %s"] $jid $rjid [error_to_string $child]] {}
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:iq:last]} {
	set ::userinfo::userinfo(lastseconds,$jid) \
	    [format_time [jlib::wrapper:getattr $vars seconds]]
	set ::userinfo::userinfo(lastdesc,$jid) $chdata
    }
    set message [format [::msgcat::mc "last %s%s:"] $jid $rjid]
    foreach {i j} [list lastseconds [::msgcat::mc "Interval:"] \
		    lastdesc    [::msgcat::mc "Description:"]] {
	if {[info exists userinfo::userinfo($i,$jid)] && \
		 ![cequal $userinfo::userinfo($i,$jid) ""]} {
	    append message "\n     $j $userinfo::userinfo($i,$jid)"
	}
    }
    chat::add_message $chatid $jid info $message {}
}


proc chatinfo::parse_info_iqversion {chatid jid res child} {

    if {![winfo exists [chat::chat_win $chatid]]} {
	return
    }

    set rjid [whois $chatid $jid]
    if {![cequal $res OK]} {
	chat::add_message $chatid $jid error \
	    [format [::msgcat::mc "version %s%s: %s"] $jid $rjid [error_to_string $child]] {}
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:iq:version]} {
	userinfo::parse_iqversion_item $jid $children
    }

    set message [format [::msgcat::mc "version %s%s:"] $jid $rjid]
    foreach {i j} [list clientname    [::msgcat::mc "Client:"] \
		    clientversion [::msgcat::mc "Version:"] \
		    os            [::msgcat::mc "OS:"]] {
	if {[info exists userinfo::userinfo($i,$jid)] && \
		 ![cequal $userinfo::userinfo($i,$jid) ""]} {
	    append message "\n     $j $userinfo::userinfo($i,$jid)"
	}
    }
    chat::add_message $chatid $jid info $message {}
}


proc chatinfo::parse_info_vcard {chatid jid res child} {
    variable options
    variable vcard_defs
    variable vcard_names

    if {![winfo exists [chat::chat_win $chatid]]} {
	return
    }

    set rjid [whois $chatid $jid]
    if {![cequal $res OK]} {
	chat::add_message $chatid $jid error \
	    [format [::msgcat::mc "vcard %s%s: %s"] $jid $rjid [error_to_string $child]] {}
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    foreach item $children {
	userinfo::parse_vcard_item $jid $item
    }
    set message [format [::msgcat::mc "vcard %s%s:"] $jid $rjid]
    foreach i $options(vcard_items) {
	set def [lindex $vcard_defs $i]
	set name [lindex $vcard_names $i]
	if {[info exists userinfo::userinfo($def,$jid)] && \
		 ![cequal $userinfo::userinfo($def,$jid) ""]} {
	    append message "\n     $name: $userinfo::userinfo($def,$jid)"
	}
    }
    chat::add_message $chatid $jid info $message {}
}

