# $Id: avatars.tcl,v 1.13 2004/07/15 21:56:11 aleksey Exp $

namespace eval avatar {
    set options(announce) 0
    set options(share) 0
}

package require base64
package require sha1

proc avatar::load_file {filename} {
    variable avatar
    variable options

    image create photo user_avatar -file $filename
    set f [open $filename]
    fconfigure $f -translation binary
    set data [read $f]
    close $f

    set avatar(userhash) [sha1::sha1 $data]
    set avatar(userdata) $data

    set options(announce) 1
    set options(share) 1
}

proc avatar::get_presence_x {} {
    variable avatar
    variable options

    if {$options(announce)} {
	set children [jlib::wrapper:createtag hash -chdata $avatar(userhash)]
	return [jlib::wrapper:createtag x -vars {xmlns jabber:x:avatar} \
		    -subtags [list $children]]

    } else {
	return ""
    }
}

proc avatar::set_hash {jid childrens} {
    variable avatar

    debugmsg avatar "set hash $jid $childrens"
    foreach child $childrens {
	jlib::wrapper:splitxml $child tag vars isempty chdata children
	if {$tag == "hash"} {
	    set hash $chdata
	}
    }
    if {[info exists hash]} {
	if {![info exists avatar(hash,$jid)] || $hash != $avatar(hash,$jid)} {
	    set avatar(hash,$jid) $hash
	    set avatar(needupdate,$jid) 1
	}
    }
}


proc avatar::get_image {jid} {
    variable avatar

    debugmsg avatar "$jid; [array name avatar]"
    if {[info exists avatar(hash,$jid)]} {
	if {![info exists avatar(data,$jid)]} {
	    image create photo avatar_$jid
	    get $jid
	} elseif {$avatar(needupdate,$jid)} {
	    get $jid
	}
	return avatar_$jid
    } else {
	return ""
    }
}

proc avatar::get {jid} {
    variable avatar

    set avatar(needupdate,$jid) 0

    jlib::send_iq get \
	[jlib::wrapper:createtag query \
	     -vars {xmlns jabber:iq:avatar}] \
	-to $jid -command [list avatar::recv $jid]
}

proc avatar::recv {jid res children} {
    variable avatar

    if {![cequal $res OK]} {
	jlib::send_iq get [jlib::wrapper:createtag query \
			       -vars {xmlns storage:client:avatar}] \
	    -to [node_and_server_from_jid $jid] \
	    -command [list avatar::recv_from_serv $jid]

	return
    }

    jlib::wrapper:splitxml $children tag vars isempty chdata childrens
    foreach child $childrens {
	jlib::wrapper:splitxml $child tag1 vars1 isempty1 chdata1 childrens1
	if {$tag1 == "data"} {
	    catch {
		set avatar(data,$jid) [base64::decode $chdata1]
		avatar_$jid put $chdata1
	    }
	}
    }
}

proc avatar::recv_from_serv {jid res children} {
    variable avatar

    if {![cequal $res OK]} {
	# TODO
	return
    }

    jlib::wrapper:splitxml $children tag vars isempty chdata childrens
    foreach child $childrens {
	jlib::wrapper:splitxml $child tag1 vars1 isempty1 chdata1 childrens1
	if {$tag1 == "data"} {
	    catch {
		set avatar(data,$jid) [base64::decode $chdata1]
		avatar_$jid put $chdata1
	    }
	}
    }
}

proc avatar::store_on_server {args} {
    variable avatar

    foreach {opt val} $args {
	switch -- $opt {
	    -connection { set connid $val }
	}
    }
    if {![info exists connid]} {
	set connid [jlib::route ""]
    }

    if {![info exists avatar(userdata)]} {
	MessageDlg .avatar_error -aspect 50000 -icon error \
		-message [::msgcat::mc "No avatar to store"] -type user \
		-buttons ok -default 0 -cancel 0
	return
    }

    if {1} {
	set restags \
	    [list [jlib::wrapper:createtag data \
		       -chdata [base64::encode $avatar(userdata)]]]
	set res [jlib::wrapper:createtag query \
		     -vars {xmlns storage:client:avatar} \
		     -subtags $restags]
    } else {
	return ""
    }

    jlib::send_iq set $res -to [jlib::connection_bare_jid $connid] \
	-connection $connid
}


proc avatar::iq_reply {connid from child} {
    variable avatar
    variable options

    if {$options(share)} {
	set restags \
	    [list [jlib::wrapper:createtag data \
		       -chdata [base64::encode $avatar(userdata)]]]
	set res [jlib::wrapper:createtag query \
		     -vars {xmlns jabber:iq:avatar} \
		     -subtags $restags]
    } else {
	return [list error cancel service-unavailable]
    }

    return [list result $res]
}

iq::register_handler get query jabber:iq:avatar avatar::iq_reply

