/* -*- mode: c; c-file-style: "gnu" -*-
 * tls.h -- TLS related function prototypes.
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file tls.h
 * TLS related function prototypes.
 */

#ifndef _THY_TLS_H
#define _THY_TLS_H 1 /**< tls.h multi-inclusion guard. */

#include "options.h"
#include "session.h"

#if THY_OPTION_TLS
#include <gnutls/gnutls.h>

void thy_tls_init (void);
int thy_tls_session_init (session_t *session);
void thy_tls_reinit (int dh_gen);
void thy_tls_cgi_setup_env (session_t *session);

#endif /* THY_OPTION_TLS */

/** Check if TLS is enabled.
 * @param session is the session we're working on.
 * @returns One if TLS is enabled in the session, zero otherwise.
 */
int thy_tls_istls (const session_t *session);

#endif /* ! _THY_TLS_H */
