/*
 * Decompiled with CFR 0.152.
 */
package org.jatha;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import org.jatha.compile.CompilerException;
import org.jatha.compile.LispCompiler;
import org.jatha.display.Listener;
import org.jatha.dynatype.LispBignum;
import org.jatha.dynatype.LispCons;
import org.jatha.dynatype.LispConsOrNil;
import org.jatha.dynatype.LispException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispNil;
import org.jatha.dynatype.LispNumber;
import org.jatha.dynatype.LispPackage;
import org.jatha.dynatype.LispReal;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispSymbol;
import org.jatha.dynatype.LispUndefinedFunctionException;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.StandardLispBignum;
import org.jatha.dynatype.StandardLispCharacter;
import org.jatha.dynatype.StandardLispCons;
import org.jatha.dynatype.StandardLispConstant;
import org.jatha.dynatype.StandardLispInteger;
import org.jatha.dynatype.StandardLispKeyword;
import org.jatha.dynatype.StandardLispNIL;
import org.jatha.dynatype.StandardLispPackage;
import org.jatha.dynatype.StandardLispReal;
import org.jatha.dynatype.StandardLispString;
import org.jatha.dynatype.StandardLispSymbol;
import org.jatha.eval.LispEvaluator;
import org.jatha.machine.SECDMachine;
import org.jatha.read.LispParser;
import org.jatha.util.SymbolTable;

public class Jatha
implements ActionListener {
    private String VERSION_NAME = "Jatha";
    private int VERSION_MAJOR = 2;
    private int VERSION_MINOR = 1;
    private int VERSION_MICRO = 0;
    private String VERSION_TYPE = "";
    private String VERSION_DATE = "10 Aug 2004";
    private String VERSION_URL = "http://jatha.sourceforge.net/";
    public LispEvaluator EVAL;
    public LispPackage PACKAGE;
    public LispValue PACKAGE_SYMBOL;
    public SymbolTable SYMTAB;
    public SECDMachine MACHINE;
    public LispCompiler COMPILER;
    public final Runtime SYSTEM_INFO = Runtime.getRuntime();
    public LispParser PARSER;
    public Listener LISTENER;
    public static int APROPOS_TAB = 30;
    public LispValue DOT;
    public LispConsOrNil NIL;
    public LispValue QUOTE;
    public LispValue BACKQUOTE;
    public LispValue COLON;
    public LispValue NEWLINE;
    public LispValue SPACE;
    public LispValue ZERO;
    public LispValue ONE;
    public LispValue TWO;
    public LispValue PI;
    public LispValue E;
    public LispValue T;
    public LispValue ARRAY_TYPE;
    public LispValue ATOM_TYPE;
    public LispValue BIGNUM_TYPE;
    public LispValue BOOLEAN_TYPE;
    public LispValue CHARACTER_TYPE;
    public LispValue COMPLEX_TYPE;
    public LispValue CONS_TYPE;
    public LispValue DOUBLE_FLOAT_TYPE;
    public LispValue FLOAT_TYPE;
    public LispValue FUNCTION_TYPE;
    public LispValue HASHTABLE_TYPE;
    public LispValue INTEGER_TYPE;
    public LispValue NULL_TYPE;
    public LispValue NUMBER_TYPE;
    public LispValue PACKAGE_TYPE;
    public LispValue PATHNAME_TYPE;
    public LispValue REAL_TYPE;
    public LispValue STREAM_TYPE;
    public LispValue STRING_TYPE;
    public LispValue SYMBOL_TYPE;
    public LispValue VECTOR_TYPE;
    LispValue prompt;
    LispValue userPrompt;
    LispValue packages = null;
    LispValue STAR;
    LispValue STARSTAR;
    LispValue STARSTARSTAR;
    LispValue MAX_LIST_LENGTH;
    static long MAX_LIST_LENGTH_VALUE = 50000L;
    boolean useGUI = true;
    boolean useConsole = false;

    private void initializeConstants() {
        try {
            if (this.SYMTAB == null) {
                System.err.println("In LispValue, symtab is null!");
                throw new Exception("In LispValue init, symtab is null!");
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        this.DOT = new StandardLispSymbol(this, ".");
        this.EVAL.intern(this.makeString("DOT"), this.DOT);
        this.NIL = new StandardLispNIL(this, "NIL");
        this.EVAL.intern(this.makeString("NIL"), this.NIL);
        this.QUOTE = new StandardLispSymbol(this, "QUOTE");
        this.EVAL.intern(this.makeString("QUOTE"), this.QUOTE);
        this.BACKQUOTE = new StandardLispSymbol(this, "BACKQUOTE");
        this.EVAL.intern(this.makeString("BACKQUOTE"), this.BACKQUOTE);
        this.T = new StandardLispConstant(this, "T");
        this.EVAL.intern(this.makeString("T"), this.T);
        this.T.setf_symbol_value(this.T);
        this.ZERO = new StandardLispInteger(this, 0L);
        this.ONE = new StandardLispInteger(this, 1L);
        this.TWO = new StandardLispInteger(this, 2L);
        this.E = new StandardLispReal(this, Math.E);
        this.PI = new StandardLispReal(this, Math.PI);
        this.COLON = new StandardLispCharacter(this, ':');
        this.NEWLINE = new StandardLispCharacter(this, '\n');
        this.SPACE = new StandardLispCharacter(this, ' ');
        this.ARRAY_TYPE = new StandardLispSymbol(this, "ARRAY");
        this.EVAL.intern(this.makeString("ARRAY"), this.ARRAY_TYPE);
        this.ATOM_TYPE = new StandardLispSymbol(this, "ATOM");
        this.EVAL.intern(this.makeString("ATOM"), this.ATOM_TYPE);
        this.BIGNUM_TYPE = new StandardLispSymbol(this, "BIGNUM");
        this.EVAL.intern(this.makeString("BIGNUM"), this.BIGNUM_TYPE);
        this.BOOLEAN_TYPE = new StandardLispSymbol(this, "BOOLEAN");
        this.EVAL.intern(this.makeString("BOOLEAN"), this.BOOLEAN_TYPE);
        this.CHARACTER_TYPE = new StandardLispSymbol(this, "CHARACTER");
        this.EVAL.intern(this.makeString("CHARACTER"), this.CHARACTER_TYPE);
        this.COMPLEX_TYPE = new StandardLispSymbol(this, "COMPLEX");
        this.EVAL.intern(this.makeString("COMPLEX"), this.COMPLEX_TYPE);
        this.CONS_TYPE = new StandardLispSymbol(this, "CONS");
        this.EVAL.intern(this.makeString("CONS"), this.CONS_TYPE);
        this.DOUBLE_FLOAT_TYPE = new StandardLispSymbol(this, "DOUBLE-FLOAT");
        this.EVAL.intern(this.makeString("DOUBLE-FLOAT"), this.DOUBLE_FLOAT_TYPE);
        this.FLOAT_TYPE = new StandardLispSymbol(this, "FLOAT");
        this.EVAL.intern(this.makeString("FLOAT"), this.FLOAT_TYPE);
        this.FUNCTION_TYPE = new StandardLispSymbol(this, "FUNCTION");
        this.EVAL.intern(this.makeString("FUNCTION"), this.FUNCTION_TYPE);
        this.HASHTABLE_TYPE = new StandardLispSymbol(this, "HASH-TABLE");
        this.EVAL.intern(this.makeString("TABLE"), this.HASHTABLE_TYPE);
        this.INTEGER_TYPE = new StandardLispSymbol(this, "INTEGER");
        this.EVAL.intern(this.makeString("INTEGER"), this.INTEGER_TYPE);
        this.NULL_TYPE = new StandardLispSymbol(this, "NULL");
        this.EVAL.intern(this.makeString("NULL"), this.NULL_TYPE);
        this.NUMBER_TYPE = new StandardLispSymbol(this, "NUMBER");
        this.EVAL.intern(this.makeString("NUMBER"), this.NUMBER_TYPE);
        this.PACKAGE_TYPE = new StandardLispSymbol(this, "PACKAGE");
        this.EVAL.intern(this.makeString("PACKAGE"), this.PACKAGE_TYPE);
        this.PATHNAME_TYPE = new StandardLispSymbol(this, "PATHNAME");
        this.EVAL.intern(this.makeString("PATHNAME"), this.PATHNAME_TYPE);
        this.REAL_TYPE = new StandardLispSymbol(this, "REAL");
        this.EVAL.intern(this.makeString("REAL"), this.REAL_TYPE);
        this.STREAM_TYPE = new StandardLispSymbol(this, "STREAM");
        this.EVAL.intern(this.makeString("STREAM"), this.STREAM_TYPE);
        this.STRING_TYPE = new StandardLispSymbol(this, "STRING");
        this.EVAL.intern(this.makeString("STRING"), this.STRING_TYPE);
        this.SYMBOL_TYPE = new StandardLispSymbol(this, "SYMBOL");
        this.EVAL.intern(this.makeString("SYMBOL"), this.SYMBOL_TYPE);
        this.VECTOR_TYPE = new StandardLispSymbol(this, "VECTOR");
        this.EVAL.intern(this.makeString("VECTOR"), this.VECTOR_TYPE);
    }

    public void initConstants2() {
        if (this.SYMTAB == null) {
            System.err.println("In LispValue.init(), symtab is null!");
            System.exit(1);
        }
        if (this.PACKAGE == null) {
            System.err.println("In LispValue.init(), package is null!");
            System.exit(1);
        }
        this.EVAL.intern((LispString)this.DOT.symbol_name(), this.DOT);
        this.EVAL.intern((LispString)this.NIL.symbol_name(), this.NIL);
        this.EVAL.intern((LispString)this.QUOTE.symbol_name(), this.QUOTE);
        this.EVAL.intern((LispString)this.BACKQUOTE.symbol_name(), this.BACKQUOTE);
        this.EVAL.intern((LispString)this.T.symbol_name(), this.T);
        this.EVAL.intern((LispString)this.ARRAY_TYPE.symbol_name(), this.ARRAY_TYPE);
        this.EVAL.intern((LispString)this.ATOM_TYPE.symbol_name(), this.ATOM_TYPE);
        this.EVAL.intern((LispString)this.BIGNUM_TYPE.symbol_name(), this.BIGNUM_TYPE);
        this.EVAL.intern((LispString)this.CHARACTER_TYPE.symbol_name(), this.CHARACTER_TYPE);
        this.EVAL.intern((LispString)this.COMPLEX_TYPE.symbol_name(), this.COMPLEX_TYPE);
        this.EVAL.intern((LispString)this.CONS_TYPE.symbol_name(), this.CONS_TYPE);
        this.EVAL.intern((LispString)this.DOUBLE_FLOAT_TYPE.symbol_name(), this.DOUBLE_FLOAT_TYPE);
        this.EVAL.intern((LispString)this.FLOAT_TYPE.symbol_name(), this.FLOAT_TYPE);
        this.EVAL.intern((LispString)this.FUNCTION_TYPE.symbol_name(), this.FUNCTION_TYPE);
        this.EVAL.intern((LispString)this.HASHTABLE_TYPE.symbol_name(), this.HASHTABLE_TYPE);
        this.EVAL.intern((LispString)this.INTEGER_TYPE.symbol_name(), this.INTEGER_TYPE);
        this.EVAL.intern((LispString)this.NULL_TYPE.symbol_name(), this.NULL_TYPE);
        this.EVAL.intern((LispString)this.NUMBER_TYPE.symbol_name(), this.NUMBER_TYPE);
        this.EVAL.intern((LispString)this.PACKAGE_TYPE.symbol_name(), this.PACKAGE_TYPE);
        this.EVAL.intern((LispString)this.PATHNAME_TYPE.symbol_name(), this.PATHNAME_TYPE);
        this.EVAL.intern((LispString)this.REAL_TYPE.symbol_name(), this.REAL_TYPE);
        this.EVAL.intern((LispString)this.STREAM_TYPE.symbol_name(), this.STREAM_TYPE);
        this.EVAL.intern((LispString)this.STRING_TYPE.symbol_name(), this.STRING_TYPE);
        this.EVAL.intern((LispString)this.SYMBOL_TYPE.symbol_name(), this.SYMBOL_TYPE);
        this.EVAL.intern((LispString)this.VECTOR_TYPE.symbol_name(), this.VECTOR_TYPE);
    }

    public Jatha() {
        this(false, true, false);
    }

    public Jatha(boolean useGui) {
        this(useGui, false, false);
    }

    public Jatha(boolean useGui, boolean useText) {
        this(useGui, useText, false);
    }

    public Jatha(boolean useDisplay, boolean useText, boolean showHelp) {
        try {
            this.useGUI = useDisplay;
            this.useConsole = useText;
            if (showHelp) {
                this.showHelp();
            }
        }
        catch (Throwable e) {
            System.err.println("error initializing Jatha: " + e);
        }
    }

    public String getVersionString() {
        return this.getVersionName() + " " + this.getVersionMajor() + "." + this.getVersionMinor() + "." + this.getVersionMicro() + this.getVersionType() + ", " + this.getVersionDate() + ", contact: " + this.getVersionURL();
    }

    public String getVersionName() {
        return this.VERSION_NAME;
    }

    public String getVersionDate() {
        return this.VERSION_DATE;
    }

    public String getVersionURL() {
        return this.VERSION_URL;
    }

    public String getVersionType() {
        return this.VERSION_TYPE;
    }

    public int getVersionMajor() {
        return this.VERSION_MAJOR;
    }

    public int getVersionMinor() {
        return this.VERSION_MINOR;
    }

    public int getVersionMicro() {
        return this.VERSION_MICRO;
    }

    void showHelp() {
        System.out.println("\njava org.jatha.Jatha  [-help] [-nodisplay]\n");
        System.out.println("  This is a small Common LISP compatible LISP environment.");
        System.out.println("  Use the  -nodisplay  option to suppress GUI features.");
        System.out.println("");
        System.exit(0);
    }

    public LispInteger getMaxListLength() {
        return (LispInteger)this.MAX_LIST_LENGTH.symbol_value();
    }

    public void setMaxListLength(long newLength) {
        this.MAX_LIST_LENGTH.setf_symbol_value(new StandardLispInteger(this, newLength));
    }

    public void setMaxListLength(LispNumber newLength) {
        this.MAX_LIST_LENGTH.setf_symbol_value(new StandardLispInteger(this, (long)newLength.getDoubleValue()));
    }

    public static void main(String[] args) {
        boolean useDisplay = true;
        boolean help = false;
        boolean illegalArg = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-nodisplay")) {
                useDisplay = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-help")) {
                help = true;
                continue;
            }
            System.out.println("Jatha: unknown argument: " + args[i]);
            illegalArg = true;
        }
        if (illegalArg) {
            System.exit(1);
        }
        Jatha applet = new Jatha(useDisplay, true, help);
        applet.init();
        applet.start();
    }

    public void init() {
        this.EVAL = new LispEvaluator(this);
        this.SYMTAB = new SymbolTable(this);
        this.initializeConstants();
        this.PACKAGE = null;
        this.PACKAGE = new StandardLispPackage(this, this.makeString("COMMON-LISP-USER"), this.makeList(this.makeString("CL-USER"), this.makeString("USER")), this.NIL, this.SYMTAB);
        this.initConstants2();
        this.packages = this.makeList(this.PACKAGE);
        this.packages = this.makeCons(new StandardLispPackage(this, this.makeString("KEYWORD"), this.makeList(this.makeString(""))), this.packages);
        this.packages = this.makeCons(new StandardLispPackage(this, this.makeString("COMMON-LISP"), this.makeList(this.makeString("CL"))), this.packages);
        this.packages = this.makeCons(new StandardLispPackage(this, this.makeString("SYSTEM"), this.makeList(this.makeString("SYS"))), this.packages);
        this.COMPILER = new LispCompiler(this);
        this.MACHINE = new SECDMachine(this);
        this.PARSER = new LispParser(this, new InputStreamReader(System.in));
        this.prompt = this.makeString("Jatha> ");
        this.STAR = this.EVAL.intern("*");
        this.STARSTAR = this.EVAL.intern("**");
        this.STARSTARSTAR = this.EVAL.intern("***");
        this.STAR.setf_symbol_value(this.NIL);
        this.STARSTAR.setf_symbol_value(this.NIL);
        this.STARSTARSTAR.setf_symbol_value(this.NIL);
        this.MAX_LIST_LENGTH = this.EVAL.intern("*MAX-LIST-LENGTH*");
        this.MAX_LIST_LENGTH.setf_symbol_value(new StandardLispInteger(this, MAX_LIST_LENGTH_VALUE));
        this.EVAL.init();
        this.PACKAGE_SYMBOL = this.EVAL.intern("*PACKAGE*");
        this.COMPILER.init();
        if (this.useGUI) {
            this.LISTENER = new Listener(this, this.getVersionString(), "Jatha> ");
        }
    }

    public void start() {
        System.err.println(this.getVersionString());
        if (!this.useGUI && this.useConsole) {
            this.readEvalPrintLoop();
        }
    }

    public LispValue eval(LispValue inValue) {
        LispValue value;
        try {
            LispValue code = this.COMPILER.compile(this.MACHINE, inValue, (LispValue)this.NIL);
            value = this.MACHINE.Execute(code, this.NIL);
        }
        catch (LispUndefinedFunctionException ufe) {
            System.err.println("ERROR: " + ufe.getMessage());
            return this.makeString(ufe.getMessage());
        }
        catch (CompilerException ce) {
            System.err.println("ERROR: " + ce);
            return this.makeString(ce.toString());
        }
        catch (LispException le) {
            System.err.println("ERROR: " + le.getMessage());
            return this.makeString(le.getMessage());
        }
        catch (Exception e) {
            System.err.println("Unknown error: " + e.getMessage());
            return this.makeString(e.getMessage());
        }
        this.STARSTARSTAR.setf_symbol_value(this.STARSTAR.symbol_value());
        this.STARSTAR.setf_symbol_value(this.STAR.symbol_value());
        this.STAR.setf_symbol_value(value);
        return value;
    }

    void readEvalPrintLoop() {
        LispString prompt = this.makeString("Jatha> ");
        LispValue STAR = this.EVAL.intern("*");
        LispValue STARSTAR = this.EVAL.intern("**");
        LispValue STARSTARSTAR = this.EVAL.intern("***");
        STAR.setf_symbol_value(this.NIL);
        STARSTAR.setf_symbol_value(this.NIL);
        STARSTARSTAR.setf_symbol_value(this.NIL);
        System.out.println("Run (EXIT) to stop.");
        LispValue input = this.NIL;
        while (true) {
            LispValue value;
            LispValue code;
            System.out.println();
            prompt.princ();
            System.out.flush();
            boolean validInput = true;
            try {
                input = this.PARSER.parse();
            }
            catch (EOFException e) {
                validInput = false;
                System.err.println("Incomplete input.");
            }
            if (!validInput) continue;
            try {
                code = this.COMPILER.compile(this.MACHINE, input, (LispValue)this.NIL);
            }
            catch (Exception e) {
                System.out.println("Unable to compile " + input + "\n  " + e);
                continue;
            }
            try {
                value = this.MACHINE.Execute(code, this.NIL);
            }
            catch (Exception e2) {
                System.out.println("Unable to evaluate " + input + "\n  " + e2);
                continue;
            }
            STARSTARSTAR.setf_symbol_value(STARSTAR.symbol_value());
            STARSTAR.setf_symbol_value(STAR.symbol_value());
            STAR.setf_symbol_value(value);
            value.prin1();
        }
    }

    public LispCompiler getCompiler() {
        return this.COMPILER;
    }

    public LispParser getParser() {
        return this.PARSER;
    }

    public LispEvaluator getEval() {
        return this.EVAL;
    }

    public SymbolTable getSymbolTable() {
        return this.SYMTAB;
    }

    public LispValue parse(String s, int caseSensitivity) throws EOFException {
        return new LispParser(this, s, caseSensitivity).parse();
    }

    public LispValue parse(String s) throws EOFException {
        return this.parse(s, 1);
    }

    public LispValue load(LispValue filenameVal) {
        String filename = ((LispString)filenameVal).getValue();
        FileReader in = null;
        try {
            in = new FileReader(filename);
        }
        catch (FileNotFoundException e) {
            System.err.println(";; *** File not found: " + filename);
            return this.NIL;
        }
        BufferedReader buff = new BufferedReader(in);
        LispParser fileparser = new LispParser(this, buff);
        try {
            while (true) {
                LispValue input = fileparser.parse();
                LispValue code = this.COMPILER.compile(this.MACHINE, input, (LispValue)this.NIL);
                this.MACHINE.Execute(code, this.NIL);
            }
        }
        catch (IOException ioe) {
            try {
                in.close();
            }
            catch (IOException e2) {
                System.err.println("Error closing file " + filename);
                return this.T;
            }
        }
        catch (CompilerException ce) {
            System.err.println("Error reading file " + filename + ":\n" + ce.toString());
        }
        return this.T;
    }

    public LispValue findPackage(LispValue packageName) {
        if (packageName instanceof LispPackage) {
            return packageName;
        }
        if (packageName.symbolp() == this.T) {
            packageName = packageName.symbol_name();
        }
        return this.findPackage(((LispString)packageName).getValue());
    }

    public LispValue findPackage(String packageNameStr) {
        if (this.packages == null) {
            return this.NIL;
        }
        for (LispValue pList = this.packages; pList != this.NIL; pList = pList.cdr()) {
            LispPackage pkg = (LispPackage)pList.car();
            if (packageNameStr.equals(pkg.getName().getValue())) {
                return pkg;
            }
            for (LispValue nickNameList = pkg.getNicknames(); nickNameList != this.NIL; nickNameList = nickNameList.cdr()) {
                if (!packageNameStr.equals(((LispString)nickNameList.car()).getValue())) continue;
                return pkg;
            }
        }
        return this.NIL;
    }

    public LispValue allPackages() {
        return this.packages;
    }

    public LispValue apropos(LispValue str, LispValue pkg) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter(sout);
        out.println();
        if (pkg == this.NIL) {
            pkg = this.allPackages();
        } else if (pkg instanceof LispPackage) {
            pkg = this.makeList(pkg);
        }
        String matchStr = ((LispString)str).getValue().toUpperCase();
        while (pkg != this.NIL) {
            Iterator iter = ((LispPackage)pkg.car()).getSymbolTable().values().iterator();
            while (iter.hasNext()) {
                LispValue symb = (LispValue)iter.next();
                LispString sname = (LispString)symb.symbol_name();
                String symbstr = sname.getValue().toUpperCase();
                if (symbstr.indexOf(matchStr) < 0) continue;
                symb.apropos_print(out);
            }
            pkg = pkg.cdr();
        }
        out.flush();
        return new StandardLispString(this, sout.toString());
    }

    public long free() {
        return this.free(System.out);
    }

    public long free(PrintStream out) {
        long free = this.SYSTEM_INFO.freeMemory();
        long total = this.SYSTEM_INFO.totalMemory();
        out.println(";; " + free + "/" + total + "bytes (" + (long)(100.0 * ((double)free / (double)total)) + "%) of memory free.");
        return free;
    }

    public void javaTrace(boolean on) {
        this.SYSTEM_INFO.traceMethodCalls(on);
    }

    public void gc() {
        System.out.print("\n;;  GC...");
        System.out.flush();
        this.SYSTEM_INFO.gc();
        System.out.println("done");
        System.out.flush();
    }

    public void gc_full() {
        System.out.print("\n;;  GC...");
        System.out.flush();
        this.SYSTEM_INFO.runFinalization();
        this.SYSTEM_INFO.gc();
        System.out.println("done");
        this.free();
    }

    public LispPackage defpackage(LispValue args) {
        return this.PACKAGE;
    }

    public void actionPerformed(ActionEvent event) {
    }

    public LispCons makeCons(LispValue theCar, LispValue theCdr) {
        return new StandardLispCons(this, theCar, theCdr);
    }

    public LispConsOrNil makeList(Collection elements) {
        Object[] elArray = elements.toArray();
        LispConsOrNil result = this.NIL;
        for (int i = elArray.length - 1; i >= 0; --i) {
            result = new StandardLispCons(this, (LispValue)elArray[i], result);
        }
        return result;
    }

    public LispCons makeList(LispValue first) {
        return new StandardLispCons(this, first, this.NIL);
    }

    public LispCons makeList(LispValue first, LispValue second) {
        return new StandardLispCons(this, first, new StandardLispCons(this, second, this.NIL));
    }

    public LispCons makeList(LispValue first, LispValue second, LispValue third) {
        return new StandardLispCons(this, first, new StandardLispCons(this, second, new StandardLispCons(this, third, this.NIL)));
    }

    public LispCons makeList(LispValue first, LispValue second, LispValue third, LispValue fourth) {
        return new StandardLispCons(this, first, new StandardLispCons(this, second, new StandardLispCons(this, third, new StandardLispCons(this, fourth, this.NIL))));
    }

    public LispConsOrNil makeAppendList(Collection elements) {
        if (elements.size() == 0) {
            return this.NIL;
        }
        LispValue result = this.NIL;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            LispValue o = (LispValue)iterator.next();
            result = result.append(o);
        }
        return result;
    }

    public LispConsOrNil makeNconcList(Collection elements) {
        if (elements.size() == 0) {
            return this.NIL;
        }
        LispValue result = this.NIL;
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            LispValue o = (LispValue)iterator.next();
            result = result.nconc(o);
        }
        return result;
    }

    public LispInteger makeInteger(Long value) {
        return new StandardLispInteger(this, value);
    }

    public LispInteger makeInteger(long value) {
        return new StandardLispInteger(this, value);
    }

    public LispInteger makeInteger(Integer value) {
        return new StandardLispInteger(this, value.longValue());
    }

    public LispInteger makeInteger(int value) {
        return new StandardLispInteger(this, value);
    }

    public LispInteger makeInteger() {
        return new StandardLispInteger(this, 0L);
    }

    public LispBignum makeBignum(BigInteger value) {
        return new StandardLispBignum(this, value);
    }

    public LispBignum makeBignum(LispInteger value) {
        return new StandardLispBignum(this, BigInteger.valueOf(value.getLongValue()));
    }

    public LispBignum makeBignum(double value) {
        return new StandardLispBignum(this, BigInteger.valueOf((long)value));
    }

    public LispBignum makeBignum(long value) {
        return new StandardLispBignum(this, BigInteger.valueOf(value));
    }

    public LispReal makeReal(Double value) {
        return new StandardLispReal(this, value);
    }

    public LispReal makeReal(double value) {
        return new StandardLispReal(this, value);
    }

    public LispReal makeReal(Float value) {
        return new StandardLispReal(this, value.doubleValue());
    }

    public LispReal makeReal(float value) {
        return new StandardLispReal(this, value);
    }

    public LispReal makeReal() {
        return new StandardLispReal(this, 0.0);
    }

    public LispString makeString(String str) {
        return new StandardLispString(this, str);
    }

    public LispSymbol makeSymbol(String symbolName) {
        return new StandardLispSymbol(this, symbolName);
    }

    public LispSymbol makeSymbol(LispString symbolName) {
        return new StandardLispSymbol(this, symbolName);
    }

    public LispSymbol makeConstant(String symbolName) {
        return new StandardLispConstant(this, symbolName);
    }

    public LispSymbol makeConstant(LispString symbolName) {
        return new StandardLispConstant(this, symbolName);
    }

    public LispSymbol makeKeyword(String symbolName) {
        return new StandardLispKeyword(this, symbolName);
    }

    public LispSymbol makeKeyword(LispString symbolName) {
        return new StandardLispKeyword(this, symbolName);
    }

    public LispNil makeNIL(String symbolName) {
        return new StandardLispNIL(this, symbolName);
    }

    public LispNil makeNIL(LispString symbolName) {
        return new StandardLispNIL(this, symbolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispValue toLisp(Object obj) {
        if (obj == null) {
            return this.NIL;
        }
        if (obj instanceof LispValue) {
            return (LispValue)obj;
        }
        if (obj instanceof Integer) {
            return new StandardLispInteger(this, ((Integer)obj).intValue());
        }
        if (obj instanceof Long) {
            return new StandardLispInteger(this, (Long)obj);
        }
        if (obj instanceof Double) {
            return new StandardLispReal(this, (Double)obj);
        }
        if (obj instanceof Float) {
            return new StandardLispReal(this, ((Float)obj).doubleValue());
        }
        if (obj instanceof String) {
            return new StandardLispString(this, (String)obj);
        }
        LispValue result = this.NIL;
        try {
            result = new LispParser(this, obj.toString(), 3).parse();
            return result;
        }
        catch (Exception e) {
            System.err.println("Error in Jatha.toLisp(" + obj + ")");
        }
        finally {
            return result;
        }
    }
}

