/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.StaticMainWindow;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class StaticMainWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
PopupMenuListener,
Printable,
ParaProfImageInterface {
    private ParaProfTrial trial = null;
    StaticMainWindow window = null;
    private Vector list;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 500;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 100;
    private int lastHeaderEndPosition = 0;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    private JPopupMenu popup3 = new JPopupMenu();
    private JMenuItem tUESWItem = null;
    private JMenuItem threadCallpathItem = null;
    private Object clickedOnObject = null;

    public StaticMainWindowPanel(ParaProfTrial paraProfTrial, StaticMainWindow staticMainWindow) {
        this.setToolTipText("ParaProf bar graph draw window!");
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.trial = paraProfTrial;
        this.window = staticMainWindow;
        this.barLength = this.baseBarLength;
        JMenuItem jMenuItem = new JMenuItem("Show Mean Statistics Window");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Mean Call Path Thread Relations");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Mean Call Graph");
        jMenuItem.addActionListener(this);
        this.popup1.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Statistics Window");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        if (paraProfTrial.userEventsPresent()) {
            jMenuItem = new JMenuItem("Show User Event Statistics Window");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
        }
        jMenuItem = new JMenuItem("Show Call Path Thread Relations");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        jMenuItem = new JMenuItem("Show Thread Call Graph");
        jMenuItem.addActionListener(this);
        this.popup2.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Show Function Details");
        jMenuItem2.addActionListener(this);
        this.popup3.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Show Function Histogram");
        jMenuItem3.addActionListener(this);
        this.popup3.add(jMenuItem3);
        jMenuItem = new JMenuItem("Change Function Color");
        jMenuItem.addActionListener(this);
        this.popup3.add(jMenuItem);
        jMenuItem = new JMenuItem("Reset to Generic Color");
        jMenuItem.addActionListener(this);
        this.popup3.add(jMenuItem);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            PPThread pPThread = null;
            int n3 = 0;
            if (this.trial.getPreferences().getBarSpacing() != 0) {
                n3 = n2 / this.trial.getPreferences().getBarSpacing();
            }
            if (n3 == 0) {
                if (n < this.barXCoord) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("You are to the left of the mean bar.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more options about the mean values for the functionProfiles in the system.");
                    }
                    return "Left or right click for more options";
                }
                pPThread = (PPThread)this.list.get(n3);
                ListIterator listIterator = pPThread.getFunctionListIterator();
                while (listIterator.hasNext()) {
                    PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
                    if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the mean draw bar!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Current function name is: " + pPFunctionProfile.getFunctionName());
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("The mean draw bars give a visual representation of the mean values for the functionProfiles which have run in the system.  The funtions are assigned a color from the current ParaProf color set.  The colors are cycled through when the number of funtions exceeds the number of available colors. In the preferences section, you can add more colors.  Use the right and left mouse buttons to give additional information.");
                    }
                    return pPFunctionProfile.getFunctionName();
                }
                if (n <= pPThread.getMiscXEnd() && n >= pPThread.getMiscXBeg()) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("These are functionProfiles which have a non zero value, but whose screen representation is less than a pixel.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("To view these functionProfiles, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                    }
                    return "Misc function section ... see help window for details";
                }
            } else if (n3 < this.list.size()) {
                pPThread = (PPThread)this.list.get(n3);
                if (n < this.barXCoord) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more options for this thread.");
                    }
                    return "Left or right click for more options";
                }
                ListIterator listIterator = pPThread.getFunctionListIterator();
                while (listIterator.hasNext()) {
                    PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
                    if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over one of the thread draw bars!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("Current function name is: " + pPFunctionProfile.getFunctionName());
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("The thread draw bars give a visual representation functionProfiles which have run on this thread.  The funtions are assigned a color from the current color set.  The colors are cycled through when the number of functionProfiles exceeds the number of available colors.  Use the right and left mouse buttons to give additional information.");
                    }
                    return pPFunctionProfile.getFunctionName();
                }
                if (n <= pPThread.getMiscXEnd() && n >= pPThread.getMiscXBeg()) {
                    if (ParaProf.helpWindow.isShowing()) {
                        ParaProf.helpWindow.clearText();
                        ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("These are functionProfiles which have a non zero value, but whose screen representation is less than a pixel.");
                        ParaProf.helpWindow.writeText("");
                        ParaProf.helpWindow.writeText("To view these functionProfiles, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                    }
                    return "Misc function section ... see help window for details";
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        String string;
        this.list = this.window.getData();
        int n = 0;
        PPThread pPThread = null;
        this.trial.getPreferences().setBarDetails(graphics2D);
        this.barSpacing = this.trial.getPreferences().getBarSpacing();
        this.barHeight = this.trial.getPreferences().getBarHeight();
        Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int[] nArray = this.trial.getMaxNCTNumbers();
        this.barXCoord = fontMetrics.stringWidth("n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2]) + 15;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        if (!bl2) {
            if (bl) {
                rectangle = graphics2D.getClipBounds();
                n2 = (int)rectangle.getY();
                n3 = (int)((double)n2 + rectangle.getHeight());
            } else {
                rectangle2 = this.window.getViewRect();
                n2 = (int)rectangle2.getY();
                n3 = (int)((double)n2 + rectangle2.getHeight());
            }
            n4 = (n2 - n) / this.barSpacing - 2;
            n5 = (n3 - n) / this.barSpacing + 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 > this.list.size() - 1) {
                n4 = this.list.size() - 1;
            }
            if (n5 > this.list.size() - 1) {
                n5 = this.list.size() - 1;
            }
            if (bl) {
                n += n4 * this.barSpacing;
            }
        } else {
            n4 = 0;
            n5 = this.list.size() - 1;
        }
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            n += this.barSpacing;
            string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n += this.barSpacing);
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n;
        }
        int n6 = 0;
        if (this.list != null) {
            for (int i = n4; i <= n5; ++i) {
                string = i == 0 ? "mean" : "n,c,t " + pPThread.getNodeID() + "," + pPThread.getContextID() + "," + pPThread.getThreadID();
                int n7 = this.drawBar(graphics2D, fontMetrics, string, pPThread = (PPThread)this.list.elementAt(i), this.barXCoord, n += this.barSpacing, this.barHeight, bl);
                if (n7 <= n6) continue;
                n6 = n7;
            }
        }
        if (this.resizePanel(fontMetrics, n6 + 5) && bl) {
            this.revalidate();
            return;
        }
    }

    private int drawStackedBar(Graphics2D graphics2D, FontMetrics fontMetrics, String string, PPThread pPThread, int n, int n2, int n3, boolean bl) {
        DssIterator dssIterator = null;
        Group group = this.trial.getColorChooser().getHighlightedGroup();
        boolean bl2 = false;
        int n4 = (int)((double)n + (double)this.barLength);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n - fontMetrics.stringWidth(string) - 5, n2);
        double d = 0.0;
        dssIterator = (DssIterator)pPThread.getFunctionListIterator();
        while (dssIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)dssIterator.next();
            d += pPFunctionProfile.getExclusiveValue();
        }
        dssIterator.reset();
        double d2 = 0.0;
        int n5 = 0;
        while (dssIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)dssIterator.next();
            double d3 = 0.0;
            d3 = pPFunctionProfile.getExclusiveValue();
            int n6 = 0;
            n6 = this.window.getNormalizeBars() ? (int)(d3 / d * (double)this.barLength) : (int)((d3 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            if (n6 > 2) {
                d2 += d3;
                n5 += n6;
                if (n3 > 2) {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    graphics2D.fillRect(n + 1, n2 - n3 + 1, n6 - 1, n3 - 1);
                    if (pPFunctionProfile.getFunction() == this.trial.getColorChooser().getHighlightedFunction()) {
                        bl2 = true;
                        graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n6, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n6 - 2, n3 - 2);
                    } else if (pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup())) {
                        bl2 = true;
                        graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n6, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n6 - 2, n3 - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        if (bl2) {
                            graphics2D.drawLine(n + 1, n2 - n3, n + 1 + n6, n2 - n3);
                            graphics2D.drawLine(n + 1, n2, n + 1 + n6, n2);
                            graphics2D.drawLine(n + 1 + n6, n2 - n3, n + 1 + n6, n2);
                            bl2 = false;
                        } else {
                            graphics2D.drawRect(n, n2 - n3, n6, n3);
                        }
                    }
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n6, n2 - n3, n2);
                    }
                    n += n6;
                    continue;
                }
                if (pPFunctionProfile.getFunction() == this.trial.getColorChooser().getHighlightedFunction()) {
                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                } else if (pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup())) {
                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                } else {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                }
                graphics2D.fillRect(n, n2 - n3, n6, n3);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n, n2 - n3, n6, n3);
                if (bl) {
                    pPFunctionProfile.setDrawCoords(n, n + n6, n2 - n3, n2);
                }
                n += n6;
                continue;
            }
            if (!bl) continue;
            pPFunctionProfile.setDrawCoords(n, n, n2 - n3, n2);
        }
        if (this.window.getNormalizeBars()) {
            if (n < n4) {
                graphics2D.setColor(this.trial.getColorChooser().getMiscFunctionColor());
                graphics2D.fillRect(n, n2 - n3, n4 - n, n3);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n, n2 - n3, n4 - n, n3);
                pPThread.setMiscCoords(n, n4, n2 - n3, n2);
                n = n4;
            }
        } else {
            double d4 = d - d2;
            int n7 = (int)((d4 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            graphics2D.setColor(this.trial.getColorChooser().getMiscFunctionColor());
            graphics2D.fillRect(n, n2 - n3, n7, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2 - n3, n7, n3);
            pPThread.setMiscCoords(n, n + n7, n2 - n3, n2);
            n += n7;
        }
        return n;
    }

    private int drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, String string, PPThread pPThread, int n, int n2, int n3, boolean bl) {
        if (this.window.getStackBars()) {
            return this.drawStackedBar(graphics2D, fontMetrics, string, pPThread, n, n2, n3, bl);
        }
        ListIterator listIterator = null;
        Group group = this.trial.getColorChooser().getHighlightedGroup();
        boolean bl2 = false;
        int n4 = (int)((double)n + (double)this.barLength);
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, n - fontMetrics.stringWidth(string) - 5, n2);
        double d = 0.0;
        listIterator = pPThread.getFunctionListIterator();
        ListIterator listIterator2 = ((PPThread)this.list.get(0)).getFunctionListIterator();
        while (listIterator.hasNext()) {
            PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
            d += pPFunctionProfile.getExclusiveValue();
        }
        listIterator = pPThread.getFunctionListIterator();
        double d2 = 0.0;
        int n5 = 0;
        if (!listIterator.hasNext()) {
            return 0;
        }
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
        while (listIterator2.hasNext()) {
            PPFunctionProfile pPFunctionProfile2 = (PPFunctionProfile)listIterator2.next();
            Function function = pPFunctionProfile2.getFunction();
            double d3 = this.window.getDataSorter().getMaxExclusives()[function.getID()];
            int n6 = (int)(d3 / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength);
            if (function != pPFunctionProfile.getFunction()) {
                if (n6 <= 2) continue;
                n += n6 + 5;
                continue;
            }
            double d4 = 0.0;
            d4 = pPFunctionProfile.getExclusiveValue();
            int n7 = 0;
            if (this.window.getNormalizeBars()) {
                n7 = (int)(d4 / d * (double)this.barLength);
            } else {
                n7 = (int)(d4 / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength);
                if (n7 < 1) {
                    n7 = 1;
                }
            }
            if (n7 > 2 || n6 > 2) {
                d2 += d4;
                n5 += n7;
                if (n3 > 2) {
                    graphics2D.setColor(pPFunctionProfile.getColor());
                    graphics2D.fillRect(n + 1, n2 - n3 + 1, n7 - 1, n3 - 1);
                    if (pPFunctionProfile.getFunction() == this.trial.getColorChooser().getHighlightedFunction()) {
                        bl2 = true;
                        graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                    } else if (pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup())) {
                        bl2 = true;
                        graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                        graphics2D.drawRect(n + 1, n2 - n3 + 1, n7 - 2, n3 - 2);
                    } else {
                        graphics2D.setColor(Color.black);
                        graphics2D.drawRect(n, n2 - n3, n7, n3);
                    }
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n7, n2 - n3, n2);
                    }
                    n += n7;
                } else {
                    if (pPFunctionProfile.getFunction() == this.trial.getColorChooser().getHighlightedFunction()) {
                        graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                    } else if (pPFunctionProfile.isGroupMember(this.trial.getColorChooser().getHighlightedGroup())) {
                        graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                    } else {
                        graphics2D.setColor(pPFunctionProfile.getColor());
                    }
                    graphics2D.fillRect(n, n2 - n3, n7, n3);
                    graphics2D.setColor(Color.black);
                    graphics2D.drawRect(n, n2 - n3, n7, n3);
                    if (bl) {
                        pPFunctionProfile.setDrawCoords(n, n + n7, n2 - n3, n2);
                    }
                    n += n7;
                }
            } else if (bl) {
                pPFunctionProfile.setDrawCoords(n, n, n2 - n3, n2);
            }
            if (n6 > 2) {
                n += n6 - n7 + 5;
            }
            if (!listIterator.hasNext()) continue;
            pPFunctionProfile = (PPFunctionProfile)listIterator.next();
        }
        double d5 = d - d2;
        if (d5 > 0.0) {
            int n8 = (int)((d5 + d2) / this.window.getDataSorter().getMaxExclusiveSum() * (double)this.barLength) - n5;
            graphics2D.setColor(this.trial.getColorChooser().getMiscFunctionColor());
            graphics2D.fillRect(n, n2 - n3, n8, n3);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(n, n2 - n3, n8, n3);
            pPThread.setMiscCoords(n, n + n8, n2 - n3, n2);
            n += n8;
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Mean Statistics Window")) {
                    StatWindow statWindow = new StatWindow(this.trial, -1, -1, -1, this.window.getDataSorter(), false);
                    this.trial.getSystemEvents().addObserver(statWindow);
                    statWindow.show();
                } else if (string.equals("Show Mean User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof PPThread) {
                        PPThread pPThread = (PPThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, pPThread.getNodeID(), pPThread.getContextID(), pPThread.getThreadID(), this.window.getDataSorter(), true);
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Mean Call Path Thread Relations")) {
                    PPThread pPThread = (PPThread)this.clickedOnObject;
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.window.getDataSorter(), 0);
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                } else if (string.equals("Show Call Path Thread Relations")) {
                    if (this.clickedOnObject instanceof PPThread) {
                        PPThread pPThread = (PPThread)this.clickedOnObject;
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, pPThread.getNodeID(), pPThread.getContextID(), pPThread.getThreadID(), this.window.getDataSorter(), 1);
                        this.trial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Show Mean Call Graph")) {
                    PPThread pPThread = (PPThread)this.clickedOnObject;
                    CallGraphWindow callGraphWindow = new CallGraphWindow(this.trial, this.trial.getDataSource().getMeanData());
                    this.trial.getSystemEvents().addObserver(callGraphWindow);
                    callGraphWindow.show();
                } else if (string.equals("Show Thread Call Graph")) {
                    PPThread pPThread = (PPThread)this.clickedOnObject;
                    CallGraphWindow callGraphWindow = new CallGraphWindow(this.trial, pPThread.getThread());
                    this.trial.getSystemEvents().addObserver(callGraphWindow);
                    callGraphWindow.show();
                } else if (string.equals("Show Statistics Window")) {
                    if (this.clickedOnObject instanceof PPThread) {
                        PPThread pPThread = (PPThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, pPThread.getNodeID(), pPThread.getContextID(), pPThread.getThreadID(), this.window.getDataSorter(), false);
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show User Event Statistics Window")) {
                    if (this.clickedOnObject instanceof PPThread) {
                        PPThread pPThread = (PPThread)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, pPThread.getNodeID(), pPThread.getContextID(), pPThread.getThreadID(), this.window.getDataSorter(), true);
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.trial, pPFunctionProfile.getFunction(), this.window.getDataSorter());
                        this.trial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    }
                } else if (string.equals("Show Function Histogram")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)this.clickedOnObject;
                        HistogramWindow histogramWindow = new HistogramWindow(this.trial, this.window.getDataSorter(), pPFunctionProfile.getFunction());
                        this.trial.getSystemEvents().addObserver(histogramWindow);
                        histogramWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    if (this.clickedOnObject instanceof PPFunctionProfile) {
                        Function function = ((PPFunctionProfile)this.clickedOnObject).getFunction();
                        Color color = function.getColor();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            function.setSpecificColor(color);
                            function.setColorFlag(true);
                            this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    }
                } else if (string.equals("Reset to Generic Color") && this.clickedOnObject instanceof PPFunctionProfile) {
                    Function function = ((PPFunctionProfile)this.clickedOnObject).getFunction();
                    function.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPThread pPThread = null;
            int n4 = n2 / this.trial.getPreferences().getBarSpacing();
            if (n4 >= this.list.size()) {
                this.trial.getColorChooser().setHighlightedFunction(null);
                return;
            }
            pPThread = (PPThread)this.list.elementAt(n4);
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                if (n < this.barXCoord) {
                    this.clickedOnObject = pPThread;
                    if (n4 == 0) {
                        this.popup1.show(this, mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        this.popup2.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else {
                    ListIterator listIterator = pPThread.getFunctionListIterator();
                    while (listIterator.hasNext()) {
                        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)listIterator.next();
                        if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                        this.clickedOnObject = pPFunctionProfile;
                        this.popup3.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                }
            } else if (n < this.barXCoord) {
                ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, pPThread.getNodeID(), pPThread.getContextID(), pPThread.getThreadID(), this.window.getDataSorter());
                this.trial.getSystemEvents().addObserver(threadDataWindow);
                threadDataWindow.show();
            } else {
                DssIterator dssIterator = (DssIterator)pPThread.getFunctionListIterator();
                while (dssIterator.hasNext()) {
                    PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)dssIterator.next();
                    if (n > pPFunctionProfile.getXEnd() || n < pPFunctionProfile.getXBeg()) continue;
                    this.trial.getColorChooser().setHighlightedFunction(pPFunctionProfile.getFunction());
                    FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.trial, pPFunctionProfile.getFunction(), this.window.getDataSorter());
                    this.trial.getSystemEvents().addObserver(functionDataWindow);
                    functionDataWindow.show();
                    return;
                }
                this.trial.getColorChooser().setHighlightedFunction(null);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        try {
            if (this.trial.userEventsPresent()) {
                this.tUESWItem.setEnabled(true);
            } else {
                this.tUESWItem.setEnabled(false);
            }
            if (this.trial.callPathDataPresent()) {
                this.threadCallpathItem.setEnabled(true);
            } else {
                this.threadCallpathItem.setEnabled(true);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        double d = this.window.getSliderValue();
        double d2 = this.window.getSliderMultiple();
        this.barLength = (int)((double)this.baseBarLength * (d * d2));
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = (this.window.getData().size() + 1) * this.barSpacing + 10;
        int n3 = n;
        if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
            this.yPanelSize = n2;
            this.xPanelSize = n3;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }
}

