/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;

public abstract class RegistryManager
implements IRegistryChangeListener {
    private String elementId;
    private String extPtId;
    private HashMap cache;
    public static final int REGISTRY_CACHE_STATE_UNKNOWN = 0;
    public static final int REGISTRY_CACHE_STATE_ACTIVE = 1;
    public static final int REGISTRY_CACHE_STATE_DELETED = 2;
    public static final int REGISTRY_CACHE_STATE_MAX = 2;
    public static final String INTERNAL_REGISTRY_ADDITION = "InternalRegistryAddition";
    private int numObjects = 0;

    public RegistryManager(String elementId, String extPtId) {
        this.elementId = elementId;
        this.extPtId = extPtId;
        this.cache = new HashMap();
    }

    public RegistryManager getCache() {
        return this;
    }

    public Object[] getRegistryObjects() {
        Object[] regElements = this.cache.values().toArray();
        if (regElements.length == 0) {
            return null;
        }
        Object[] ret = new Object[this.numObjects];
        int retIdx = 0;
        int i = 0;
        while (i < regElements.length) {
            ArrayList listElement = ((RegistryElement)regElements[i]).getRealObjects();
            if (listElement != null) {
                ListIterator iter = listElement.listIterator();
                while (iter.hasNext()) {
                    ret[retIdx++] = iter.next();
                }
            }
            ++i;
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    public void registryChanged(IRegistryChangeEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 66->70)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void add(IExtensionDelta delta) {
        delta.getExtensionPoint();
        IExtension ext = delta.getExtension();
        String pluginId = ext.getNamespace();
        this.add(this.buildNewCacheObject(delta), pluginId);
    }

    public void add(Object element, String pluginId) {
        RegistryElement regElement;
        if (element == null) {
            return;
        }
        String toUsePluginId = pluginId;
        if (pluginId == null || pluginId.length() == 0) {
            toUsePluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((regElement = (RegistryElement)this.cache.get(toUsePluginId)) == null) {
            regElement = new RegistryElement(element);
            this.cache.put(toUsePluginId, regElement);
        } else {
            regElement.addNewObject(element);
        }
    }

    public abstract Object buildNewCacheObject(IExtensionDelta var1);

    public abstract void postChangeProcessing();

    public void remove(String[] plugins) {
        int i = 0;
        while (i < plugins.length) {
            this.remove(plugins[i]);
            ++i;
        }
    }

    public void remove(String pluginId) {
        RegistryElement element = (RegistryElement)this.cache.get(pluginId);
        if (element != null) {
            element.changeState(2);
        }
    }

    public void cleanRegistry() {
        Set elements = this.cache.keySet();
        HashSet keysToRemove = new HashSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object pluginId = iter.next();
            RegistryElement elem = (RegistryElement)this.cache.get(pluginId);
            if (elem == null || elem.state != 2) continue;
            keysToRemove.add(pluginId);
        }
        Iterator removeIterator = keysToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.cache.remove(removeIterator.next());
        }
    }

    private class RegistryElement {
        private int state = 0;
        private ArrayList realObjects = null;

        public RegistryElement(Object obj) {
            if (this.realObjects == null) {
                this.realObjects = new ArrayList();
            }
            this.realObjects.add(obj);
            RegistryManager registryManager2 = RegistryManager.this;
            registryManager2.numObjects = registryManager2.numObjects + 1;
        }

        public void addNewObject(Object obj) {
            if (this.realObjects == null) {
                this.realObjects = new ArrayList();
            }
            this.realObjects.add(obj);
            RegistryManager registryManager = RegistryManager.this;
            registryManager.numObjects = registryManager.numObjects + 1;
        }

        public void changeState(int newState) {
            if (newState > 0 && newState <= 2) {
                this.state = newState;
            }
        }

        public ArrayList getRealObjects() {
            return this.realObjects;
        }

        public int howManyObjects() {
            return RegistryManager.this.numObjects;
        }
    }
}

