/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.IAnimationProcessor;
import org.eclipse.ui.internal.progress.ImageAnimationProcessor;
import org.eclipse.ui.internal.progress.ProgressMessages;

public class IconAnimationItem
extends AnimationItem {
    Canvas imageCanvas;
    GC imageCanvasGC;
    ImageAnimationProcessor animationProcessor;

    IconAnimationItem(WorkbenchWindow workbenchWindow, IAnimationProcessor processor) {
        super(workbenchWindow);
        Assert.isTrue(processor instanceof ImageAnimationProcessor);
        this.animationProcessor = (ImageAnimationProcessor)processor;
    }

    protected Control createAnimationItem(Composite parent) {
        final AnimationManager manager = AnimationManager.getInstance();
        this.imageCanvas = new Canvas(parent, 0);
        this.imageCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                IconAnimationItem.this.paintImage(event, IconAnimationItem.this.animationProcessor.getImage(), IconAnimationItem.this.animationProcessor.getImageData()[0]);
            }
        });
        this.imageCanvasGC = new GC((Drawable)this.imageCanvas);
        this.imageCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IconAnimationItem.this.imageCanvasGC.dispose();
            }
        });
        this.imageCanvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent arg0) {
                arg0.result = manager.isAnimated() ? ProgressMessages.getString("AnimationItem.InProgressStatus") : ProgressMessages.getString("AnimationItem.NotRunningStatus");
            }
        });
        return this.imageCanvas;
    }

    public Control getControl() {
        return this.imageCanvas;
    }

    public Rectangle getImageBounds() {
        return this.animationProcessor.getImageBounds();
    }
}

