/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.graph;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;

public class Edge {
    public int cut;
    public Object data;
    public int delta = 1;
    public boolean flag;
    public boolean isFeedback = false;
    public int offsetSource = -1;
    public int offsetTarget = -1;
    public Node source;
    public Node target;
    public int padding = 10;
    public Point start;
    public Point end;
    public boolean tree;
    public NodeList vNodes;
    public int weight = 1;
    public int width = 1;

    public Edge(Node source, Node target) {
        this(null, source, target);
    }

    public Edge(Node source, Node target, int delta, int weight) {
        this(source, target);
        this.delta = delta;
        this.weight = weight;
    }

    public Edge(Object data, Node source, Node target) {
        this.data = data;
        this.source = source;
        this.target = target;
        source.outgoing.add(this);
        target.incoming.add(this);
    }

    public int getIndexForRank(int rank) {
        if (this.source.rank == rank) {
            return this.source.index;
        }
        if (this.target.rank == rank) {
            return this.target.index;
        }
        if (this.vNodes != null) {
            return this.vNodes.getNode((int)(rank - this.source.rank - 1)).index;
        }
        return -1;
    }

    public int getLength() {
        return this.target.rank - this.source.rank;
    }

    public int getSlack() {
        return this.target.rank - this.source.rank - this.delta;
    }

    public int getSourceOffset() {
        if (this.offsetSource != -1) {
            return this.offsetSource;
        }
        return this.source.getOffsetOutgoing();
    }

    public int getTargetOffset() {
        if (this.offsetTarget != -1) {
            return this.offsetTarget;
        }
        return this.target.getOffsetIncoming();
    }

    public Node opposite(Node end) {
        if (this.source == end) {
            return this.target;
        }
        return this.source;
    }

    public void invert() {
        this.source.outgoing.remove(this);
        this.target.incoming.remove(this);
        Node oldTarget = this.target;
        this.target = this.source;
        this.source = oldTarget;
        int temp = this.offsetSource;
        this.offsetSource = this.offsetTarget;
        this.offsetTarget = temp;
        this.target.incoming.add(this);
        this.source.outgoing.add(this);
        if (this.start != null) {
            Point pt = this.start;
            this.start = this.end;
            this.end = pt;
        }
        if (this.vNodes != null) {
            NodeList newVNodes = new NodeList();
            int j = this.vNodes.size() - 1;
            while (j >= 0) {
                newVNodes.add(this.vNodes.getNode(j));
                --j;
            }
            this.vNodes = newVNodes;
        }
    }

    public String toString() {
        return "{" + this.source + "} -> {" + this.target + "}";
    }
}

