/* config file parser functions
 *
 * (C) 2000-2003 by Harald Welte <laforge@gnumonks.org>
 * (C) 2004 by Michal Kwiatkowski <ruby@joker.linuxstuff.pl>
 *
 * This code is released under the terms of GNU GPL.
 */

#ifndef _CONFFILE_H
#define _CONFFILE_H

#include <sys/types.h>


#define CONFIG_LINE_LEN 1024
#define CONFIG_KEY_LEN	32
#define CONFIG_VALUE_LEN (CONFIG_LINE_LEN - CONFIG_KEY_LEN)

enum {
	CONFIG_TYPE_INT,
	CONFIG_TYPE_HEX,
	CONFIG_TYPE_STRING,
	CONFIG_TYPE_BOOLEAN,
	CONFIG_TYPE_MEM,
};

enum {
	CONFIG_OPT_NONE,
	CONFIG_OPT_MANDATORY,
	CONFIG_OPT_MULTI,
	CONFIG_OPT_IGNORE,
	CONFIG_OPT_ANY,
};

typedef struct config_entry {
	struct config_entry *	next;
	char			key[CONFIG_KEY_LEN];
	u_int8_t		type,
				options,
				hit;
	union {
		char	string[CONFIG_VALUE_LEN];
		int 	value;
	} u;
} config_entry_t;


/* config_read() return values */
enum {
	CONFIG_RET_ERROR,	/* syntax error */
	CONFIG_RET_MISSING,	/* given block+section combination not found */
	CONFIG_RET_OK,		/* all options read successfuly */
	CONFIG_RET_MORE,	/* found another options with CONFIG_OPT_MULTI set */
};

/* config_read() flags */
enum {
	CONFIG_READ_IGNORE	= 0x1,	/* ignore options not in @list */
	CONFIG_READ_REWIND	= 0x2,	/* rewind @section->curr to its begining */
};

int config_open(char *path);
int is_section(const char *block, const char *section);
int is_block(const char *block);
int config_read(const char *block, const char *section, config_entry_t *list, const int flags);
int config_close(void);


#endif /* conffile.h */

