//
// C++ Implementation: lineoutputgenerator
//
// Description:
//
//
// Author: Lorenzo Bettini <bettini@gnu.org>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "lineoutputgenerator.h"

#include <iomanip>
#include "linenumdigit.h"
#include "my_sstream.h"
#include "maingeneratormap.h"
#include "textgen.h"

using namespace std;

LineOutputGenerator::LineOutputGenerator(OutputBuffer& buff, ostream& os, bool genref):
  OutputGenerator(buff, os), generate_ref(genref), line_num(1)
{
  line_num_generator = generatormap->getGenerator("linenum");
}


LineOutputGenerator::~LineOutputGenerator()
{
}


void LineOutputGenerator::generate_line(const string& line)
{
  generate_line_info();
  ++line_num;
  OutputGenerator::generate_line(line);
}

void LineOutputGenerator::reset()
{
    OutputGenerator::reset();
    line_num = 1;
}

void
LineOutputGenerator::generate_line_info()
{
  ostringstream sout;

  sout << std::setw (line_num_digit) << std::setfill ('0')
        << line_num << ": ";

  string line_str = line_num_generator->generateEntire(sout.str().c_str());

  if (generate_ref) {// Oliver Fischer * plexus@snafu.de
    sout.str("");
    sout << "<a name=\"line" << line_num << "\">" << line_str << "</a>";
    line_str = sout.str();
  }

  output_string(line_str);
}
