
##"slib" script; Find a Scheme implementation and initialize SLIB in it.
#Copyright (C) 2003 Aubrey Jaffer
#
#Permission to copy this software, to modify it, to redistribute it,
#to distribute modified versions, and to use it for any purpose is
#granted, subject to the following restrictions and understandings.
#
#1.  Any copy made of this software must include this copyright notice
#in full.
#
#2.  I have made no warranty or representation that the operation of
#this software will be error-free, and I am under no obligation to
#provide any services, by way of maintenance, update, or otherwise.
#
#3.  In conjunction with products arising from the use of this
#material, there shall be no use of my name in any advertising,
#promotional, or sales literature without prior written consent in
#each case.

usage="Usage: slib [--version | -v]

  Display version information and exit successfully.

Usage: slib SCHEME

  Initialize SLIB in Scheme implementation SCHEME.

Usage: slib

  Initialize SLIB session using executable 'scheme', 'scm',
  'mzscheme', 'guile', 'gsi' or 'slib48'."

case "$1" in
    -v | --ver*) echo slib "$VERSION"; exit 0;;
    "")
	if type scheme>/dev/null 2>&1; then
	    command=scheme
	fi;;
    -*) echo "$usage"; exit 1;;
    *)
	command="$1"
	shift
esac
# If more arguments are supplied, then err out.
if [ ! -z "$1" ]; then
    echo "$usage"; exit 1
fi

if type $command>/dev/null 2>&1; then
  SPEW="`$command --version < /dev/null 2>&1`"
  if echo ${SPEW} | grep -q 'Initialize load-path (colon-list of directories)' \
					   ; then implementation=elk
  elif echo ${SPEW} | grep -q 'MIT Scheme' ; then implementation=mit
  elif echo ${SPEW} | grep -q 'UMB Scheme' ; then implementation=umb
  elif echo ${SPEW} | grep -q 'scheme48'   ; then implementation=s48
  elif echo ${SPEW} | grep -q 'MzScheme'   ; then implementation=plt
  elif echo ${SPEW} | grep -q 'Guile'      ; then implementation=gui
  elif echo ${SPEW} | grep -q 'gambc'      ; then implementation=gam
  elif echo ${SPEW} | grep -q 'SCM'        ; then implementation=scm
  else implementation=
  fi
elif [ ! -z "$command" ]; then
  echo "Program '$command' not found."
  exit 1
fi

if [ -z "$command" ];
then
    if type scm>/dev/null 2>&1; then
	command=scm; implementation=scm
    elif type gsi>/dev/null 2>&1; then
	command=gsi; implementation=gam
    elif type mzscheme>/dev/null 2>&1; then
	command=mzscheme; implementation=plt
    elif type guile>/dev/null 2>&1; then
	command=guile; implementation=gui
    elif type slib48>/dev/null 2>&1; then
	command=slib48; implementation=s48
    else
	echo No Scheme implementation found.
	exit 1
    fi
fi

case $implementation in
  scm);;
  s48);;
  *) if [ -z "${SCHEME_LIBRARY_PATH}" ]; then
	export SCHEME_LIBRARY_PATH=`rpm -ql slib 2>/dev/null \
	   | grep require.scm | sed 's%require.scm%%'`
     fi
     if [ -z "${SCHEME_LIBRARY_PATH}" ]; then
       if [ -d /usr/local/lib/slib/ ]; then
	  export SCHEME_LIBRARY_PATH=/usr/local/lib/slib/
       elif [ -d /usr/share/slib/ ]; then
	  export SCHEME_LIBRARY_PATH=/usr/share/slib/
       fi
     fi;;
esac

# for gambit
case $implementation in
  gam) if [ -z "${LD_LIBRARY_PATH}" ]; then
	export LD_LIBRARY_PATH=/usr/local/lib
	fi;;
esac

case $implementation in
    scm) exec $command -ip1 -l ${SCHEME_LIBRARY_PATH}scm.init $*;;
    elk) exec $command -i -l ${SCHEME_LIBRARY_PATH}elk.init;;
    gam) exec $command -:s ${SCHEME_LIBRARY_PATH}gambit.init - $*;;
    plt) exec $command -f ${SCHEME_LIBRARY_PATH}DrScheme.init $*;;
    gui) exec $command -l ${SCHEME_LIBRARY_PATH}guile.init $*;;
    mit) exec $command -load ${SCHEME_LIBRARY_PATH}mitscheme.init $*;;
    s48) exec $command $*;;
    umb) echo "umb-scheme vicinities are too wedged to run slib"; exit 1;;
    *)   exit 1;;
esac
