//  libsigcperl -- a helper library for writing XSUB wrappers of libsigc++
//  Copyright (C) 2002 Ron Steinke
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Library General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Library General Public License for more details.
//
//  You should have received a copy of the GNU Library General Public
//  License along with this library; if not, write to the 
//  Free Software Foundation, Inc., 59 Temple Place - Suite 330, 
//  Boston, MA  02111-1307  USA.

#include "signal_base.h"
#include <sigc++/adaptor.h>
#include <sigc++/object_slot.h>

using namespace SigCPerl;

static Data
slot_conv_func(const Data& data, I32 flags, Data call_data,
	void *node) throw(BadConvertVal)
{
  SigC::SlotNode* slot=static_cast<SigC::SlotNode*>(
    ((SigC::AdaptorSlotNode*)(node))->slot_.impl());
  return ((Slot::Proxy)(slot->proxy_))(Data(data, call_data), flags, slot);
}

Slot SigCPerl::SignalBase::slot() throw()
{
  return Slot(new SigC::AdaptorSlotNode((SigC::FuncPtr) slot_conv_func,
    SigC::slot(*this, &SignalBase::emit)), Data());
}

ParentBox::ParentBox(SV *parent) : m_parent(parent ? newSVsv(parent) : 0)
{

}

ParentBox::~ParentBox()
{
  if(m_parent)
    SvREFCNT_dec(m_parent);
}
