package Scoop;
use strict;

my $DEBUG = 0;

sub frontpage_view {
	my $S = shift;
	my $story_type = shift;
	my $topic   = $S->{CGI}->param('user');
	my $spage   = $S->{CGI}->param('page') || 1;
	my $op      = $S->{CGI}->param('op');
	my $section = $S->{CGI}->param('section');
	
	my $story_params = {-type => $story_type};
	$story_params->{-topic} = $topic if ($topic ne '');
	$story_params->{-page}  = $spage if $spage;

	# if they don't have permission to view this section, let them know
	if( $section && $section ne ''		&&
		$section ne '__all__'			&&
		!$S->have_section_perm( 'norm_read_stories', $section ) ) {

		if( $S->have_section_perm( 'deny_read_stories', $section ) ) {
			return qq|<b>%%norm_font%%Sorry, you don't have permission to read stories posted to section '$section'.%%norm_font_end%%</b>|;
		} else {
			return qq|<b>%%norm_font%%Sorry, I can't seem to find section '$section'.%%norm_font_end%%</b>|;
		}

	}

	my $stories = $S->getstories($story_params);
	my $page;

	foreach my $story (@{$stories}) {
		$page .= $S->story_summary($story);
		my ($more, $stats, $section) = $S->story_links($story);
		$page =~ s/%%readmore%%/$more/g;
		$page =~ s/%%stats%%/$stats/g;
		$page =~ s/%%section_link%%/$section/g;
	}

	# now make the links for next/previous pages, and put them on
	my ($np, $pp) = ($spage + 1, $spage - 1);
	my $pre_link  = ($op eq 'section') ? "section/$section" : "$op";

	if ($section eq 'Diary' && $topic) {
		my $uid   = $topic;
		$uid      =~ s/diary_//;
		$pre_link = "user/uid:$uid/diary";
	}

	my $change_page = qq|
<table border="0" cellspacing="0" cellpadding="0" width="100%">
<tr><td>|;
	$change_page .= qq|<A CLASS="light" HREF="%%rootdir%%/$pre_link/$pp">%%prev_page_link%%</A>| if $pp >= 1;
	$change_page .= qq|</td><td align="right">|;
	$change_page .= qq|<A CLASS="light" HREF="%%rootdir%%/$pre_link/$np">%%next_page_link%%</A>| if @{$stories} && (@{$stories} == $S->{UI}->{VARS}->{maxstories});
	$change_page .= qq|</td></tr></table>\n|;

	$page  = $change_page . $page if $pp >= 1;
	$page .= $change_page;

	return $page;
}

sub story_links {
	my $S = shift;
	my $story = shift;
	
	my $edit = '';
	if ($S->have_perm('story_list')) {
		$edit = qq|[<A HREF="%%rootdir%%/admin/story/$story->{sid}">edit</A>]|;
	} 

	# This is so that if there is no body to the article, it just shows
	# "Comments >>" (or whatever no_body_txt is), instead of Read More
	my $text = ($story->{bodytext} ne '')? '%%readmore_txt%%' : '%%no_body_txt%%';
	# just in case you don't have no_body_txt set
	$text = ($text eq '') ? 'Comments >>' : $text;	

	my $more .= qq|<A HREF="%%rootdir%%/story/$story->{sid}">$text</A> | unless
		(($S->have_section_perm(hide_read_comments => $story->{section})) &&
		($S->have_section_perm(hide_post_comments => $story->{section})) &&
		($story->{bodytext} eq ''));
			
	# either count words or bytes in the story
	# if you count bytes, it costs you an extra SELECT statement
	# to the database
	# if you count words, it costs you an extra call to 
	# split

	my $bits;
	my @tmp_array;
	if( $S->{UI}->{VARS}->{story_count_words} == 1 )
	{
		# used to split to @_, but that gave a 'deprecated' message on startup, thus tmp_array
		@tmp_array = split /\s/, $story->{bodytext}.$story->{introtext};
		$bits = @tmp_array;
		$bits .= ($bits == 1) ? " word" : " words";
	} else {
		$bits = $S->count_bits($story->{sid});

	}

	my @readmore = ();
	push @readmore, sprintf( "%d %s%s",
				 $story->{commentcount},
				 'comment',
				 $story->{commentcount} != 1 ? 's' : ''
				 ) if( $story->{commentcount} && $S->have_section_perm('norm_read_comments',$story->{section}) );

	my $show = $S->{UI}->{VARS}->{show_new_comments};
	if ($show eq "all" && !$S->have_section_perm('hide_read_comments',$story->{section}) ) {
		my $num_new = $S->new_comments_since_last_seen($story->{sid});
		push @readmore, "<B>$num_new</B> new" if $num_new;
	}

	push @readmore, "$bits in story" if ($bits and $story->{bodytext});
	
	my $section = $S->get_section($story->{section});
	my $sec_url = qq|%%rootdir%%/section/$story->{section}|;
	
	my $section_link = qq(<A CLASS="section_link" href="$sec_url">$section->{title}</a>);
		
	my $stats = sprintf( '(%s)', join ', ', @readmore );

	# get rid of empty parenthasis if 0 comments and 0 bytes in body
	if( $stats eq '()' ) {
		$stats = '';
	}

	$more .= qq| $edit |;
	
	return ($more, $stats, $section_link);
}


sub focus_view {
	my $S = shift;

	my $mode = $S->{CGI}->param('mode');
	my $sid = $S->{CGI}->param('sid');
	
	my $comments;
	
	#$S->{UI}->{BLOCKS}->{STORY} = qq|
	#	<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width="100%">|;
	#$S->{UI}->{BLOCKS}->{COMMENTS} = qq|
	#	<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width="100%">|;
	
	my ($story_data, $story) = $S->displaystory($sid);
	
	 $S->{UI}->{BLOCKS}->{subtitle} .= $story_data->{title} || $S->{UI}->{VARS}->{slogan};
	$S->{UI}->{BLOCKS}->{subtitle} =~ s/</&lt;/g;
	$S->{UI}->{BLOCKS}->{subtitle} =~ s/>/&gt;/g;

	my $checkstory = $S->_check_for_story($sid);

	my $commentstatus = $S->_check_commentstatus($sid);
	
	unless ($checkstory && $story_data && $story) {
		$S->{UI}->{BLOCKS}->{STORY} .= qq|
			<TABLE CELLPADDING=0 CELLSPACING=0 BORDER=0 width="100%">
				<TR><TD>%%norm_font%%<B>Sorry. I can\'t seem to find that story.</B>%%norm_font_end%%</TD></TR>
			</TABLE>|;
			
		return;
	}
	
	
	$S->{UI}->{BLOCKS}->{STORY} .= $story;
	if ($story_data->{displaystatus} == -2) {
		$mode = 'moderate';
	}	
	
	if ($story_data->{displaystatus} <= -2) { 
		if (!$S->have_perm('moderate')) {
			$S->{UI}->{BLOCKS}->{STORY} = qq|
			<TABLE WIDTH="100%" BORDER=0 CELLPADDING=0 CELLSPACING=0>
			<TR BGCOLOR="%%title_bgcolor%%">
				<TD>%%title_font%%Permission Denied.%%title_font_end%%</TD>
			</TR>
			<TR><TD>%%norm_font%%Sorry, but you can only moderate stories if you have a valid user account. 
			Luckily for you, making one is easy! Just <A HREF="%%rootdir%%/newuser">go here</A> to get started.
			%%norm_font_end%%</TD></TR>
			</TABLE>|;
			return;
		}
		
		my $message = $S->_story_mod_write($sid);
		if ($message) {
			$S->{UI}->{BLOCKS}->{STORY} .= qq|<TABLE WIDTH="100%" BORDER=0 CELLPADDING=0 CELLSPACING=0><TR><TD>%%norm_font%%$message %%norm_font_end%%</TD></TR></TABLE>|;
			$S->{UI}->{BLOCKS}->{STORY} .= '<P>';
		}
		my ($which, $mod_stuff) = $S->story_mod_display($sid);
		my $author_control = $S->author_control_display($story_data);
		warn "Author block is:\n$author_control\n" if $DEBUG;

		$S->{UI}->{BLOCKS}->{STORY} .= $author_control;
		
		if ($which eq 'content') {
			$S->{UI}->{BLOCKS}->{STORY} .= $mod_stuff if ($story_data->{aid} ne $S->{NICK});
		} else {
			$S->{UI}->{BLOCKS}->{BOXES} .= $mod_stuff;
		}
	}
	
	$comments = $S->display_comments($sid, '0') unless $commentstatus == -1;

	$S->update_seen_if_needed($sid);# unless ($S->{UI}->{VARS}->{use_static_pages});
	
	$S->{UI}->{BLOCKS}->{STORY} .= $S->story_nav($sid);
	#$S->{UI}->{BLOCKS}->{STORY} .= '<TR><TD>&nbsp;</TD></TR>';

	$S->{UI}->{BLOCKS}->{COMMENTS} .= $S->comment_controls($sid, 'top');
	$S->{UI}->{BLOCKS}->{COMMENTS} .= qq|$comments|;

	if ($comments) {
		$S->{UI}->{BLOCKS}->{COMMENTS} .= $S->comment_controls($sid, 'top');
	}
	
	#$S->{UI}->{BLOCKS}->{STORY} .= '</TABLE>';
	#$S->{UI}->{BLOCKS}->{COMMENTS} .= '</TABLE>';

	
	return;
}

# DEPRECATED
# SHOULD PROBABLY REMOVE.
sub olderlist {
	my $S = shift;
	
	my $page = $S->{CGI}->param('page') || 1;
	
	my $next_page = $page + 1;
	my $last_page = $page - 1;
	my $num = $S->{UI}->{VARS}->{storylist};
	my $limit;
	my $get_num = $num + 1;
	my $displayed = $S->{UI}->{VARS}->{maxstories} + $S->{UI}->{VARS}->{maxtitles};
	my $offset = ($num * ($page - 1)) + $displayed;
	my $date_format = "%a %b %D, %Y at %r";
	my $op = $S->{CGI}->param('op');
	
	$limit = "$offset, $get_num";
	
	my ($rv, $sth) = $S->db_select({
		WHAT => qq|sid, aid, tid, DATE_FORMAT(time, "$date_format") AS ftime, title|,
		FROM => 'stories',
		WHERE => 'displaystatus >= 0',
		ORDER_BY => 'time DESC',
		LIMIT => qq|$limit|});
	
	my $list;
	my $i = $offset + 1;
	my $stop = $offset + $num;
	
	while ((my $story = $sth->fetchrow_hashref) && ($i <= $stop)) {
		warn "In olderlist, getting count for $story->{sid}\n" if $DEBUG;
		$story->{commentcount} = $S->_commentcount($story->{sid});
		$list .= qq|
		<P>
		<B>$i) <A HREF="%%rootdir%%/story/$story->{sid}">$story->{title}</A></B> by $story->{aid}, $story->{commentcount} comments<BR>
		posted on $story->{ftime}|;
		$i++;
	}
	$sth->finish;
	
	my $content = qq|
		<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 WIDTH=100%>
		<TR>
		<TD COLSPAN=2 BGCOLOR="%%title_bgcolor%%">%%title_font%%<B>Older Stories</B>%%title_font_end%%</TD>
		</TR>
		<TR><TD COLSPAN=2>&nbsp;</TD></TR>
		<TR><TD COLSPAN=2>%%norm_font%%
		$list
		%%norm_font_end%%</TD></TR>|;
	
	$content .= qq|
		<TR><TD COLSPAN=2>&nbsp;</TD></TR>
		<TR>
			<TD>%%norm_font%%<B>|;
	if ($last_page >= 1) {
		$content .= qq|&lt; <A HREF="%%rootdir%%/?op=$op;page=$last_page">Last $num</A>|;
	} else {
		$content .= '&nbsp;';
	}
	$content .= qq|</B>%%norm_font_end%%</TD>
		<TD ALIGN="right" COLSPAN=2>%%norm_font%%<B>|;
	
	if ($rv >= ($num + 1)) {
		$content .= qq|
		<A HREF="%%rootdir%%/?op=$op;page=$next_page">Next $num</A> &gt;%%norm_font_end%%|;
	} else {
		$content .= '&nbsp;';
	}
	
	$content .= qq|</B>%%norm_font_end%%</TD>
	</TR>
	</TABLE>|;
	
	$S->{UI}->{BLOCKS}->{CONTENT} = $content;
	return;
}
		
	
1;
