/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include <termios.h>

#include <sys/types.h>

void tty_open (struct port_args_t* args);
void tty_close();

#ifdef OS2
#define speed_t int
#undef B9600
#undef B19200
#undef B38400
#undef B57600
#undef B115200
#define B9600 9600
#define B19200 19200
#define B38400 38400
#define B57600 57600
#define B115200 115200
#endif
speed_t tty_speed(char *newttyspeed);

int  tty_write (const char* data, size_t count);
char* tty_read_line (int (*stop_condition)(const char*,const size_t));

// \x1a represents Ctrl-Z (represents end of data stream)
#define tty_write_data(data,count) (tty_write(data,count) && tty_write("\x1a",1))
