// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_VariableDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "symbol_table.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


extern symbol_table *cgen_sym_tab_ptr;


IIRScram_VariableDeclaration::IIRScram_VariableDeclaration() {
  _my_clone = NULL;
}


IIRScram_VariableDeclaration::~IIRScram_VariableDeclaration() {}


void 
IIRScram_VariableDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "variable ";
  _publish_vhdl_declarator_with_colon(_vhdl_out);
  _publish_vhdl_subtype_indication_with_expression(_vhdl_out);
}

void 
IIRScram_VariableDeclaration::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc" );
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    if (get_value() != NULL) {
      get_value()->_add_decl_into_cgen_symbol_table();
    }
    cgen_sym_tab_ptr->add_declaration(this);
  }

  IIRScram_Declaration::_set_scoping_prefix();
  IIRScram::_publish_cc_prefix_string( _cc_out );
  IIR_ObjectDeclaration::_publish_cc_lvalue( _cc_out );
  IIRScram_Declaration::_reset_scoping_prefix();
}


// ASSUMPTION: This method is called for publishing of ranges only, which
// are decided according to the initialization value at compile time.
void
IIRScram_VariableDeclaration::_publish_cc_value( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_value" );
  
  if (get_value() != NULL) {
    get_value()->_publish_cc_value( _cc_out );
  } 
  else {
    if( get_subtype()->_is_iir_scalar_type_definition() ){ 
      dynamic_cast<IIR_ScalarTypeDefinition *>(get_subtype())->get_left()->_publish_cc_value(_cc_out);
    }
  }
}


void 
IIRScram_VariableDeclaration::_publish_cc_universal_value( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_universal_value" );
  
  if (get_value() != NULL) {
    get_value()->_publish_cc_universal_value( _cc_out );
  }
  else {
    if (get_subtype()->_is_iir_scalar_type_definition() == TRUE){
      IIR_ScalarTypeDefinition *typeDef = 
	(IIR_ScalarTypeDefinition *)get_subtype();
      typeDef->get_left()->_publish_cc_universal_value( _cc_out );
    }
  }
}

void 
IIRScram_VariableDeclaration::_publish_cc_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_init" );
  
  if (get_value() == NULL) {
    switch(get_subtype()->get_kind()) {
    case IIR_ARRAY_TYPE_DEFINITION:
    case IIR_ARRAY_SUBTYPE_DEFINITION:
      if (get_subtype()->_has_access_type() == FALSE) {
	_publish_cc_composite_init( _cc_out );
      }
      break;
    case IIR_RECORD_TYPE_DEFINITION:
      _publish_cc_composite_init( _cc_out );
      break;
    case IIR_ACCESS_TYPE_DEFINITION:
    case IIR_ACCESS_SUBTYPE_DEFINITION:
      _publish_cc_access_init( _cc_out );
      break;
    case IIR_FILE_TYPE_DEFINITION:
      _publish_cc_file_init( _cc_out );
      break;
    default:
      _publish_cc_scalar_init( _cc_out );
      break;
    }
  }
}

void
IIRScram_VariableDeclaration::_publish_cc_scalar_init( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_scalar_init" );
  _cc_out << OS("assignVariable(");
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  _cc_out << "," << NL();
  get_subtype()->_publish_cc_left( _cc_out );
  _cc_out << CS(", defaultInfo, defaultInfo);");
}


void 
IIRScram_VariableDeclaration::_publish_cc_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_data" );
  
  _cc_out << "getState()->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}


IIRScram_Declaration::declaration_type 
IIRScram_VariableDeclaration::_get_type() {
  return VARIABLE;
}


void 
IIRScram_VariableDeclaration::_publish_cc_wait_data( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_wait_data" );
  
  if (!cgen_sym_tab_ptr->in_scope(this)) {
    cgen_sym_tab_ptr->add_declaration(this);
  }
  _cc_out << "s->";
  _get_declarator()->_publish_cc_lvalue( _cc_out );
}


void
IIRScram_VariableDeclaration::_publish_cc_composite_init( published_file &_cc_out ) {
  ostringstream labelstr;
  const string procname = _get_current_publish_name();
  IIR* temporaryNode = _get_current_publish_node();

  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_composite_init" );

  //Reset the index counter since a new variable declaration is initialized
  _set_index_level( 0 );

  labelstr << *_get_declarator();

  _set_current_publish_name( labelstr.str() );
  _set_current_publish_node( this );
  get_subtype()->_publish_cc_composite_init( _cc_out );
  _set_current_publish_name( procname );
  _set_current_publish_node( temporaryNode );
}


void
IIRScram_VariableDeclaration::_publish_cc_access_init( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_VariableDeclaration::_publish_cc_access_init" );
  
  _get_declarator()->_publish_cc_lvalue( _cc_out );
  _cc_out << ".val = 0;" << NL();
}


void
IIRScram_VariableDeclaration::_publish_cc_file_init( published_file &_cc_out ) {
  //Yet to do file declarations
  //I don't know if this function will ever be entered
  cerr << "Mystery abort in IIRScram_VariableDeclaration::_publish_cc_file_init( published_file &_cc_out )!\n";
  abort();
}

const string
IIRScram_VariableDeclaration::_get_cc_object_type() {
  return "VARIABLE";
}


const string
IIRScram_VariableDeclaration::_get_cc_kernel_type(){
  return get_subtype()->_get_cc_kernel_type();
}

IIR*
IIRScram_VariableDeclaration::_clone() {
  if ( _my_clone == NULL ) {
    _my_clone = new IIR_VariableDeclaration;
    IIRScram_ObjectDeclaration::_clone(_my_clone);

    _my_clone->set_value( get_value() );
  }
  return _my_clone;
}

visitor_return_type *
IIRScram_VariableDeclaration::_accept_visitor( node_visitor *visitor, 
					       visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_VariableDeclaration(this, arg);
}
