
#ifndef IIRSCRAM_REPORT_STATEMENT_HH
#define IIRSCRAM_REPORT_STATEMENT_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Umesh Kumar V. Rajasekaran

#include "IIRBase_ReportStatement.hh"

class IIR_List;
class IIR_AboveAttribute;

class IIRScram_ReportStatement : public IIRBase_ReportStatement {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);

  void _publish_cc( published_file &_cc_out );
  void _get_list_of_input_signals( set<IIR> * );
  
  IIR *_get_report_expression(){ return get_report_expression(); }
  void _set_report_expression( IIR *new_expr ){ set_report_expression( new_expr ); }
  
  IIR *_get_severity_expression(){ return get_severity_expression(); }
  void _set_severity_expression( IIR *new_expr ){ set_severity_expression( new_expr ); }

  void _type_check();

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_ReportStatement() {};
  virtual ~IIRScram_ReportStatement() = 0;

  /** This method publishes the string "true" since report statements are kind of
      like assertions that always fire. */
  void _publish_cc_assertion_condition( published_file &_cc_out );
    
private:
};
#endif
