'\"
'\" Generated from file './img-ppm.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
'\"
'\" -*- tcl -*- doctools
'\" -*- tcl -*- doctools = format-header.inc
.so man.macros
.TH "img-ppm" n 1.3  "Img"
.BS
.SH "NAME"
img-ppm \- Img, Portable Pixmap format (ppm)
.SH "SYNOPSIS"
package require \fBTk \fR
.sp
package require \fBimg::ppm  ?1.3?\fR
.sp
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBimg::ppm\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::ppm\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR so
that it supports files containing raster images in the
Portable Pixmap format (ppm). More specifically
\fBimg::ppm\fR extends \fBTk\fR's \fBphoto\fR
image type.
.PP
The name of the new format handler is \fBppm\fR.
This handler does not provide additional configuration options.
'\" -*- tcl -*- doctools = format-middle.inc
.PP
All of the above means that in a call like
.TP
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.IP [1]
Image data in ppm format (options \fB-data\fR and \fB-file\fR) is
detected automatically.
.IP [2]
The format name \fBppm\fR is recognized by the option \fB-format\fR.
.SH "SUPPORTED PPM TYPES"
There are two types of PPM files: RAW (binary) and ASCII.
Currently only the RAW format is implemented.
.nf
  8-bit pixels: Grayscale, also known as PGM.
 24-bit pixels: True-color (RGB, each channel 8 bit).

 List of currently supported features:

 Type   |     Read      |     Write     |
        | -file | -data | -file | -data |
 ----------------------------------------
  8-bit | Yes   | Yes   | Yes   | Yes   |
 24-bit | Yes   | Yes   | Yes   | Yes   |

.fi
'\" -*- tcl -*- doctools = format-footer.inc
.SH "SEE ALSO"
img-bmp, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH "KEYWORDS"
image handling, ppm, tk
.SH "COPYRIGHT"
.nf
Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
.fi