// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __boxannulus_h__
#define __boxannulus_h__

#include "basebox.h"

class BoxAnnulus : public BaseBox {
private:
  void updateHandles();
  void sortSize();

public:
  BoxAnnulus(const BoxAnnulus&);
  BoxAnnulus(FrameBase* p, const Vector& ctr, const Vector& s, double a,
	     const char* clr, int w, const char* f, const char* t, 
	     unsigned short prop, const char* c, const List<Tag>& tag);

  BoxAnnulus(FrameBase* p, const Vector& ctr, 
	     const Vector& inner, const Vector& outer, int, double a,
	     const char* clr, int w, const char* f, const char* t, 
	     unsigned short prop, const char* c, const List<Tag>& tag);

  BoxAnnulus(FrameBase* p, const Vector& ctr, double a, int an, Vector* s,
	     const char* clr, int w, const char* f, const char* t, 
	     unsigned short prop, const char* c, const List<Tag>& tag);

  Marker* dup() {return new BoxAnnulus(*this);}
  void editBegin(int);
  void edit(const Vector&, int);
  void editEnd();

  const Vector* getSize() {return size;}
  void setSize(const Vector&, const Vector&, int);
  void setSize(const Vector*, int);
  int addSize(const Vector&);
  void deleteSize(int h);

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listSAOimage(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listPros(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
};

#endif
